/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.json.ProvJSONStatement;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;

public class ProvDocumentDeserializer
implements JsonDeserializer<Document> {
    Namespace documentNamespace;
    Namespace currentNamespace;
    private static final String PROV_JSON_PREFIX = "prefix";
    private final ProvFactory pf;
    private final Name name;
    private final ValueConverter vconv;

    public ProvDocumentDeserializer(ProvFactory pf) {
        this.pf = pf;
        this.name = pf.getName();
        this.vconv = new ValueConverter(pf);
    }

    public QualifiedName stringToQualifiedName(Namespace namespace, String val, ProvFactory pf, boolean flag) {
        return namespace.stringToQualifiedName(val, pf, flag);
    }

    public Document deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject provJSONDoc = json.getAsJsonObject();
        this.documentNamespace = this.currentNamespace = this.decodePrefixes(provJSONDoc);
        List<StatementOrBundle> statements = this.decodeBundle(provJSONDoc);
        Document doc = this.pf.newDocument();
        doc.setNamespace(this.currentNamespace);
        doc.getStatementOrBundle().addAll(statements);
        return doc;
    }

    private Namespace decodePrefixes(JsonObject bundleStructure) {
        Namespace ns = new Namespace();
        ns.addKnownNamespaces();
        JsonObject prefixes = this.getObjectAndRemove(bundleStructure, PROV_JSON_PREFIX);
        if (prefixes != null) {
            for (Map.Entry pair : prefixes.entrySet()) {
                String prefix = (String)pair.getKey();
                String uri = ((JsonElement)pair.getValue()).getAsString();
                if (prefix.equals("default")) {
                    ns.registerDefault(uri);
                    continue;
                }
                ns.register(prefix, uri);
            }
        }
        return ns;
    }

    private List<StatementOrBundle> decodeBundle(JsonObject bundleStructure) {
        ArrayList<StatementOrBundle> statements = new ArrayList<StatementOrBundle>();
        for (Map.Entry sPair : bundleStructure.entrySet()) {
            String statementType = (String)sPair.getKey();
            JsonObject statementMap = ((JsonElement)sPair.getValue()).getAsJsonObject();
            statements.addAll(this.decodeElements(statementType, statementMap));
        }
        return statements;
    }

    private List<StatementOrBundle> decodeElements(String statementType, JsonObject statementMap) {
        ArrayList<StatementOrBundle> statements = new ArrayList<StatementOrBundle>();
        for (Map.Entry pair : statementMap.entrySet()) {
            String idStr = (String)pair.getKey();
            if (((JsonElement)pair.getValue()).isJsonArray()) {
                JsonArray elements = ((JsonElement)pair.getValue()).getAsJsonArray();
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    JsonObject attributeMap = ((JsonElement)iter.next()).getAsJsonObject();
                    StatementOrBundle statement = this.decodeStatement(statementType, idStr, attributeMap);
                    statements.add(statement);
                }
                continue;
            }
            JsonObject attributeMap = ((JsonElement)pair.getValue()).getAsJsonObject();
            StatementOrBundle statement = this.decodeStatement(statementType, idStr, attributeMap);
            statements.add(statement);
        }
        return statements;
    }

    private StatementOrBundle decodeStatement(String statementType, String idStr, JsonObject attributeMap) {
        Entity statement;
        QualifiedName id;
        ProvJSONStatement provStatement = ProvJSONStatement.valueOf(statementType);
        switch (provStatement) {
            case bundle: {
                id = null;
                break;
            }
            default: {
                id = idStr.startsWith("_:") ? null : this.stringToQualifiedName(this.currentNamespace, idStr, this.pf, false);
            }
        }
        switch (provStatement) {
            case entity: {
                statement = this.pf.newEntity(id);
                break;
            }
            case activity: {
                XMLGregorianCalendar startTime = this.optionalTime("prov:startTime", attributeMap);
                XMLGregorianCalendar endTime = this.optionalTime("prov:endTime", attributeMap);
                Activity a = this.pf.newActivity(id);
                if (startTime != null) {
                    a.setStartTime(startTime);
                }
                if (endTime != null) {
                    a.setEndTime(endTime);
                }
                statement = a;
                break;
            }
            case agent: {
                statement = this.pf.newAgent(id);
                break;
            }
            case alternateOf: {
                QualifiedName alternate1 = this.optionalQualifiedName("prov:alternate1", attributeMap);
                QualifiedName alternate2 = this.optionalQualifiedName("prov:alternate2", attributeMap);
                statement = this.pf.newAlternateOf(alternate1, alternate2);
                break;
            }
            case wasAssociatedWith: {
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                QualifiedName agent = this.optionalQualifiedName("prov:agent", attributeMap);
                QualifiedName plan = this.optionalQualifiedName("prov:plan", attributeMap);
                WasAssociatedWith wAW = this.pf.newWasAssociatedWith(id, activity, agent);
                if (plan != null) {
                    wAW.setPlan(plan);
                }
                statement = wAW;
                break;
            }
            case wasAttributedTo: {
                QualifiedName entity = this.optionalQualifiedName("prov:entity", attributeMap);
                QualifiedName agent = this.optionalQualifiedName("prov:agent", attributeMap);
                statement = this.pf.newWasAttributedTo(id, entity, agent);
                break;
            }
            case bundle: {
                Namespace ns;
                this.currentNamespace = ns = this.decodePrefixes(attributeMap);
                this.currentNamespace.setParent(this.documentNamespace);
                id = this.stringToQualifiedName(this.currentNamespace, idStr, this.pf, false);
                List<StatementOrBundle> statements = this.decodeBundle(attributeMap);
                Bundle namedBundle = this.pf.newNamedBundle(id, ns, statements);
                statement = namedBundle;
                this.currentNamespace = this.documentNamespace;
                break;
            }
            case wasInformedBy: {
                QualifiedName informed = this.optionalQualifiedName("prov:informed", attributeMap);
                QualifiedName informant = this.optionalQualifiedName("prov:informant", attributeMap);
                statement = this.pf.newWasInformedBy(id, informed, informant);
                break;
            }
            case actedOnBehalfOf: {
                QualifiedName delegate = this.optionalQualifiedName("prov:delegate", attributeMap);
                QualifiedName responsible = this.optionalQualifiedName("prov:responsible", attributeMap);
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                statement = this.pf.newActedOnBehalfOf(id, delegate, responsible, activity);
                break;
            }
            case wasDerivedFrom: {
                QualifiedName generatedEntity = this.optionalQualifiedName("prov:generatedEntity", attributeMap);
                QualifiedName usedEntity = this.optionalQualifiedName("prov:usedEntity", attributeMap);
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                QualifiedName generation = this.optionalQualifiedName("prov:generation", attributeMap);
                QualifiedName usage = this.optionalQualifiedName("prov:usage", attributeMap);
                statement = this.pf.newWasDerivedFrom(id, generatedEntity, usedEntity, activity, generation, usage, null);
                break;
            }
            case wasEndedBy: {
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                QualifiedName trigger = this.optionalQualifiedName("prov:trigger", attributeMap);
                QualifiedName ender = this.optionalQualifiedName("prov:ender", attributeMap);
                XMLGregorianCalendar time = this.optionalTime("prov:time", attributeMap);
                WasEndedBy wEB = this.pf.newWasEndedBy(id, activity, trigger);
                if (ender != null) {
                    wEB.setEnder(ender);
                }
                if (time != null) {
                    wEB.setTime(time);
                }
                statement = wEB;
                break;
            }
            case wasGeneratedBy: {
                QualifiedName entity = this.optionalQualifiedName("prov:entity", attributeMap);
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                XMLGregorianCalendar time = this.optionalTime("prov:time", attributeMap);
                WasGeneratedBy wGB = this.pf.newWasGeneratedBy(id, entity, activity, time, new LinkedList());
                statement = wGB;
                break;
            }
            case wasInfluencedBy: {
                QualifiedName influencee = this.anyRef("prov:influencee", attributeMap);
                QualifiedName influencer = this.anyRef("prov:influencer", attributeMap);
                statement = this.pf.newWasInfluencedBy(id, influencee, influencer);
                break;
            }
            case wasInvalidatedBy: {
                QualifiedName entity = this.optionalQualifiedName("prov:entity", attributeMap);
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                XMLGregorianCalendar time = this.optionalTime("prov:time", attributeMap);
                WasInvalidatedBy wIB = this.pf.newWasInvalidatedBy(id, entity, activity);
                if (time != null) {
                    wIB.setTime(time);
                }
                statement = wIB;
                break;
            }
            case hadMember: {
                QualifiedName collection = this.optionalQualifiedName("prov:collection", attributeMap);
                Collection<QualifiedName> entities = this.optionalQualifiedNames("prov:entity", attributeMap);
                HadMember membership = this.pf.newHadMember(collection, entities);
                statement = membership;
                break;
            }
            case mentionOf: {
                QualifiedName specificEntity = this.optionalQualifiedName("prov:specificEntity", attributeMap);
                QualifiedName generalEntity = this.optionalQualifiedName("prov:generalEntity", attributeMap);
                QualifiedName bundle = this.optionalQualifiedName("prov:bundle", attributeMap);
                statement = this.pf.newMentionOf(specificEntity, generalEntity, bundle);
                break;
            }
            case specializationOf: {
                QualifiedName specificEntity = this.optionalQualifiedName("prov:specificEntity", attributeMap);
                QualifiedName generalEntity = this.optionalQualifiedName("prov:generalEntity", attributeMap);
                statement = this.pf.newSpecializationOf(specificEntity, generalEntity);
                break;
            }
            case wasStartedBy: {
                QualifiedName activity = this.optionalQualifiedName("prov:activity", attributeMap);
                QualifiedName trigger = this.optionalQualifiedName("prov:trigger", attributeMap);
                QualifiedName starter = this.optionalQualifiedName("prov:starter", attributeMap);
                XMLGregorianCalendar time = this.optionalTime("prov:time", attributeMap);
                WasStartedBy wSB = this.pf.newWasStartedBy(id, activity, trigger);
                if (starter != null) {
                    wSB.setStarter(starter);
                }
                if (time != null) {
                    wSB.setTime(time);
                }
                statement = wSB;
                break;
            }
            case used: {
                QualifiedName activity2 = this.optionalQualifiedName("prov:activity", attributeMap);
                QualifiedName entity2 = this.optionalQualifiedName("prov:entity", attributeMap);
                XMLGregorianCalendar time = this.optionalTime("prov:time", attributeMap);
                Used wUB = this.pf.newUsed(id);
                wUB.setActivity(activity2);
                if (entity2 != null) {
                    wUB.setEntity(entity2);
                }
                if (time != null) {
                    wUB.setTime(time);
                }
                statement = wUB;
                break;
            }
            case derivedByInsertionFrom: {
                QualifiedName before = this.optionalQualifiedName("prov:before", attributeMap);
                QualifiedName after = this.optionalQualifiedName("prov:after", attributeMap);
                List<Entry> keyEntitySet = this.optionalEntrySet("prov:key-entity-set", attributeMap);
                DerivedByInsertionFrom dBIF = this.pf.newDerivedByInsertionFrom(id, after, before, keyEntitySet, null);
                statement = dBIF;
                break;
            }
            case derivedByRemovalFrom: {
                QualifiedName before = this.optionalQualifiedName("prov:before", attributeMap);
                QualifiedName after = this.optionalQualifiedName("prov:after", attributeMap);
                List<Key> keys = this.optionalKeySet("prov:key-set", attributeMap);
                DerivedByRemovalFrom dBRF = this.pf.newDerivedByRemovalFrom(id, after, before, keys, null);
                statement = dBRF;
                break;
            }
            case hadDictionaryMember: {
                QualifiedName dictionary = this.optionalQualifiedName("prov:dictionary", attributeMap);
                List<Entry> keyEntitySet = this.optionalEntrySet("prov:key-entity-set", attributeMap);
                DictionaryMembership hDM = this.pf.newDictionaryMembership(dictionary, keyEntitySet);
                statement = hDM;
                break;
            }
            default: {
                statement = null;
            }
        }
        List<JsonElement> values = this.popMultiValAttribute("prov:type", attributeMap);
        if (!values.isEmpty()) {
            if (statement instanceof HasType) {
                List types = ((HasType)statement).getType();
                for (JsonElement value : values) {
                    types.add((org.openprovenance.prov.model.Type)this.decodeAttributeValue(value, this.name.PROV_TYPE));
                }
            } else {
                throw new UnsupportedOperationException("prov:type is not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        if (!(values = this.popMultiValAttribute("prov:label", attributeMap)).isEmpty()) {
            if (statement instanceof HasLabel) {
                List labels = ((HasLabel)statement).getLabel();
                for (JsonElement value : values) {
                    labels.add(this.decodeInternationalizedString(value));
                }
            } else {
                throw new UnsupportedOperationException("prov:label is not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        if (!(values = this.popMultiValAttribute("prov:location", attributeMap)).isEmpty()) {
            if (statement instanceof HasLocation) {
                List locations = ((HasLocation)statement).getLocation();
                for (JsonElement value : values) {
                    locations.add((Location)this.decodeAttributeValue(value, this.name.PROV_LOCATION));
                }
            } else {
                throw new UnsupportedOperationException("prov:location is not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        if (!(values = this.popMultiValAttribute("prov:role", attributeMap)).isEmpty()) {
            if (statement instanceof HasRole) {
                List roles = ((HasRole)statement).getRole();
                for (JsonElement value : values) {
                    roles.add((Role)this.decodeAttributeValue(value, this.name.PROV_ROLE));
                }
            } else {
                throw new UnsupportedOperationException("prov:role is not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        if (!(values = this.popMultiValAttribute("prov:value", attributeMap)).isEmpty()) {
            if (values.size() > 1) {
                throw new UnsupportedOperationException("Only one instance of prov:value is allowed in a statement - id: " + idStr);
            }
            if (statement instanceof HasValue) {
                ((HasValue)statement).setValue((Value)this.decodeAttributeValue(values.get(0), this.name.PROV_VALUE));
            } else {
                throw new UnsupportedOperationException("prov:value is not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        if (provStatement != ProvJSONStatement.bundle && !attributeMap.entrySet().isEmpty()) {
            if (statement instanceof HasOther) {
                List ll;
                List attributes = ll = ((HasOther)statement).getOther();
                for (Map.Entry aPair : attributeMap.entrySet()) {
                    QualifiedName attributeName = this.stringToQualifiedName(this.currentNamespace, (String)aPair.getKey(), this.pf, false);
                    JsonElement element = (JsonElement)aPair.getValue();
                    values = this.pickMultiValues(element);
                    for (JsonElement value : values) {
                        Attribute attr = this.decodeAttributeValue(value, attributeName);
                        attributes.add(attr);
                    }
                }
            } else {
                throw new UnsupportedOperationException("Arbitrary attributes are not allowed in a " + statementType + "statement - id: " + idStr);
            }
        }
        return statement;
    }

    private LangString decodeInternationalizedString(JsonElement element) {
        LangString iString = this.pf.newInternationalizedString("s");
        if (element.isJsonPrimitive()) {
            iString.setValue(element.getAsString());
        } else {
            JsonObject struct = element.getAsJsonObject();
            String value = struct.get("$").getAsString();
            iString.setValue(value);
            if (struct.has("lang")) {
                String lang = struct.get("lang").getAsString();
                iString.setLang(lang);
            }
        }
        return iString;
    }

    private Attribute decodeAttributeValue(JsonElement element, QualifiedName elementName) {
        if (element.isJsonPrimitive()) {
            Object o = this.decodeJSONPrimitive(element.getAsString());
            QualifiedName type = this.vconv.getXsdType(o);
            return this.pf.newAttribute(elementName, o, type);
        }
        JsonObject struct = element.getAsJsonObject();
        String value = struct.get("$").getAsString();
        if (struct.has("lang")) {
            String lang = struct.get("lang").getAsString();
            LangString iString = this.pf.newInternationalizedString(value, lang);
            return this.pf.newAttribute(elementName, (Object)iString, this.name.PROV_LANG_STRING);
        }
        if (struct.has("type")) {
            String datatypeAsString = struct.get("type").getAsString();
            QualifiedName xsdType = this.stringToQualifiedName(this.currentNamespace, datatypeAsString, this.pf, false);
            if (xsdType.equals((Object)this.name.PROV_QUALIFIED_NAME)) {
                return this.pf.newAttribute(elementName, (Object)this.stringToQualifiedName(this.currentNamespace, value, this.pf, false), xsdType);
            }
            return this.pf.newAttribute(elementName, (Object)value, xsdType);
        }
        LangString iString = this.pf.getObjectFactory().createInternationalizedString();
        iString.setValue(value);
        return this.pf.newAttribute(elementName, (Object)iString, this.name.PROV_LANG_STRING);
    }

    private Object decodeJSONPrimitive(String value) {
        if (value == "true") {
            return true;
        }
        if (value == "false") {
            return false;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex1) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex2) {
                return value;
            }
        }
    }

    private List<JsonElement> popMultiValAttribute(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            JsonElement element = attributeMap.remove(attributeName);
            return this.pickMultiValues(element);
        }
        return Collections.emptyList();
    }

    private List<JsonElement> pickMultiValues(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<JsonElement> elements = new ArrayList<JsonElement>(array.size());
            Iterator iter = array.iterator();
            while (iter.hasNext()) {
                elements.add((JsonElement)iter.next());
            }
            return elements;
        }
        return Collections.singletonList(element);
    }

    private String popString(JsonObject jo, String memberName) {
        return jo.remove(memberName).getAsString();
    }

    private QualifiedName qualifiedName(String attributeName, JsonObject attributeMap) {
        return this.stringToQualifiedName(this.currentNamespace, this.popString(attributeMap, attributeName), this.pf, false);
    }

    private QualifiedName anyRef(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.stringToQualifiedName(this.currentNamespace, this.popString(attributeMap, attributeName), this.pf, false);
        }
        return null;
    }

    private QualifiedName optionalQualifiedName(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.qualifiedName(attributeName, attributeMap);
        }
        return null;
    }

    private XMLGregorianCalendar optionalTime(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.pf.newISOTime(this.popString(attributeMap, attributeName));
        }
        return null;
    }

    private Collection<QualifiedName> qualifiedNames(String attributeName, JsonObject attributeMap) {
        ArrayList<QualifiedName> results = new ArrayList<QualifiedName>();
        List<JsonElement> elements = this.popMultiValAttribute(attributeName, attributeMap);
        for (JsonElement element : elements) {
            results.add(this.stringToQualifiedName(this.currentNamespace, element.getAsString(), this.pf, false));
        }
        return results;
    }

    private Collection<QualifiedName> optionalQualifiedNames(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.qualifiedNames(attributeName, attributeMap);
        }
        return null;
    }

    private List<Entry> entrySet(String attributeName, JsonObject attributeMap) {
        ArrayList<Entry> results;
        block3: {
            JsonElement kESElement;
            block2: {
                results = new ArrayList<Entry>();
                kESElement = attributeMap.remove(attributeName);
                if (!kESElement.isJsonArray()) break block2;
                List<JsonElement> elements = this.pickMultiValues(kESElement);
                for (JsonElement element : elements) {
                    JsonObject item = element.getAsJsonObject();
                    Entry pair = this.pf.newEntry((Key)this.decodeAttributeValue(item.remove("key"), this.name.PROV_KEY), this.stringToQualifiedName(this.currentNamespace, this.popString(item, "$"), this.pf, false));
                    results.add(pair);
                }
                break block3;
            }
            if (!kESElement.isJsonObject()) break block3;
            JsonObject dictionary = kESElement.getAsJsonObject();
            String keyDatatype = dictionary.remove("$key-datatype").getAsString();
            QualifiedName datatype = this.stringToQualifiedName(this.currentNamespace, keyDatatype, this.pf, false);
            for (Map.Entry entry : dictionary.entrySet()) {
                String entryKey = (String)entry.getKey();
                JsonElement entryValue = (JsonElement)entry.getValue();
                Entry pair = this.decodeDictionaryEntry(datatype, entryKey, entryValue);
                results.add(pair);
            }
        }
        return results;
    }

    public Entry decodeDictionaryEntry(QualifiedName datatype, String entryKey, JsonElement entryValue) {
        Key kk = datatype.equals((Object)this.name.PROV_QUALIFIED_NAME) ? (Key)this.pf.newAttribute(this.name.PROV_KEY, (Object)this.stringToQualifiedName(this.currentNamespace, entryKey, this.pf, false), datatype) : (Key)this.pf.newAttribute(this.name.PROV_KEY, (Object)entryKey, datatype);
        Entry pair = this.pf.newEntry(kk, this.stringToQualifiedName(this.currentNamespace, entryValue.getAsString(), this.pf, false));
        return pair;
    }

    private List<Entry> optionalEntrySet(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.entrySet(attributeName, attributeMap);
        }
        return null;
    }

    private List<Key> keySet(String attributeName, JsonObject attributeMap) {
        ArrayList<Key> results = new ArrayList<Key>();
        List<JsonElement> elements = this.popMultiValAttribute(attributeName, attributeMap);
        for (JsonElement element : elements) {
            Key key = (Key)this.decodeAttributeValue(element, this.name.PROV_KEY);
            results.add(key);
        }
        return results;
    }

    private List<Key> optionalKeySet(String attributeName, JsonObject attributeMap) {
        if (attributeMap.has(attributeName)) {
            return this.keySet(attributeName, attributeMap);
        }
        return null;
    }

    private JsonObject getObjectAndRemove(JsonObject jsonObject, String memberName) {
        if (jsonObject.has(memberName)) {
            JsonObject result = jsonObject.getAsJsonObject(memberName);
            jsonObject.remove(memberName);
            return result;
        }
        return null;
    }
}

