/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.openprovenance.prov.core.json.serialization.ProvMixin;
import org.openprovenance.prov.core.json.serialization.SortedDocument;
import org.openprovenance.prov.core.json.serialization.deserial.CustomAttributeSetDeserializer;
import org.openprovenance.prov.core.json.serialization.deserial.CustomBundleDeserializer;
import org.openprovenance.prov.core.json.serialization.deserial.CustomKindDeserializer;
import org.openprovenance.prov.core.json.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.vanilla.Bundle;
import org.openprovenance.prov.vanilla.ProvFactory;

public class ProvDeserialiser
implements org.openprovenance.prov.model.ProvDeserialiser {
    ProvFactory pf = new ProvFactory();
    private final ProvMixin provMixin = new ProvMixin();

    public Document deserialiseDocument(File serialised) throws IOException {
        return this.deserialiseDocument(new FileInputStream(serialised));
    }

    public Document deserialiseDocument(InputStream in) {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("CustomKindSerializer", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(StatementOrBundle.Kind.class, (JsonDeserializer)new CustomKindDeserializer());
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType setType = typeFactory.constructCollectionType(Set.class, Attribute.class);
        JavaType qnType = mapper.getTypeFactory().constructType(QualifiedName.class);
        MapType mapType = typeFactory.constructMapType(HashMap.class, qnType, (JavaType)setType);
        MapType mapType2 = typeFactory.constructMapType(HashMap.class, String.class, String.class);
        module.addDeserializer(Namespace.class, (JsonDeserializer)new CustomNamespaceDeserializer((JavaType)mapType2));
        module.addDeserializer(Bundle.class, (JsonDeserializer)new CustomBundleDeserializer());
        module.addDeserializer(Set.class, (JsonDeserializer)new CustomAttributeSetDeserializer((JavaType)setType));
        this.provMixin.addProvMixin(mapper);
        mapper.registerModule((Module)module);
        SortedDocument doc = null;
        try {
            doc = (SortedDocument)mapper.readValue(in, SortedDocument.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException((Exception)e);
        }
        return doc.toDocument((org.openprovenance.prov.model.ProvFactory)this.pf);
    }
}

