/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.core.json.serialization.ProvMixin;
import org.openprovenance.prov.core.json.serialization.SortedDocument;
import org.openprovenance.prov.core.json.serialization.serial.CustomBundleSerializer;
import org.openprovenance.prov.core.json.serialization.serial.CustomDateSerializer;
import org.openprovenance.prov.core.json.serialization.serial.CustomKindSerializer;
import org.openprovenance.prov.core.json.serialization.serial.CustomQualifiedNameSerializer;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.vanilla.Bundle;
import org.openprovenance.prov.vanilla.QualifiedName;

public class ProvSerialiser
implements org.openprovenance.prov.model.ProvSerialiser {
    private static final Collection<String> myMedia = Set.of("application/json");
    private final ProvMixin provMixin = new ProvMixin();

    public Collection<String> mediaTypes() {
        return myMedia;
    }

    public void serialiseDocument(OutputStream out, Document document, boolean formatted) {
        ObjectMapper mapper = new ObjectMapper();
        if (formatted) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        SimpleModule module = new SimpleModule("CustomKindSerializer", new Version(1, 0, 0, null, null, null));
        module.addSerializer(StatementOrBundle.Kind.class, (JsonSerializer)new CustomKindSerializer());
        module.addSerializer(QualifiedName.class, (JsonSerializer)new CustomQualifiedNameSerializer());
        module.addSerializer(XMLGregorianCalendar.class, (JsonSerializer)new CustomDateSerializer());
        module.addSerializer(Bundle.class, (JsonSerializer)new CustomBundleSerializer());
        mapper.registerModule((Module)module);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("nsFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"prefixes", "defaultNamespace"}));
        mapper.setFilterProvider((FilterProvider)filterProvider);
        this.provMixin.addProvMixin(mapper);
        try {
            mapper.writeValue(out, (Object)new SortedDocument(document));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException((Exception)e);
        }
    }

    public void serialiseDocument(OutputStream out, Document document, String mediaType, boolean formatted) {
        this.serialiseDocument(out, document, formatted);
    }
}

