/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import org.openprovenance.prov.model.Namespace;

public class CustomNamespaceDeserializer
extends StdDeserializer<Namespace> {
    public static final Object CONTEXT_KEY_NAMESPACE = "CONTEXT_KEY_NAMESPACE";
    private final JavaType tr;

    public CustomNamespaceDeserializer(JavaType tr) {
        super(tr);
        this.tr = tr;
    }

    public Namespace deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = new Namespace();
        JsonNode x = (JsonNode)jp.getCodec().readTree(jp);
        if (x.isArray()) {
            for (int i = 0; i < x.size(); ++i) {
                JsonNode n = x.get(i);
                if (!n.isObject()) continue;
                Iterator it = n.fieldNames();
                while (it.hasNext()) {
                    String field = (String)it.next();
                    JsonNode value = n.get(field);
                    if (value.isObject()) continue;
                    String s = value.textValue();
                    if ("@namespace".equals(field)) {
                        ns.setDefaultNamespace(s);
                        continue;
                    }
                    if ("@version".equals(field)) continue;
                    ns.register(field, s);
                }
            }
        }
        deserializationContext.setAttribute(CONTEXT_KEY_NAMESPACE, (Object)ns);
        return ns;
    }
}

