/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.openprovenance.prov.core.xml.serialization.Constants;
import org.openprovenance.prov.core.xml.serialization.ProvSerialiser;
import org.openprovenance.prov.core.xml.serialization.stax.StaxStreamWriterUtil;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.TypedValue;

public class CustomTypedValueSerializer
extends StdSerializer<TypedValue>
implements Constants {
    static final QualifiedName QUALIFIED_NAME_XSD_STRING = ProvSerialiser.QUALIFIED_NAME_XSD_STRING;
    public static final String NAMESPACE_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String PREFIX_XSI = "xsi";
    public static final String PREFIX_XML = "xml";
    public static final String XSD_NS_NO_HASH = "http://www.w3.org/2001/XMLSchema";

    public CustomTypedValueSerializer() {
        super(TypedValue.class);
    }

    protected CustomTypedValueSerializer(Class<TypedValue> t) {
        super(t);
    }

    public void serialize(TypedValue attr, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
        xmlGenerator.setNextIsAttribute(true);
        jsonGenerator.writeStartObject();
        Object value = attr.getValue();
        QualifiedName type = attr.getType();
        if (value instanceof LangString) {
            LangString langString = (LangString)value;
            String lang = langString.getLang();
            if (lang != null) {
                StaxStreamWriterUtil.writeAttribute((JsonGenerator)xmlGenerator, PREFIX_XML, NAMESPACE_XML, "lang", lang);
            }
            value = langString.getValue();
        }
        if (type != null) {
            StaxStreamWriterUtil.writeAttribute((JsonGenerator)xmlGenerator, PREFIX_XSI, NAMESPACE_XSI, "type", type);
        }
        xmlGenerator.setNextIsAttribute(false);
        xmlGenerator.setNextIsUnwrapped(true);
        if (value instanceof String || !(value instanceof QualifiedName)) {
            // empty if block
        }
        jsonGenerator.writeObjectField("value", value);
        jsonGenerator.writeEndObject();
    }
}

