/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.openprovenance.prov.core.xml.serialization.ProvMixin;
import org.openprovenance.prov.core.xml.serialization.serial.CustomDateSerializer;
import org.openprovenance.prov.core.xml.serialization.serial.CustomQualifiedNameSerializer;
import org.openprovenance.prov.core.xml.serialization.serial.CustomTypedValueSerializer;
import org.openprovenance.prov.core.xml.serialization.stax.ElementEraserXMLStreamWriter2;
import org.openprovenance.prov.core.xml.serialization.stax.NamespaceXMLStreamWriter2;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.TypedValue;

public class ProvSerialiser
implements org.openprovenance.prov.model.ProvSerialiser {
    private static final Collection<String> myMedia = Set.of("application/provenance+xml", "application/xml");
    public static final ProvFactory pf = ProvFactory.getFactory();
    public static final QualifiedName QUALIFIED_NAME_XSD_STRING = ProvSerialiser.pf.getName().XSD_STRING;
    private final ProvMixin provMixin = new ProvMixin();
    public final boolean WRAP_ERASE;

    public Collection<String> mediaTypes() {
        return myMedia;
    }

    public ProvSerialiser() {
        this.WRAP_ERASE = false;
    }

    public ProvSerialiser(boolean WRAP_ERASE) {
        this.WRAP_ERASE = WRAP_ERASE;
    }

    public void serialiseDocument(OutputStream out, Document document, String mediaType, boolean formatted) {
        this.serialiseDocument(out, document, formatted);
    }

    public void serialiseDocument(OutputStream out, Document document, boolean formatted) {
        this.serialiseDocument(out, (Object)document, formatted, false);
    }

    public void serialiseDocument(OutputStream out, Object document, boolean formatted, boolean ignore) {
        XmlMapper mapper = this.getMapper(formatted);
        try {
            mapper.writeValue(out, document);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException((Exception)e);
        }
    }

    public XmlMapper getMapper(boolean formatted) {
        XmlMapper mapper = this.getXmlMapper();
        if (formatted) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        SimpleModule module = this.makeModule();
        mapper.registerModule((Module)module);
        SimpleFilterProvider filterProvider = this.makeFilter();
        mapper.setFilterProvider((FilterProvider)filterProvider);
        this.provMixin.addProvMixin((ObjectMapper)mapper);
        return mapper;
    }

    public SimpleFilterProvider makeFilter() {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("nsFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"prefixes", "defaultNamespace"}));
        return filterProvider;
    }

    public SimpleModule makeModule() {
        SimpleModule module = new SimpleModule("CustomKindSerializer", new Version(1, 0, 0, null, null, null));
        module.addSerializer(org.openprovenance.prov.vanilla.QualifiedName.class, (JsonSerializer)new CustomQualifiedNameSerializer());
        module.addSerializer(XMLGregorianCalendar.class, (JsonSerializer)new CustomDateSerializer());
        module.addSerializer(TypedValue.class, (JsonSerializer)new CustomTypedValueSerializer());
        return module;
    }

    public XmlMapper getXmlMapper() {
        WstxInputFactory inputFactory2 = new WstxInputFactory();
        WstxOutputFactory outputFactory2 = new WstxOutputFactory(){

            public XMLStreamWriter createXMLStreamWriter(OutputStream w, String enco) throws XMLStreamException {
                XMLStreamWriter2 result = (XMLStreamWriter2)super.createXMLStreamWriter(w, enco);
                result.setPrefix("prov", "http://www.w3.org/ns/prov#");
                result.setPrefix("ex", "http://example.org/");
                result.setDefaultNamespace("http://www.w3.org/ns/prov#");
                if (ProvSerialiser.this.WRAP_ERASE) {
                    return new ElementEraserXMLStreamWriter2(result);
                }
                return new NamespaceXMLStreamWriter2(result);
            }
        };
        outputFactory2.setProperty("org.codehaus.stax2.automaticNsPrefix", (Object)Boolean.TRUE);
        outputFactory2.configureForRobustness();
        XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)inputFactory2, (XMLOutputFactory)outputFactory2);
        return new XmlMapper(xmlFactory);
    }
}

