/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.attic;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.core.xml.serialization.ProvDeserialiser;
import org.openprovenance.prov.core.xml.serialization.deserial.CustomAttributeDeserializerWithRootName;
import org.openprovenance.prov.core.xml.serialization.deserial.DeserializerUtil;
import org.openprovenance.prov.core.xml.serialization.deserial.attic.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.ProvFactory;

public abstract class CustomAttributeMapDeserializer
extends StdDeserializer<Map> {
    private static final ProvFactory pf = ProvDeserialiser.pf;
    private final TypeReference tr = new TypeReference<Map<QualifiedName, Set<Attribute>>>(){};

    public CustomAttributeMapDeserializer(JavaType vc) {
        super(vc);
    }

    public Map deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        HashMap result = new HashMap();
        System.out.println("#######  found " + jp.readValueAs(this.tr));
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            QualifiedName elementName = DeserializerUtil.unescapeQualifiedName(ns.stringToQualifiedName((String)pair.getKey(), (org.openprovenance.prov.model.ProvFactory)pf));
            JsonNode vObj = (JsonNode)pair.getValue();
            Iterator elements = vObj.elements();
            HashSet<Attribute> set = new HashSet<Attribute>();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                Attribute attr = new CustomAttributeDeserializerWithRootName().deserialize(elementName, next, deserializationContext);
                set.add(attr);
            }
            result.put(elementName, set);
        }
        return result;
    }
}

