/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.vanilla.ActedOnBehalfOf;
import org.openprovenance.prov.vanilla.Activity;
import org.openprovenance.prov.vanilla.Agent;
import org.openprovenance.prov.vanilla.AlternateOf;
import org.openprovenance.prov.vanilla.Bundle;
import org.openprovenance.prov.vanilla.Document;
import org.openprovenance.prov.vanilla.Entity;
import org.openprovenance.prov.vanilla.HadMember;
import org.openprovenance.prov.vanilla.QualifiedAlternateOf;
import org.openprovenance.prov.vanilla.QualifiedHadMember;
import org.openprovenance.prov.vanilla.QualifiedSpecializationOf;
import org.openprovenance.prov.vanilla.SpecializationOf;
import org.openprovenance.prov.vanilla.Used;
import org.openprovenance.prov.vanilla.WasAssociatedWith;
import org.openprovenance.prov.vanilla.WasAttributedTo;
import org.openprovenance.prov.vanilla.WasDerivedFrom;
import org.openprovenance.prov.vanilla.WasEndedBy;
import org.openprovenance.prov.vanilla.WasGeneratedBy;
import org.openprovenance.prov.vanilla.WasInfluencedBy;
import org.openprovenance.prov.vanilla.WasInformedBy;
import org.openprovenance.prov.vanilla.WasInvalidatedBy;
import org.openprovenance.prov.vanilla.WasStartedBy;

public class StatementsHandler
extends SimpleModule {
    static final Map<String, Class<? extends StatementOrBundle>> statementOrBundleMap = StatementsHandler.setupStatementOrBundleTable();
    static final Map<String, Class<? extends Statement>> statementMap = StatementsHandler.setupStatementTable();

    public StatementsHandler(String customKindSerializer, Version version) {
        super(customKindSerializer, version);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addDeserializationProblemHandler((DeserializationProblemHandler)new MyDeserializationProblemHandler());
    }

    static Map<String, Class<? extends StatementOrBundle>> setupStatementOrBundleTable() {
        HashMap<String, Class<? extends StatementOrBundle>> result = new HashMap<String, Class<? extends StatementOrBundle>>();
        result.put("wasEndedBy", WasEndedBy.class);
        result.put("wasStartedBy", WasStartedBy.class);
        result.put("wasInvalidatedBy", WasInvalidatedBy.class);
        result.put("hadMember", HadMember.class);
        result.put("wasInfluencedBy", WasInfluencedBy.class);
        result.put("wasInformedBy", WasInformedBy.class);
        result.put("wasDerivedFrom", WasDerivedFrom.class);
        result.put("alternateOf", AlternateOf.class);
        result.put("specializationOf", SpecializationOf.class);
        result.put("wasAttributedTo", WasAttributedTo.class);
        result.put("wasAssociatedWith", WasAssociatedWith.class);
        result.put("wasGeneratedBy", WasGeneratedBy.class);
        result.put("used", Used.class);
        result.put("activity", Activity.class);
        result.put("agent", Agent.class);
        result.put("entity", Entity.class);
        result.put("actedOnBehalfOf", ActedOnBehalfOf.class);
        result.put("bundleContent", Bundle.class);
        result.put("QualifiedAlternate", QualifiedAlternateOf.class);
        result.put("QualifiedSpecialization", QualifiedSpecializationOf.class);
        result.put("QualifiedMembership", QualifiedHadMember.class);
        return result;
    }

    static Map<String, Class<? extends Statement>> setupStatementTable() {
        HashMap<String, Class<? extends Statement>> result = new HashMap<String, Class<? extends Statement>>();
        result.put("wasEndedBy", WasEndedBy.class);
        result.put("wasStartedBy", WasStartedBy.class);
        result.put("wasInvalidatedBy", WasInvalidatedBy.class);
        result.put("hadMember", HadMember.class);
        result.put("wasInfluencedBy", WasInfluencedBy.class);
        result.put("wasInformedBy", WasInformedBy.class);
        result.put("wasDerivedFrom", WasDerivedFrom.class);
        result.put("alternateOf", AlternateOf.class);
        result.put("specializationOf", SpecializationOf.class);
        result.put("wasAttributedTo", WasAttributedTo.class);
        result.put("wasAssociatedWith", WasAssociatedWith.class);
        result.put("wasGeneratedBy", WasGeneratedBy.class);
        result.put("used", Used.class);
        result.put("activity", Activity.class);
        result.put("agent", Agent.class);
        result.put("entity", Entity.class);
        result.put("actedOnBehalfOf", ActedOnBehalfOf.class);
        result.put("QualifiedAlternate", QualifiedAlternateOf.class);
        result.put("QualifiedSpecialization", QualifiedSpecializationOf.class);
        result.put("QualifiedMembership", QualifiedHadMember.class);
        return result;
    }

    private static class MyDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private MyDeserializationProblemHandler() {
        }

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            Class<? extends Statement> cl2;
            Class<? extends StatementOrBundle> cl;
            if (beanOrClass instanceof Document && (cl = statementOrBundleMap.get(propertyName)) != null) {
                StatementOrBundle s = (StatementOrBundle)jp.readValueAs(cl);
                Document doc = (Document)beanOrClass;
                doc.getStatementOrBundle().add(s);
                return true;
            }
            if (beanOrClass instanceof Bundle && (cl2 = statementMap.get(propertyName)) != null) {
                System.out.println("########################" + propertyName);
                Statement s = (Statement)jp.readValueAs(cl2);
                Bundle bun = (Bundle)beanOrClass;
                bun.getStatement().add(s);
                return true;
            }
            return super.handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName);
        }
    }
}

