/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.deserial;

import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import org.openprovenance.prov.core.xml.serialization.ProvDeserialiser;
import org.openprovenance.prov.core.xml.serialization.deserial.CustomThreadConfig;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.vanilla.ProvFactory;

public class DeserializerUtil {
    private static final String PROVX_CONTEXT_KEY_NAMESPACE = "PROVX_CONTEXT_KEY_NAMESPACE";
    private static final ProvFactory pf = ProvDeserialiser.pf;
    private static final QualifiedNameUtils qnU = new QualifiedNameUtils();

    public static Namespace getNamespace() {
        Namespace ns = CustomThreadConfig.getAttributes().get().get(PROVX_CONTEXT_KEY_NAMESPACE);
        if (ns == null) {
            System.out.println("=============> ns is null");
        }
        return ns;
    }

    public static Namespace newNamespace() {
        Namespace ns = new Namespace();
        CustomThreadConfig.getAttributes().get().put(PROVX_CONTEXT_KEY_NAMESPACE, ns);
        return ns;
    }

    public static Namespace removeNamespace() {
        return CustomThreadConfig.getAttributes().get().remove(PROVX_CONTEXT_KEY_NAMESPACE);
    }

    public static void setNamespace(Namespace namespace) {
        CustomThreadConfig.getAttributes().get().put(PROVX_CONTEXT_KEY_NAMESPACE, namespace);
    }

    public static String getAttributeValue(Namespace ns, FromXmlParser xmlParser, String name) {
        String attributeValue = xmlParser.getStaxReader().getAttributeValue("http://www.w3.org/ns/prov#", name);
        if (attributeValue.contains(":")) {
            String prefix = attributeValue.substring(0, attributeValue.indexOf(":"));
            String ans = xmlParser.getStaxReader().getNamespaceURI(prefix);
            ns.register(prefix, ans);
        } else {
            String ans = xmlParser.getStaxReader().getNamespaceURI();
            ns.registerDefault(ans);
        }
        return attributeValue;
    }

    public static QualifiedName unescapeQualifiedName(QualifiedName id) {
        String namespace = id.getNamespaceURI();
        String local = qnU.escapeProvLocalName(qnU.unescapeFromXsdLocalName(id.getLocalPart()));
        String prefix = id.getPrefix();
        return pf.newQualifiedName(namespace, local, prefix);
    }
}

