/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.core.xml.serialization.ProvMixin;
import org.openprovenance.prov.core.xml.serialization.deserial.CustomAttributeSetDeserializer;
import org.openprovenance.prov.core.xml.serialization.deserial.CustomBundleDeserializer;
import org.openprovenance.prov.core.xml.serialization.deserial.CustomXMLGregorianCalendarDeserializer;
import org.openprovenance.prov.core.xml.serialization.deserial.DeserializerUtil;
import org.openprovenance.prov.core.xml.serialization.deserial.StatementsHandler;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.vanilla.Bundle;
import org.openprovenance.prov.vanilla.ProvFactory;

public class ProvDeserialiser
implements org.openprovenance.prov.model.ProvDeserialiser {
    public static final ProvFactory pf = new ProvFactory();
    private final ProvMixin provMixin = new ProvMixin();
    private final DateTimeOption dateTimeOption;
    private final TimeZone optionalTimeZone;

    public ProvDeserialiser() {
        this.dateTimeOption = DateTimeOption.PRESERVE;
        this.optionalTimeZone = null;
    }

    public ProvDeserialiser(DateTimeOption dateTimeOption) {
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = null;
    }

    public ProvDeserialiser(DateTimeOption dateTimeOption, TimeZone optionalTimeZone) {
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = optionalTimeZone;
    }

    public Document deserialiseDocument(InputStream in) throws IOException {
        DeserializerUtil.removeNamespace();
        Namespace docNs = DeserializerUtil.newNamespace();
        docNs.addKnownNamespaces();
        XmlMapper mapper = this.getMapper();
        org.openprovenance.prov.vanilla.Document document = (org.openprovenance.prov.vanilla.Document)mapper.readValue(in, org.openprovenance.prov.vanilla.Document.class);
        document.setNamespace(docNs);
        return document;
    }

    public XmlMapper getMapper() {
        XmlMapper mapper = new XmlMapper();
        StatementsHandler module = new StatementsHandler("CustomKindDeserializer", new Version(1, 0, 0, null, null, null));
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType setType = typeFactory.constructCollectionType(Set.class, Attribute.class);
        module.addDeserializer(Set.class, (JsonDeserializer)new CustomAttributeSetDeserializer((JavaType)setType));
        module.addDeserializer(XMLGregorianCalendar.class, new CustomXMLGregorianCalendarDeserializer(this.dateTimeOption, this.optionalTimeZone));
        module.addDeserializer(Bundle.class, new CustomBundleDeserializer());
        mapper.registerModule((Module)module);
        this.provMixin.addProvMixin((ObjectMapper)mapper);
        return mapper;
    }
}

