/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.openprovenance.prov.core.xml.serialization.deserial.DeserializerUtil;
import org.openprovenance.prov.core.xml.serialization.serial.ProvxSerializationException;
import org.openprovenance.prov.core.xml.serialization.stax.StaxStreamWriterUtil;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.vanilla.QualifiedName;

public class CustomQualifiedNameSerializer
extends StdSerializer<QualifiedName> {
    public CustomQualifiedNameSerializer() {
        super(QualifiedName.class);
    }

    protected CustomQualifiedNameSerializer(Class<QualifiedName> t) {
        super(t);
    }

    public void serialize(QualifiedName q, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String prefix = q.getPrefix();
        Object str = q.getLocalPart();
        if (prefix == null) {
            String actualDefault = StaxStreamWriterUtil.getDefaultNamespace(jsonGenerator);
            Namespace namespace = DeserializerUtil.getNamespace();
            StaxStreamWriterUtil.writeDefaultNamespace(jsonGenerator, q.getNamespaceURI());
            if (!Objects.equals(actualDefault, namespace.getDefaultNamespace())) {
                String altPrefixForDefault = (String)namespace.getNamespaces().get(q.getNamespaceURI());
                if (altPrefixForDefault == null) {
                    throw new ProvxSerializationException("Default namespace uri lacks a prefix declaration " + q.getNamespaceURI());
                }
                str = altPrefixForDefault + ":" + (String)str;
            }
        } else {
            str = prefix + ":" + (String)str;
            StaxStreamWriterUtil.writeNamespace(jsonGenerator, prefix, q.getNamespaceURI());
        }
        jsonGenerator.writeString((String)str);
    }
}

