/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.exception.TimeZoneException;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomXMLGregorianCalendarDeserializer
extends JsonDeserializer<XMLGregorianCalendar> {
    private static final Logger logger = LogManager.getLogger(CustomXMLGregorianCalendarDeserializer.class);
    static final ProvFactory pf = ProvFactory.getFactory();
    private final DateTimeOption dateTimeOption;
    private final TimeZone optionalTimeZone;

    public CustomXMLGregorianCalendarDeserializer(DateTimeOption dateTimeOption) {
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = null;
        if (dateTimeOption == null) {
            throw new TimeZoneException("Null dateTimeOption");
        }
        if (dateTimeOption == DateTimeOption.TIMEZONE) {
            throw new TimeZoneException("no TimeZone provided");
        }
    }

    public CustomXMLGregorianCalendarDeserializer(DateTimeOption dateTimeOption, TimeZone optionalTimeZone) {
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = optionalTimeZone;
        if (dateTimeOption == null) {
            throw new TimeZoneException("Null dateTimeOption");
        }
    }

    public XMLGregorianCalendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String text = jsonParser.getText();
        XMLGregorianCalendar xmlGregorianCalendar = pf.newISOTime(text, this.dateTimeOption, this.optionalTimeZone);
        logger.debug("Deserialized XMLGregorianCalendar: {} {}", (Object)text, (Object)xmlGregorianCalendar);
        return xmlGregorianCalendar;
    }
}

