/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.xml.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.openprovenance.prov.core.xml.serialization.Constants;
import org.openprovenance.prov.core.xml.serialization.ProvDeserialiser;
import org.openprovenance.prov.core.xml.serialization.deserial.DeserializerUtil;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.LangString;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomAttributeDeserializerWithRootName
extends StdDeserializer<Attribute>
implements Constants {
    private static final ProvFactory pf = ProvDeserialiser.pf;

    public CustomAttributeDeserializerWithRootName() {
        this(Attribute.class);
    }

    public CustomAttributeDeserializerWithRootName(Class<?> vc) {
        super(vc);
    }

    public Attribute deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.deserialize(node, deserializationContext);
    }

    public Attribute deserialize(JsonNode node, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = DeserializerUtil.getNamespace();
        Map.Entry pair = (Map.Entry)node.fields().next();
        QualifiedName elementName = ns.stringToQualifiedName((String)pair.getKey(), (org.openprovenance.prov.model.ProvFactory)pf);
        elementName = DeserializerUtil.unescapeQualifiedName(elementName);
        JsonNode vObj = (JsonNode)pair.getValue();
        return this.deserialize(elementName, vObj, deserializationContext);
    }

    public Attribute deserialize(QualifiedName elementName, JsonNode vObj, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = DeserializerUtil.getNamespace();
        JsonNode typeRaw = vObj.get("type");
        String type = typeRaw == null ? null : typeRaw.textValue();
        JsonNode value = vObj.get("value");
        String valueObject = value.textValue();
        if ((type.equals("xsd:string") || type.equals("prov:InternationalizedString")) && value.isObject()) {
            JsonNode theValue = value.get("$");
            JsonNode theLang = value.get("lang");
            valueObject = new LangString(theValue.textValue(), theLang == null ? null : theLang.textValue());
        } else if (type.equals("xsd:QName")) {
            valueObject = ns.stringToQualifiedName(value.textValue(), (org.openprovenance.prov.model.ProvFactory)pf);
        }
        QualifiedName typeQN = ns.stringToQualifiedName(type, (org.openprovenance.prov.model.ProvFactory)pf);
        return pf.newAttribute(elementName, (Object)valueObject, typeQN);
    }

    public Attribute deserialize(QualifiedName elementName, String type, String lang, String body, DeserializationContext deserializationContext) {
        Namespace ns = DeserializerUtil.getNamespace();
        QualifiedName unescaped = DeserializerUtil.unescapeQualifiedName(elementName);
        String valueObject = body;
        if (type == null || type.equals("xsd:string") || type.equals("prov:InternationalizedString")) {
            valueObject = new LangString(body, lang);
            if (type == null) {
                type = "xsd:string";
            }
        } else if (type.equals("xsd:QName")) {
            valueObject = ns.stringToQualifiedName(body, (org.openprovenance.prov.model.ProvFactory)pf);
            type = "prov:QUALIFIED_NAME";
        }
        return pf.newAttribute(unescaped, (Object)valueObject, ns.stringToQualifiedName(type, (org.openprovenance.prov.model.ProvFactory)pf));
    }
}

