/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomQualifiedNameDeserializer
extends StdDeserializer<QualifiedName> {
    static final ProvFactory pf = new ProvFactory();
    static final QualifiedName PROV_TYPE = CustomQualifiedNameDeserializer.pf.getName().PROV_TYPE;

    public CustomQualifiedNameDeserializer() {
        this(QualifiedName.class);
    }

    public CustomQualifiedNameDeserializer(Class<?> vc) {
        super(vc);
    }

    public QualifiedName deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        String text = jsonParser.getText();
        if ("@type".equals(text)) {
            return PROV_TYPE;
        }
        return ns.stringToQualifiedName(text, (org.openprovenance.prov.model.ProvFactory)pf, false);
    }

    public QualifiedName deserialize(String s, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        if ("@type".equals(s)) {
            return PROV_TYPE;
        }
        return ns.stringToQualifiedName(s, (org.openprovenance.prov.model.ProvFactory)pf, false);
    }
}

