/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openprovenance.prov.core.json.serialization.SortedBundle;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedRelation;
import org.openprovenance.prov.model.StatementOrBundle;

public class SortedDocument
extends SortedBundle {
    Map<QualifiedName, Bundle> theBundles = new HashMap<QualifiedName, Bundle>();

    private SortedDocument() {
    }

    public SortedDocument(Document doc) {
        this.namespace = doc.getNamespace();
        for (StatementOrBundle s : doc.getStatementOrBundle()) {
            switch (s.getKind()) {
                case PROV_ENTITY: {
                    this.entity.put(((Entity)s).getId(), (Entity)s);
                    break;
                }
                case PROV_ACTIVITY: {
                    this.put(this.activity, s);
                    break;
                }
                case PROV_AGENT: {
                    this.put(this.agent, s);
                    break;
                }
                case PROV_USAGE: {
                    this.put(this.used, s);
                    break;
                }
                case PROV_GENERATION: {
                    this.put(this.wgb, s);
                    break;
                }
                case PROV_INVALIDATION: {
                    this.put(this.wib, s);
                    break;
                }
                case PROV_START: {
                    this.put(this.wasStartedBy, s);
                    break;
                }
                case PROV_END: {
                    this.put(this.wasEndedBy, s);
                    break;
                }
                case PROV_COMMUNICATION: {
                    this.put(this.wasInformedBy, s);
                    break;
                }
                case PROV_DERIVATION: {
                    this.put(this.wasDerivedFrom, s);
                    break;
                }
                case PROV_ASSOCIATION: {
                    this.put(this.wasAssociatedWith, s);
                    break;
                }
                case PROV_ATTRIBUTION: {
                    this.put(this.wasAttributedTo, s);
                    break;
                }
                case PROV_DELEGATION: {
                    this.put(this.actedOnBehalfOf, s);
                    break;
                }
                case PROV_INFLUENCE: {
                    this.put(this.wasInfluencedBy, s);
                    break;
                }
                case PROV_ALTERNATE: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedAlternateOf, s);
                        break;
                    }
                    this.put(this.alternateOf, s);
                    break;
                }
                case PROV_SPECIALIZATION: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedSpecializationOf, s);
                        break;
                    }
                    this.put(this.specializationOf, s);
                }
                case PROV_MENTION: {
                    break;
                }
                case PROV_MEMBERSHIP: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedHadMember, s);
                        break;
                    }
                    this.put(this.hadMember, s);
                    break;
                }
                case PROV_BUNDLE: {
                    this.put(this.theBundles, (Bundle)s);
                    break;
                }
                case PROV_DICTIONARY_INSERTION: {
                    break;
                }
                case PROV_DICTIONARY_REMOVAL: {
                    break;
                }
            }
        }
        if (count > 0) {
            this.namespace.register("_", bnNS);
        }
    }

    public Map<QualifiedName, Bundle> getBundle() {
        return this.theBundles;
    }

    public Document toDocument(ProvFactory provFactory) {
        LinkedList<Object> ss = new LinkedList<Object>();
        ss.addAll(this.reassignId(this.getEntity()).values());
        ss.addAll(this.reassignId(this.getActivity()).values());
        ss.addAll(this.reassignId(this.getAgent()).values());
        ss.addAll(this.reassignId(this.getUsed()).values());
        ss.addAll(this.reassignId(this.getWasGeneratedBy()).values());
        ss.addAll(this.reassignId(this.getWasInvalidatedBy()).values());
        ss.addAll(this.reassignId(this.getWasAssociatedWith()).values());
        ss.addAll(this.reassignId(this.getWasAttributedTo()).values());
        ss.addAll(this.reassignId(this.getActedOnBehalfOf()).values());
        ss.addAll(this.reassignId(this.getWasStartedBy()).values());
        ss.addAll(this.reassignId(this.getWasEndedBy()).values());
        ss.addAll(this.reassignId(this.getWasInformedBy()).values());
        ss.addAll(this.reassignId(this.getWasInfluencedBy()).values());
        ss.addAll(this.getAlternateOf().values());
        ss.addAll(this.getSpecializationOf().values());
        ss.addAll(this.getHadMember().values());
        ss.addAll(this.reassignId(this.getWasDerivedFrom()).values());
        ss.addAll(this.reassignId(this.getQualifiedSpecializationOf()).values());
        ss.addAll(this.reassignId(this.getQualifiedAlternateOf()).values());
        ss.addAll(this.reassignId(this.getQualifiedHadMember()).values());
        return provFactory.newDocument(this.namespace, ss, this.reassignId(this.theBundles).values());
    }
}

