/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.openprovenance.prov.core.json.serialization.Constants;
import org.openprovenance.prov.core.json.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.core.json.serialization.serial.CustomTypedValueSerializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.LangString;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomAttributeDeserializerWithRootName
extends StdDeserializer<Attribute>
implements Constants {
    static final ProvFactory pf = new ProvFactory();

    public CustomAttributeDeserializerWithRootName() {
        this(Attribute.class);
    }

    public CustomAttributeDeserializerWithRootName(Class<?> vc) {
        super(vc);
    }

    public Attribute deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.deserialize(node, deserializationContext);
    }

    public Attribute deserialize(JsonNode node, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        Map.Entry pair = (Map.Entry)node.fields().next();
        QualifiedName elementName = ns.stringToQualifiedName((String)pair.getKey(), (org.openprovenance.prov.model.ProvFactory)pf);
        JsonNode vObj = (JsonNode)pair.getValue();
        return this.deserialize(elementName, vObj, deserializationContext);
    }

    public Attribute deserialize(QualifiedName elementName, String astring, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        return pf.newAttribute(elementName, (Object)astring, CustomTypedValueSerializer.QUALIFIED_NAME_XSD_STRING);
    }

    public Attribute deserialize(QualifiedName elementName, JsonNode vObj, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        JsonNode typeRaw = vObj.get("type");
        String type = typeRaw == null ? null : typeRaw.textValue();
        JsonNode value = vObj.get("$");
        String valueObject = value.textValue();
        if (type == null) {
            JsonNode theLang = vObj.get("lang");
            valueObject = new LangString(value.textValue(), theLang == null ? null : theLang.textValue());
            type = theLang != null ? "prov:InternationalizedString" : "xsd:string";
        } else if ((type.equals("xsd:string") || type.equals("prov:InternationalizedString")) && value.isObject()) {
            JsonNode theValue = value.get("$");
            JsonNode theLang = value.get("lang");
            valueObject = new LangString(theValue.textValue(), theLang == null ? null : theLang.textValue());
        } else if (type.equals("prov:QUALIFIED_NAME")) {
            valueObject = ns.stringToQualifiedName(value.textValue(), (org.openprovenance.prov.model.ProvFactory)pf);
        }
        QualifiedName typeQN = ns.stringToQualifiedName(type, (org.openprovenance.prov.model.ProvFactory)pf);
        return pf.newAttribute(elementName, (Object)valueObject, typeQN);
    }
}

