/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.openprovenance.prov.core.jsonld11.AttributeTypedValue;
import org.openprovenance.prov.core.jsonld11.serialization.Constants;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.LangString;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomAttributeDeserializer
extends StdDeserializer<Attribute>
implements Constants {
    static final ProvFactory pf = new ProvFactory();
    static final QualifiedName XSD_STRING = CustomAttributeDeserializer.pf.getName().XSD_STRING;
    static final QualifiedName PROV_INTERNATIONALIZED_STRING = CustomAttributeDeserializer.pf.getName().PROV_LANG_STRING;
    static final QualifiedName PROV_QUALIFIED_NAME = CustomAttributeDeserializer.pf.getName().PROV_QUALIFIED_NAME;

    public CustomAttributeDeserializer() {
        this(Attribute.class);
    }

    public CustomAttributeDeserializer(Class<?> vc) {
        super(vc);
    }

    public Attribute deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        if (jp.isExpectedStartObjectToken()) {
            AttributeTypedValue valueAndType = (AttributeTypedValue)jp.readValueAs(AttributeTypedValue.class);
            QualifiedName elementName = (QualifiedName)deserializationContext.getAttribute((Object)"prov:Attribute");
            return this.deserialize_TypedValue(elementName, valueAndType, deserializationContext);
        }
        return this.deserialize(jp.getText(), deserializationContext);
    }

    private final Attribute deserialize(String astring, DeserializationContext deserializationContext) {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        QualifiedName elementName = (QualifiedName)deserializationContext.getAttribute((Object)"prov:Attribute");
        return pf.newAttribute(elementName, (Object)ns.stringToQualifiedName(astring, (org.openprovenance.prov.model.ProvFactory)pf), PROV_QUALIFIED_NAME);
    }

    private final Attribute deserialize_TypedValue(QualifiedName elementName, AttributeTypedValue valueAndType, DeserializationContext deserializationContext) {
        QualifiedName typeQN;
        Object valueObject;
        String type = valueAndType.typex;
        String textValue = valueAndType.value;
        if (type == null || type.equals("xsd:string") || type.equals("prov:InternationalizedString")) {
            String theLang = valueAndType.language;
            if (theLang == null) {
                valueObject = new LangString(textValue);
                typeQN = XSD_STRING;
            } else {
                valueObject = new LangString(textValue, theLang);
                typeQN = PROV_INTERNATIONALIZED_STRING;
            }
        } else {
            Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
            typeQN = ns.stringToQualifiedName(type, (org.openprovenance.prov.model.ProvFactory)pf);
            valueObject = type.equals("prov:QUALIFIED_NAME") ? ns.stringToQualifiedName(textValue, (org.openprovenance.prov.model.ProvFactory)pf) : textValue;
        }
        return pf.newAttribute(elementName, valueObject, typeQN);
    }
}

