/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.core.jsonld11.serialization.ProvMixin;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomAttributeMapDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomAttributeSetDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomKindDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.exception.UncheckedException;

public class ProvDeserialiser
extends org.openprovenance.prov.core.json.serialization.ProvDeserialiser {
    public ProvMixin provMixin() {
        return new ProvMixin();
    }

    @Override
    public Document deserialiseDocument(InputStream in) {
        ObjectMapper mapper = new ObjectMapper();
        this.customize(mapper);
        try {
            return (Document)mapper.readValue(in, org.openprovenance.prov.vanilla.Document.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException((Exception)e);
        }
    }

    public void customize(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("CustomKindDeserializer", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(StatementOrBundle.Kind.class, (JsonDeserializer)new CustomKindDeserializer());
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType setType = typeFactory.constructCollectionType(Set.class, Attribute.class);
        JavaType qnType = mapper.getTypeFactory().constructType(QualifiedName.class);
        MapType mapType = typeFactory.constructMapType(HashMap.class, qnType, (JavaType)setType);
        module.addDeserializer(Map.class, (JsonDeserializer)new CustomAttributeMapDeserializer((JavaType)mapType));
        MapType mapType2 = typeFactory.constructMapType(HashMap.class, String.class, Object.class);
        ArrayType arrayType = typeFactory.constructArrayType((JavaType)mapType2);
        module.addDeserializer(Namespace.class, (JsonDeserializer)new CustomNamespaceDeserializer((JavaType)arrayType));
        module.addDeserializer(Set.class, (JsonDeserializer)new CustomAttributeSetDeserializer((JavaType)setType));
        this.provMixin().addProvMixin(mapper);
        mapper.registerModule((Module)module);
    }
}

