/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openprovenance.prov.model.Namespace;

public class CustomNamespacePrefixDeserializer
extends StdDeserializer<Map<String, String>> {
    public static final Object CONTEXT_KEY_NAMESPACE = "CONTEXT_KEY_NAMESPACE";

    public CustomNamespacePrefixDeserializer(JavaType tr) {
        super(tr);
    }

    public CustomNamespacePrefixDeserializer() {
        super(Map.class);
    }

    public Map<String, String> deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode prefixes = (JsonNode)jp.readValueAsTree();
        Namespace ns = (Namespace)deserializationContext.getAttribute(CONTEXT_KEY_NAMESPACE);
        if (ns == null) {
            ns = new Namespace();
            deserializationContext.setAttribute(CONTEXT_KEY_NAMESPACE, (Object)ns);
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        Iterator it = prefixes.fieldNames();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String namespace = prefixes.get(prefix).textValue();
            map.put(prefix, namespace);
            ns.register(prefix, namespace);
        }
        return map;
    }
}

