/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.openprovenance.prov.core.json.serialization.deserial.CustomAttributeDeserializerWithRootName;
import org.openprovenance.prov.core.json.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomAttributeMapDeserializer
extends StdDeserializer<Map> {
    static final ProvFactory pf = new ProvFactory();

    public CustomAttributeMapDeserializer(JavaType vc) {
        super(vc);
    }

    public Map deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Namespace ns = (Namespace)deserializationContext.getAttribute(CustomNamespaceDeserializer.CONTEXT_KEY_NAMESPACE);
        HashMap result = new HashMap();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            QualifiedName elementName = ns.stringToQualifiedName((String)pair.getKey(), (org.openprovenance.prov.model.ProvFactory)pf);
            JsonNode vObj = (JsonNode)pair.getValue();
            Iterator elements = vObj.elements();
            HashSet<Attribute> set = new HashSet<Attribute>();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                Attribute attr = new CustomAttributeDeserializerWithRootName().deserialize(elementName, next, deserializationContext);
                set.add(attr);
            }
            result.put(elementName, set);
            System.out.println("==> CustomAttributeMapDeserializer" + vObj + " " + vObj.getClass());
        }
        System.out.println("==> CustomAttributeMapDeserializer " + result + " " + result.getClass());
        return result;
    }
}

