/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomThreadConfig;
import org.openprovenance.prov.model.Namespace;

public class CustomNamespaceDeserializer
extends StdDeserializer<Namespace> {
    private final JavaType tr;

    public CustomNamespaceDeserializer(JavaType tr) {
        super(tr);
        this.tr = tr;
    }

    public Namespace deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        Namespace previous = CustomThreadConfig.getAttributes().get().get("CONTEXT_KEY_NAMESPACE");
        Namespace ns = new Namespace();
        if (previous != null) {
            ns.setParent(previous);
        }
        if (jp.isExpectedStartArrayToken()) {
            Object[] objects;
            for (Object o : objects = (Object[])jp.readValueAs(Object[].class)) {
                this.processContextObject(ns, o);
            }
        }
        CustomThreadConfig.getAttributes().get().put("CONTEXT_KEY_NAMESPACE", ns);
        Namespace.withThreadNamespace((Namespace)ns);
        return ns;
    }

    public void processContextObject(Namespace ns, Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            block8: for (Map.Entry entry : map.entrySet()) {
                String key;
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String valueString = (String)value;
                switch (key = (String)entry.getKey()) {
                    case "@namespace": {
                        ns.setDefaultNamespace(valueString);
                        continue block8;
                    }
                    case "@version": {
                        continue block8;
                    }
                }
                ns.register(key, valueString);
            }
        }
    }
}

