package org.openprovenance.prov.core.jsonld11.serialization;

import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;

import java.util.Map;

public class MisnamedBundle extends org.openprovenance.prov.vanilla.Bundle {
    public org.openprovenance.prov.model.Bundle toBundle(ProvFactory pf) {
        QualifiedName oldId = getId();
        //System.out.println("MisnamedBundle.toBundle " + oldId);
        Namespace namespace = getNamespace();
        String prefix = oldId.getPrefix();

        Map<String, String> prefixes = namespace.getPrefixes();
        QualifiedName newId = pf.newQualifiedName(prefixes.get(prefix), oldId.getLocalPart(), prefix);

        Bundle bundle = pf.newNamedBundle(newId, namespace, getStatement());

       // System.out.println("MisnamedBundle.toBundle " + oldId + " -> " + newId);

        return bundle;


    }
}
