/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedRelation;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.vanilla.QualifiedSpecializationOf;

public class SortedBundle {
    Map<QualifiedName, Entity> entity = new HashMap<QualifiedName, Entity>();
    Namespace namespace = new Namespace();
    Map<QualifiedName, Activity> activity = new HashMap<QualifiedName, Activity>();
    Map<QualifiedName, Agent> agent = new HashMap<QualifiedName, Agent>();
    Map<QualifiedName, Used> used = new HashMap<QualifiedName, Used>();
    Map<QualifiedName, WasGeneratedBy> wgb = new HashMap<QualifiedName, WasGeneratedBy>();
    Map<QualifiedName, WasInvalidatedBy> wib = new HashMap<QualifiedName, WasInvalidatedBy>();
    Map<QualifiedName, WasAssociatedWith> wasAssociatedWith = new HashMap<QualifiedName, WasAssociatedWith>();
    Map<QualifiedName, WasAttributedTo> wasAttributedTo = new HashMap<QualifiedName, WasAttributedTo>();
    Map<QualifiedName, ActedOnBehalfOf> actedOnBehalfOf = new HashMap<QualifiedName, ActedOnBehalfOf>();
    Map<QualifiedName, WasStartedBy> wasStartedBy = new HashMap<QualifiedName, WasStartedBy>();
    Map<QualifiedName, WasEndedBy> wasEndedBy = new HashMap<QualifiedName, WasEndedBy>();
    Map<QualifiedName, WasInformedBy> wasInformedBy = new HashMap<QualifiedName, WasInformedBy>();
    Map<QualifiedName, WasInfluencedBy> wasInfluencedBy = new HashMap<QualifiedName, WasInfluencedBy>();
    Map<QualifiedName, AlternateOf> alternateOf = new HashMap<QualifiedName, AlternateOf>();
    Map<QualifiedName, SpecializationOf> specializationOf = new HashMap<QualifiedName, SpecializationOf>();
    Map<QualifiedName, HadMember> hadMember = new HashMap<QualifiedName, HadMember>();
    Map<QualifiedName, WasDerivedFrom> wasDerivedFrom = new HashMap<QualifiedName, WasDerivedFrom>();
    Map<QualifiedName, QualifiedSpecializationOf> qualifiedSpecializationOf = new HashMap<QualifiedName, QualifiedSpecializationOf>();
    Map<QualifiedName, QualifiedAlternateOf> qualifiedAlternateOf = new HashMap<QualifiedName, QualifiedAlternateOf>();
    Map<QualifiedName, QualifiedHadMember> qualifiedHadMember = new HashMap<QualifiedName, QualifiedHadMember>();
    public static String bnNS = "https://openprovenance.org/blank#";
    public static final String bnPrefix = "_";
    public static int count = 0;
    private QualifiedName id;
    final boolean deferredId;

    <T extends Statement> void put(Map<QualifiedName, T> map, StatementOrBundle s) {
        if (s instanceof Identifiable) {
            Identifiable iS = (Identifiable)s;
            if (iS.getId() == null) {
                map.put(this.gensym(), (Statement)s);
            } else {
                map.put(iS.getId(), (Statement)s);
            }
        } else {
            map.put(this.gensym(), (Statement)s);
        }
    }

    void put(Map<QualifiedName, Bundle> map, Bundle bun) {
        map.put(bun.getId(), bun);
    }

    public QualifiedName gensym() {
        return new org.openprovenance.prov.vanilla.QualifiedName(bnNS, "n" + count++, bnPrefix);
    }

    protected SortedBundle() {
        this.deferredId = true;
    }

    public SortedBundle(Bundle bun) {
        this.namespace = bun.getNamespace();
        this.id = bun.getId();
        this.deferredId = false;
        for (Statement s : bun.getStatement()) {
            switch (s.getKind()) {
                case PROV_ENTITY: {
                    this.put(this.entity, (StatementOrBundle)s);
                    break;
                }
                case PROV_ACTIVITY: {
                    this.put(this.activity, (StatementOrBundle)s);
                    break;
                }
                case PROV_AGENT: {
                    this.put(this.agent, (StatementOrBundle)s);
                    break;
                }
                case PROV_USAGE: {
                    this.put(this.used, (StatementOrBundle)s);
                    break;
                }
                case PROV_GENERATION: {
                    this.put(this.wgb, (StatementOrBundle)s);
                    break;
                }
                case PROV_INVALIDATION: {
                    this.put(this.wib, (StatementOrBundle)s);
                    break;
                }
                case PROV_START: {
                    this.put(this.wasStartedBy, (StatementOrBundle)s);
                    break;
                }
                case PROV_END: {
                    this.put(this.wasEndedBy, (StatementOrBundle)s);
                    break;
                }
                case PROV_COMMUNICATION: {
                    this.put(this.wasInformedBy, (StatementOrBundle)s);
                    break;
                }
                case PROV_DERIVATION: {
                    this.put(this.wasDerivedFrom, (StatementOrBundle)s);
                    break;
                }
                case PROV_ASSOCIATION: {
                    this.put(this.wasAssociatedWith, (StatementOrBundle)s);
                    break;
                }
                case PROV_ATTRIBUTION: {
                    this.put(this.wasAttributedTo, (StatementOrBundle)s);
                    break;
                }
                case PROV_DELEGATION: {
                    this.put(this.actedOnBehalfOf, (StatementOrBundle)s);
                    break;
                }
                case PROV_INFLUENCE: {
                    this.put(this.wasInfluencedBy, (StatementOrBundle)s);
                    break;
                }
                case PROV_ALTERNATE: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedAlternateOf, (StatementOrBundle)s);
                        break;
                    }
                    this.put(this.alternateOf, (StatementOrBundle)s);
                    break;
                }
                case PROV_SPECIALIZATION: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedSpecializationOf, (StatementOrBundle)s);
                        break;
                    }
                    this.put(this.specializationOf, (StatementOrBundle)s);
                }
                case PROV_MENTION: {
                    break;
                }
                case PROV_MEMBERSHIP: {
                    if (s instanceof QualifiedRelation) {
                        this.put(this.qualifiedHadMember, (StatementOrBundle)s);
                        break;
                    }
                    this.put(this.hadMember, (StatementOrBundle)s);
                    break;
                }
                case PROV_BUNDLE: {
                    break;
                }
                case PROV_DICTIONARY_INSERTION: {
                    break;
                }
                case PROV_DICTIONARY_REMOVAL: {
                    break;
                }
            }
        }
    }

    public QualifiedName getId() {
        return this.id;
    }

    public void setId(QualifiedName id) {
        this.id = id;
    }

    public Map<String, String> getPrefix() {
        return this.namespace.getPrefixes();
    }

    public String getDefaultNamespace() {
        return this.namespace.getDefaultNamespace();
    }

    public void setPrefix(Map<String, String> ns) {
        for (Map.Entry<String, String> entry : ns.entrySet()) {
            this.namespace.register(entry.getKey(), entry.getValue());
        }
    }

    public void setDefaultNamespace(String name) {
        this.namespace.setDefaultNamespace(name);
    }

    public Map<QualifiedName, Activity> getActivity() {
        return this.activity;
    }

    public Map<QualifiedName, Entity> getEntity() {
        return this.entity;
    }

    public Map<QualifiedName, Agent> getAgent() {
        return this.agent;
    }

    public Map<QualifiedName, Used> getUsed() {
        return this.used;
    }

    public Map<QualifiedName, WasGeneratedBy> getWasGeneratedBy() {
        return this.wgb;
    }

    public Map<QualifiedName, WasInvalidatedBy> getWasInvalidatedBy() {
        return this.wib;
    }

    public Map<QualifiedName, WasAssociatedWith> getWasAssociatedWith() {
        return this.wasAssociatedWith;
    }

    public Map<QualifiedName, WasAttributedTo> getWasAttributedTo() {
        return this.wasAttributedTo;
    }

    public Map<QualifiedName, ActedOnBehalfOf> getActedOnBehalfOf() {
        return this.actedOnBehalfOf;
    }

    public Map<QualifiedName, WasStartedBy> getWasStartedBy() {
        return this.wasStartedBy;
    }

    public Map<QualifiedName, WasEndedBy> getWasEndedBy() {
        return this.wasEndedBy;
    }

    public Map<QualifiedName, WasInformedBy> getWasInformedBy() {
        return this.wasInformedBy;
    }

    public Map<QualifiedName, WasInfluencedBy> getWasInfluencedBy() {
        return this.wasInfluencedBy;
    }

    public Map<QualifiedName, AlternateOf> getAlternateOf() {
        return this.alternateOf;
    }

    public Map<QualifiedName, SpecializationOf> getSpecializationOf() {
        return this.specializationOf;
    }

    public Map<QualifiedName, QualifiedSpecializationOf> getQualifiedSpecializationOf() {
        return this.qualifiedSpecializationOf;
    }

    public Map<QualifiedName, HadMember> getHadMember() {
        return this.hadMember;
    }

    public Map<QualifiedName, WasDerivedFrom> getWasDerivedFrom() {
        return this.wasDerivedFrom;
    }

    public Map<QualifiedName, QualifiedAlternateOf> getQualifiedAlternateOf() {
        return this.qualifiedAlternateOf;
    }

    public Map<QualifiedName, QualifiedHadMember> getQualifiedHadMember() {
        return this.qualifiedHadMember;
    }

    public <S extends Identifiable> Map<QualifiedName, S> reassignId(Map<QualifiedName, S> map) {
        for (Map.Entry<QualifiedName, S> entry : map.entrySet()) {
            QualifiedName name = entry.getKey();
            if (name.getNamespaceURI().equals(bnNS)) continue;
            ((Identifiable)entry.getValue()).setId(name);
        }
        return map;
    }

    public Bundle toBundle(ProvFactory provFactory) {
        LinkedList<Object> ss = new LinkedList<Object>();
        ss.addAll(this.reassignId(this.getEntity()).values());
        ss.addAll(this.reassignId(this.getActivity()).values());
        ss.addAll(this.reassignId(this.getAgent()).values());
        ss.addAll(this.reassignId(this.getUsed()).values());
        ss.addAll(this.reassignId(this.getWasGeneratedBy()).values());
        ss.addAll(this.reassignId(this.getWasInvalidatedBy()).values());
        ss.addAll(this.reassignId(this.getWasAssociatedWith()).values());
        ss.addAll(this.reassignId(this.getWasAttributedTo()).values());
        ss.addAll(this.reassignId(this.getActedOnBehalfOf()).values());
        ss.addAll(this.reassignId(this.getWasStartedBy()).values());
        ss.addAll(this.reassignId(this.getWasEndedBy()).values());
        ss.addAll(this.reassignId(this.getWasInformedBy()).values());
        ss.addAll(this.reassignId(this.getWasInfluencedBy()).values());
        ss.addAll(this.getAlternateOf().values());
        ss.addAll(this.getSpecializationOf().values());
        ss.addAll(this.getHadMember().values());
        ss.addAll(this.reassignId(this.getWasDerivedFrom()).values());
        ss.addAll(this.reassignId(this.getQualifiedSpecializationOf()).values());
        ss.addAll(this.reassignId(this.getQualifiedAlternateOf()).values());
        ss.addAll(this.reassignId(this.getQualifiedHadMember()).values());
        if (this.deferredId) {
            Map prefixes = this.namespace.getPrefixes();
            String prefix = this.id.getPrefix();
            QualifiedName newId = provFactory.newQualifiedName((String)prefixes.get(prefix), this.id.getLocalPart(), prefix);
            Bundle bundle = provFactory.newNamedBundle(newId, this.namespace, ss);
            return bundle;
        }
        return provFactory.newNamedBundle(this.id, this.namespace, ss);
    }
}

