/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomDeferredQualifiedNameDeserializer
extends StdDeserializer<QualifiedName> {
    static final ProvFactory pf = new ProvFactory();
    static final QualifiedName PROV_TYPE = CustomDeferredQualifiedNameDeserializer.pf.getName().PROV_TYPE;
    public static final String OPENPROVENANCE_DEFERREDNS_DEFAULTNS = "https://openprovenance/deferredns/defaultns";
    public static final String OPENPROVENANCE_DEFERREDNS_DEFERREDNS = "https://openprovenance/deferredns/deferredns";

    public CustomDeferredQualifiedNameDeserializer() {
        this(QualifiedName.class);
    }

    public CustomDeferredQualifiedNameDeserializer(Class<?> vc) {
        super(vc);
    }

    public QualifiedName deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String text = jsonParser.getText();
        if ("type".equals(text)) {
            return PROV_TYPE;
        }
        return this.getDeferredQualifiedName(text);
    }

    public QualifiedName deserialize(String text, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        return this.getDeferredQualifiedName(text);
    }

    private QualifiedName getDeferredQualifiedName(String text) {
        int index = text.indexOf(58);
        if (index == -1) {
            return pf.newQualifiedName(OPENPROVENANCE_DEFERREDNS_DEFAULTNS, text, null);
        }
        String prefix = text.substring(0, index);
        String local = text.substring(index + 1);
        return pf.newQualifiedName(OPENPROVENANCE_DEFERREDNS_DEFERREDNS, local, prefix);
    }
}

