/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openprovenance.prov.model.Namespace;

public class CustomNamespaceSerializer
extends StdSerializer<Namespace> {
    public static final String JSONLD_DEFAULT_NAMESPACE = "@vocab";
    private final boolean embedContext;
    static Map<String, Object> embeddedContext;

    public CustomNamespaceSerializer(boolean embedContext) {
        super(Namespace.class);
        this.embedContext = embedContext;
    }

    protected CustomNamespaceSerializer(Class<Namespace> t) {
        super(t);
        this.embedContext = false;
    }

    public static Map<String, Object> readContext() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, Object.class);
        Map o = (Map)mapper.readValue(CustomNamespaceSerializer.class.getResourceAsStream("/context-jsonld11.json"), (JavaType)mapType);
        return o;
    }

    public void serialize(Namespace namespace, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.putAll(namespace.getPrefixes());
        String defaultNS = namespace.getDefaultNamespace();
        if (defaultNS != null) {
            prefixes.put(JSONLD_DEFAULT_NAMESPACE, defaultNS);
        }
        Object[] theContext = new Object[]{prefixes, this.embedContext ? embeddedContext : "https://openprovenance.org/prov-jsonld/context.json"};
        jsonGenerator.writeObject((Object)theContext);
    }

    static {
        try {
            embeddedContext = CustomNamespaceSerializer.readContext();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

