/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.core.jsonld11.serialization.ProvMixin;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomAttributeDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomBundleDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomNamespaceDeserializer;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomThreadConfig;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomXMLGregorianCalendarDeserializer;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.vanilla.Bundle;

public class ProvDeserialiser
implements org.openprovenance.prov.model.ProvDeserialiser {
    private static final Logger logger = LogManager.getLogger(ProvDeserialiser.class);
    final ObjectMapper mapper;
    private final DateTimeOption dateTimeOption;
    private final TimeZone optionalTimeZone;

    public ProvDeserialiser() {
        this(new ObjectMapper());
    }

    public ProvDeserialiser(ObjectMapper mapper) {
        this.mapper = mapper;
        this.dateTimeOption = DateTimeOption.PRESERVE;
        this.optionalTimeZone = null;
        this.customize(mapper);
    }

    public ProvDeserialiser(ObjectMapper mapper, DateTimeOption dateTimeOption) {
        this.mapper = mapper;
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = null;
        this.customize(mapper);
    }

    public ProvDeserialiser(ObjectMapper mapper, DateTimeOption dateTimeOption, TimeZone optionalTimeZone) {
        this.mapper = mapper;
        this.dateTimeOption = dateTimeOption;
        this.optionalTimeZone = optionalTimeZone;
        this.customize(mapper);
    }

    public ProvMixin provMixin() {
        return new ProvMixin();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Document deserialiseDocument(InputStream in) {
        CustomThreadConfig.getAttributes().get().remove("JSONLD_CONTEXT_KEY_NAMESPACE");
        try {
            return (Document)this.mapper.readValue(in, org.openprovenance.prov.vanilla.Document.class);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
            throw new UncheckedException((Exception)e);
        }
    }

    public Document deserialiseDocument(BufferedReader in) {
        CustomThreadConfig.getAttributes().get().remove("JSONLD_CONTEXT_KEY_NAMESPACE");
        try {
            return (Document)this.mapper.readValue((Reader)in, org.openprovenance.prov.vanilla.Document.class);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
            throw new UncheckedException((Exception)e);
        }
    }

    public void customize(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("CustomKindDeserializer", new Version(1, 0, 0, null, null, null));
        TypeFactory typeFactory = mapper.getTypeFactory();
        MapType mapType2 = typeFactory.constructMapType(HashMap.class, String.class, Object.class);
        ArrayType arrayType = typeFactory.constructArrayType((JavaType)mapType2);
        module.addDeserializer(Namespace.class, (JsonDeserializer)this.newCustomNamespaceDeserializer(arrayType));
        module.addDeserializer(Bundle.class, (JsonDeserializer)new CustomBundleDeserializer());
        module.addDeserializer(Attribute.class, (JsonDeserializer)new CustomAttributeDeserializer());
        module.addDeserializer(XMLGregorianCalendar.class, (JsonDeserializer)new CustomXMLGregorianCalendarDeserializer(this.dateTimeOption, this.optionalTimeZone));
        this.provMixin().addProvMixin(mapper);
        mapper.registerModule((Module)module);
    }

    public CustomNamespaceDeserializer newCustomNamespaceDeserializer(ArrayType arrayType) {
        return new CustomNamespaceDeserializer((JavaType)arrayType);
    }
}

