/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization.deserial;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.openprovenance.prov.core.jsonld11.serialization.deserial.CustomThreadConfig;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.ProvFactory;

public class CustomQualifiedNameDeserializer
extends StdDeserializer<QualifiedName> {
    static final ProvFactory pf = new ProvFactory();
    static final QualifiedName PROV_TYPE = CustomQualifiedNameDeserializer.pf.getName().PROV_TYPE;
    static final QualifiedName PROV_LOCATION = CustomQualifiedNameDeserializer.pf.getName().PROV_LOCATION;
    static final QualifiedName PROV_LABEL = CustomQualifiedNameDeserializer.pf.getName().PROV_LABEL;
    static final QualifiedName PROV_ROLE = CustomQualifiedNameDeserializer.pf.getName().PROV_ROLE;
    static final QualifiedName PROV_VALUE = CustomQualifiedNameDeserializer.pf.getName().PROV_VALUE;

    public CustomQualifiedNameDeserializer() {
        this(QualifiedName.class);
    }

    public CustomQualifiedNameDeserializer(Class<?> vc) {
        super(vc);
    }

    public QualifiedName deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Namespace ns = CustomThreadConfig.getAttributes().get().get("JSONLD_CONTEXT_KEY_NAMESPACE");
        String text = jsonParser.getText();
        if ("@type".equals(text)) {
            return PROV_TYPE;
        }
        switch (text) {
            case "location": {
                return PROV_LOCATION;
            }
            case "label": {
                return PROV_LABEL;
            }
            case "role": {
                return PROV_ROLE;
            }
            case "type": {
                return PROV_TYPE;
            }
            case "value": {
                return PROV_VALUE;
            }
        }
        return ns.stringToQualifiedName(text, (org.openprovenance.prov.model.ProvFactory)pf, true);
    }

    public QualifiedName deserialize(String s, DeserializationContext deserializationContext) throws IOException {
        Namespace ns = CustomThreadConfig.getAttributes().get().get("JSONLD_CONTEXT_KEY_NAMESPACE");
        if ("@type".equals(s)) {
            return PROV_TYPE;
        }
        switch (s) {
            case "location": {
                return PROV_LOCATION;
            }
            case "label": {
                return PROV_LABEL;
            }
            case "role": {
                return PROV_ROLE;
            }
            case "type": {
                return PROV_TYPE;
            }
            case "value": {
                return PROV_VALUE;
            }
        }
        return ns.stringToQualifiedName(s, (org.openprovenance.prov.model.ProvFactory)pf, true);
    }
}

