/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase;
import org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.vanilla.ProvFactory;

public class DateTest
extends TestCase {
    final ProvFactory pFactory = new ProvFactory();
    String startDate = "2023-09-08T20:12:45.109-04:00";
    String endDate = "2023-10-15T20:35:06.793-02:00";
    String jsonld = "{\n  \"@context\" : [ {\n    \"xsd\" : \"http://www.w3.org/2001/XMLSchema#\",\n    \"ex\" : \"https://example.org/\",\n    \"prov\" : \"http://www.w3.org/ns/prov#\"\n  }, \"https://openprovenance.org/prov-jsonld/context.jsonld\" ],\n  \"@graph\" : [ {\n    \"@type\" : \"Activity\",\n    \"@id\" : \"ex:a\",\n    \"startTime\" : \"2023-09-08T20:12:45.109-04:00\",\n    \"endTime\" : \"2023-10-15T20:35:06.793-02:00\"\n  } ]\n}";
    XMLGregorianCalendar noTZstart = this.pFactory.newISOTime(this.startDate);
    XMLGregorianCalendar noTZend = this.pFactory.newISOTime(this.endDate);
    XMLGregorianCalendar yesTZstart = this.pFactory.newISOTimeTZ(this.startDate);
    XMLGregorianCalendar yesTZend = this.pFactory.newISOTimeTZ(this.endDate);

    public void testDateJsonldUTC() {
        ProvDeserialiser deserial = new ProvDeserialiser(new ObjectMapper(), DateTimeOption.UTC);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.jsonld.getBytes());
        Document doc = deserial.deserialiseDocument((InputStream)inputStream);
        DateTest.assertNotNull((Object)doc);
        DateTest.assertEquals((int)1, (int)doc.getStatementOrBundle().size());
        Activity activity = (Activity)doc.getStatementOrBundle().get(0);
        DateTest.assertNotNull((Object)activity);
        DateTest.assertEquals((Object)this.noTZstart, (Object)activity.getStartTime());
        DateTest.assertEquals((Object)this.noTZend, (Object)activity.getEndTime());
        DateTest.assertNotSame((Object)this.startDate, (Object)activity.getStartTime().toXMLFormat());
        DateTest.assertNotSame((Object)this.endDate, (Object)activity.getEndTime().toXMLFormat());
        DateTest.assertEquals((int)0, (int)activity.getStartTime().getTimezone());
        DateTest.assertEquals((int)0, (int)activity.getEndTime().getTimezone());
        DateTest.assertEquals((int)-240, (int)this.yesTZstart.getTimezone());
        DateTest.assertEquals((int)-120, (int)this.yesTZend.getTimezone());
    }

    public void testDateJsonldPreserve() {
        ProvDeserialiser deserial = new ProvDeserialiser(new ObjectMapper(), DateTimeOption.PRESERVE);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.jsonld.getBytes());
        Document doc = deserial.deserialiseDocument((InputStream)inputStream);
        DateTest.assertNotNull((Object)doc);
        DateTest.assertEquals((int)1, (int)doc.getStatementOrBundle().size());
        Activity activity = (Activity)doc.getStatementOrBundle().get(0);
        DateTest.assertNotNull((Object)activity);
        DateTest.assertEquals((Object)this.noTZstart, (Object)activity.getStartTime());
        DateTest.assertEquals((Object)this.noTZend, (Object)activity.getEndTime());
        DateTest.assertNotSame((Object)this.startDate, (Object)activity.getStartTime().toXMLFormat());
        DateTest.assertNotSame((Object)this.endDate, (Object)activity.getEndTime().toXMLFormat());
        DateTest.assertEquals((int)-240, (int)activity.getStartTime().getTimezone());
        DateTest.assertEquals((int)-120, (int)activity.getEndTime().getTimezone());
        DateTest.assertEquals((int)-240, (int)this.yesTZstart.getTimezone());
        DateTest.assertEquals((int)-120, (int)this.yesTZend.getTimezone());
    }

    public void testDateJsonldTZ() {
        TimeZone tz = TimeZone.getTimeZone("Japan");
        ProvDeserialiser deserial = new ProvDeserialiser(new ObjectMapper(), DateTimeOption.TIMEZONE, tz);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.jsonld.getBytes());
        Document doc = deserial.deserialiseDocument((InputStream)inputStream);
        DateTest.assertNotNull((Object)doc);
        DateTest.assertEquals((int)1, (int)doc.getStatementOrBundle().size());
        Activity activity = (Activity)doc.getStatementOrBundle().get(0);
        DateTest.assertNotNull((Object)activity);
        DateTest.assertEquals((Object)this.noTZstart, (Object)activity.getStartTime());
        DateTest.assertEquals((Object)this.noTZend, (Object)activity.getEndTime());
        DateTest.assertNotSame((Object)this.startDate, (Object)activity.getStartTime().toXMLFormat());
        DateTest.assertNotSame((Object)this.endDate, (Object)activity.getEndTime().toXMLFormat());
        DateTest.assertEquals((int)540, (int)activity.getStartTime().getTimezone());
        DateTest.assertEquals((int)540, (int)activity.getEndTime().getTimezone());
        DateTest.assertEquals((int)-240, (int)this.yesTZstart.getTimezone());
        DateTest.assertEquals((int)-120, (int)this.yesTZend.getTimezone());
    }
}

