/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser;
import org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.RoundTripFromJavaTest;

public class RoundTripFromJavaJSONLD11Test
extends RoundTripFromJavaTest {
    final ObjectMapper mapper = new ObjectMapper();

    public Document readDocumentFromFile(String file) throws IOException {
        this.readingMessage(file);
        ProvDeserialiser deserial = new ProvDeserialiser();
        return deserial.deserialiseDocument((InputStream)new FileInputStream(file));
    }

    public void readingMessage(String file) {
        System.out.println(" reading from " + file);
    }

    public void writingMessage(String file) {
        System.out.println("writing to " + file);
    }

    public void writeDocumentToFile(Document doc, String file) throws IOException {
        this.writingMessage(file);
        ProvSerialiser serial = new ProvSerialiser(this.mapper, false);
        serial.serialiseDocument((OutputStream)new FileOutputStream(file), doc, true);
    }

    public void executeAndWait(String command) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(command);
        try {
            int exitValue = proc.waitFor();
            if (exitValue == 0) {
                return;
            }
            try (BufferedReader b = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                String line = b.readLine();
                if (line != null) {
                    System.out.println(this.escapeRed(line));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new IOException("exit value " + exitValue);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String extension() {
        return ".jsonld";
    }

    public boolean checkTest(String name) {
        if (name.contains("DictionaryMembership")) {
            System.out.println(this.escapeRed("########## Skipping testing for " + name + " in " + this.extension()));
            return false;
        }
        try {
            this.executeAndWait("ajv -s " + this.jsonSchemaLocation() + " -d " + name);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String jsonSchemaLocation() {
        return "src/main/resources/2024-06-11/jsonldschema.json";
    }

    public void testDictionaryMembership1() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership1 (jsonld)"));
    }

    public void testDictionaryMembership2() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership2 (jsonld)"));
    }

    public void testDictionaryMembership3() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership3 (jsonld)"));
    }

    public void testDictionaryMembership4() {
        System.out.println(this.escapeRed("########## Skipping testDictionaryMembership4 (jsonld)"));
    }
}

