/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.jsonld11.serialization;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.prov.core.jsonld11.serialization.ProvMixin;
import org.openprovenance.prov.core.jsonld11.serialization.serial.CustomDateSerializer;
import org.openprovenance.prov.core.jsonld11.serialization.serial.CustomNamespaceSerializer;
import org.openprovenance.prov.core.jsonld11.serialization.serial.CustomOverridingAttributeSerializer;
import org.openprovenance.prov.core.jsonld11.serialization.serial.CustomQualifiedNameSerializer;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.vanilla.QualifiedName;
import org.openprovenance.prov.vanilla.TypedValue;

public class ProvSerialiser
implements org.openprovenance.prov.model.ProvSerialiser {
    private static final Collection<String> myMedia = Set.of("application/ld+json");
    protected final boolean embedContext;
    final ObjectMapper mapper;
    final ObjectMapper mapperWithFormat = new ObjectMapper();
    final ObjectWriter writer;

    public ProvSerialiser() {
        this(new ObjectMapper(), false);
    }

    public ProvSerialiser(ObjectMapper mapper, boolean embedContext) {
        this.embedContext = embedContext;
        this.mapper = mapper;
        this.customize(mapper);
        this.customize(this.mapperWithFormat);
        this.mapperWithFormat.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.INDENT_OUTPUT);
        this.writer = mapper.writer().withDefaultPrettyPrinter();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public ProvMixin provMixin() {
        return new ProvMixin();
    }

    public void serialiseDocument(OutputStream out, Document document, boolean formatted) {
        try {
            if (formatted) {
                this.mapperWithFormat.writeValue(out, (Object)document);
            } else {
                this.writer.writeValue(out, (Object)document);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException((Exception)e);
        }
    }

    public ObjectMapper customize(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("CustomKindSerializer", new Version(1, 0, 0, null, null, null));
        module.addSerializer(QualifiedName.class, (JsonSerializer)new CustomQualifiedNameSerializer());
        module.addSerializer(XMLGregorianCalendar.class, (JsonSerializer)new CustomDateSerializer());
        module.addSerializer(Namespace.class, (JsonSerializer)new CustomNamespaceSerializer(this.embedContext));
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                        if (TypedValue.class.isAssignableFrom(desc.getBeanClass())) {
                            return new CustomOverridingAttributeSerializer(serializer);
                        }
                        return serializer;
                    }
                });
            }
        });
        this.provMixin().addProvMixin(mapper);
        return mapper;
    }
}

