/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.json.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openprovenance.prov.core.json.serialization.ProvDeserialiser;
import org.openprovenance.prov.core.json.serialization.ProvSerialiser;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvUtilities;

public class PC1FullTest
extends org.openprovenance.prov.model.test.PC1FullTest {
    String filename = "target/pc1-full.json";
    ProvUtilities util = new ProvUtilities();

    public void subtestPC1Full() throws FileNotFoundException {
        Document graph = this.makePC1FullGraph(pFactory);
        ProvSerialiser serial = new ProvSerialiser();
        Namespace.withThreadNamespace((Namespace)graph.getNamespace());
        System.out.println("writing to " + this.filename);
        serial.serialiseDocument((OutputStream)new FileOutputStream(this.filename), graph, true);
        graph1 = graph;
        PC1FullTest.assertTrue((boolean)true);
    }

    public void subtestCopyPC1Full() throws FileNotFoundException, IOException {
        Document c;
        System.out.println(" reading from " + this.filename);
        ProvDeserialiser deserial = new ProvDeserialiser();
        graph2 = c = deserial.deserialiseDocument((InputStream)new FileInputStream(this.filename));
        PC1FullTest.assertEquals((String)"self graph1 differ", (Object)graph1, (Object)graph1);
        PC1FullTest.assertEquals((String)"self c differ", (Object)c, (Object)c);
        try {
            PC1FullTest.assertEquals((String)"graph1 and graph2 differ", (Object)graph1, (Object)c);
            PC1FullTest.fail();
        }
        catch (AssertionError e) {
            System.out.println("********* pc1-full.json: graph1 and graph2 differ  *********");
        }
    }

    public void subtestReadXMLGraph() throws IOException {
        Document c;
        ProvDeserialiser deserial = new ProvDeserialiser();
        graph2 = c = deserial.deserialiseDocument((InputStream)new FileInputStream(this.filename));
        graph2.setNamespace(graph1.getNamespace());
        ProvSerialiser serial = new ProvSerialiser();
        Namespace.withThreadNamespace((Namespace)graph2.getNamespace());
        serial.serialiseDocument((OutputStream)new FileOutputStream("target/pc1-full2.xml"), graph2, true);
        PC1FullTest.assertTrue((String)"graph1 a* and graph2 a* differ", (boolean)this.util.getActivity(graph1).equals(this.util.getActivity(graph2)));
        PC1FullTest.assertFalse((String)"graph1 e* and graph2 e* differ", (boolean)this.util.getEntity(graph1).equals(this.util.getEntity(graph2)));
        PC1FullTest.assertFalse((String)"graph1 and graph2 differ", (boolean)graph1.equals((Object)graph2));
        Document c2 = deserial.deserialiseDocument((InputStream)new FileInputStream("target/pc1-full.xml"));
        c2.setNamespace(graph1.getNamespace());
        PC1FullTest.assertFalse((String)"c e* and c2 e* differ", (boolean)this.util.getEntity(c).equals(this.util.getEntity(c2)));
        PC1FullTest.assertFalse((String)"c and c2 differ", (boolean)c.equals((Object)c2));
    }
}

