/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.openprovenance.prov.log.EventAction;

public class MyAppenderWrapper
extends AppenderSkeleton
implements AppenderAttachable {
    private EventAction action;
    private final List<Appender> appenders = new ArrayList<Appender>();

    public MyAppenderWrapper(EventAction action) {
        this.action = action;
    }

    public MyAppenderWrapper() {
        this.action = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Appender> list = this.appenders;
        synchronized (list) {
            for (Appender appender : this.appenders) {
                appender.close();
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        List<Appender> list = this.appenders;
        synchronized (list) {
            this.appenders.add(appender);
        }
    }

    public Enumeration getAllAppenders() {
        return Collections.enumeration(this.appenders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        List<Appender> list = this.appenders;
        synchronized (list) {
            for (Appender appender : this.appenders) {
                if (!appender.getName().equals(name)) continue;
                return appender;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        List<Appender> list = this.appenders;
        synchronized (list) {
            for (Appender wrapped : this.appenders) {
                if (!wrapped.equals(appender)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        List<Appender> list = this.appenders;
        synchronized (list) {
            this.appenders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        List<Appender> list = this.appenders;
        synchronized (list) {
            Iterator<Appender> i = this.appenders.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(appender)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        List<Appender> list = this.appenders;
        synchronized (list) {
            Iterator<Appender> i = this.appenders.iterator();
            while (i.hasNext()) {
                if (!i.next().getName().equals(name)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append_original(LoggingEvent event) {
        String modifiedMessage = String.format("**** Message modified by MyAppenderWrapper ****\n\n%s\n\n**** Finished modified message ****", event.getMessage());
        LoggingEvent modifiedEvent = new LoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), (Object)modifiedMessage, event.getThreadName(), event.getThrowableInformation(), event.getNDC(), event.getLocationInformation(), event.getProperties());
        List<Appender> list = this.appenders;
        synchronized (list) {
            for (Appender appender : this.appenders) {
                appender.doAppend(modifiedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        if (this.action != null) {
            this.action.perform(event);
        }
        List<Appender> list = this.appenders;
        synchronized (list) {
            for (Appender appender : this.appenders) {
                appender.doAppend(event);
            }
        }
    }
}

