package org.openprovenance.prov.model;

/**
 * <p>Interface for the PROV Communication association.
 * 
 * <p><a href="http://www.w3.org/TR/prov-dm/#concept-communication">PROV-DM Definition for Communication</a>: 
 * Communication is the exchange of some unspecified entity by two activities, one activity using some entity 
 * generated by the other.
 *  
 * <p>
 * 
 * <p><span class="strong">Relevant Factory Methods:</span>
 * <ul>
 * <li> {@link ProvFactory#newWasInformedBy(QualifiedName, QualifiedName, QualifiedName)}
 * <li> {@link ProvFactory#newWasInformedBy(QualifiedName, QualifiedName, QualifiedName, java.util.Collection)}
 * <li> {@link ObjectFactory#createWasInformedBy()}
 * </ul>
 * 
 * <p><span class="strong">Schema Definition:</span>
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 *    
 *  
 * <pre>
 * &lt;complexType name="Communication">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="informed" type="{http://www.w3.org/ns/prov#}IDRef"/>
 *         &lt;element name="informant" type="{http://www.w3.org/ns/prov#}IDRef"/>
 *         &lt;element ref="{http://www.w3.org/ns/prov#}label" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.w3.org/ns/prov#}type" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;any namespace='##other' maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute ref="{http://www.w3.org/ns/prov#}id"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *   
 * 
 * <p> 
 * @see <a href="http://www.w3.org/TR/prov-dm/#term-Communication">PROV-DM Communication</a>
 * @see <a href="http://www.w3.org/TR/prov-o/#Communication">PROV-O Communication</a>
 * @see <a href="http://www.w3.org/TR/prov-n/#expression-wasInformedBy">PROV-N Communication</a>
 * @see <a href="http://www.w3.org/TR/prov-xml/#term-Communication">PROV-XML Communication</a>
 * @see <a href="http://www.w3.org/Submission/2013/SUBM-prov-json-20130424/#term-Communication">PROV-JSON Communication</a>  
 *    
 * @author lavm
 *
 */

public interface WasInformedBy extends Identifiable,  HasLabel, HasType, HasOther, Influence {

    void setInformed(QualifiedName pid1);

    void setInformant(QualifiedName pid2);

    QualifiedName getInformed();

    QualifiedName getInformant();

}
