/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Relation;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementActionValue;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public class BeanTraversal
implements StatementActionValue {
    private final ModelConstructor c;
    private final ProvFactory pFactory;
    ProvUtilities u = new ProvUtilities();

    public BeanTraversal(ModelConstructor c, ProvFactory pFactory) {
        this.c = c;
        this.pFactory = pFactory;
    }

    @Override
    public ActedOnBehalfOf doAction(ActedOnBehalfOf del) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(del, attrs);
        this.convertLabelAttributes(del, attrs);
        this.convertAttributes(del, attrs);
        return this.c.newActedOnBehalfOf(del.getId(), del.getDelegate(), del.getResponsible(), del.getActivity(), attrs);
    }

    @Override
    public Activity doAction(Activity e) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(e, attrs);
        this.convertLabelAttributes(e, attrs);
        this.convertLocationAttributes(e, attrs);
        this.convertAttributes(e, attrs);
        return this.c.newActivity(e.getId(), e.getStartTime(), e.getEndTime(), attrs);
    }

    @Override
    public Agent doAction(Agent e) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(e, attrs);
        this.convertLabelAttributes(e, attrs);
        this.convertLocationAttributes(e, attrs);
        this.convertAttributes(e, attrs);
        return this.c.newAgent(e.getId(), attrs);
    }

    @Override
    public AlternateOf doAction(AlternateOf o) {
        return this.c.newAlternateOf(o.getAlternate1(), o.getAlternate2());
    }

    @Override
    public Relation doAction(DerivedByInsertionFrom o) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(o, attrs);
        this.convertLabelAttributes(o, attrs);
        this.convertAttributes(o, attrs);
        return this.c.newDerivedByInsertionFrom(o.getId(), o.getNewDictionary(), o.getOldDictionary(), o.getKeyEntityPair(), attrs);
    }

    @Override
    public Relation doAction(DerivedByRemovalFrom o) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(o, attrs);
        this.convertLabelAttributes(o, attrs);
        this.convertAttributes(o, attrs);
        return this.c.newDerivedByRemovalFrom(o.getId(), o.getNewDictionary(), o.getOldDictionary(), o.getKey(), attrs);
    }

    @Override
    public Relation doAction(DictionaryMembership o) {
        return this.c.newDictionaryMembership(o.getDictionary(), o.getKeyEntityPair());
    }

    public Document doAction(Document doc) {
        LinkedList<Bundle> bRecords = new LinkedList<Bundle>();
        LinkedList<Statement> sRecords = new LinkedList<Statement>();
        Namespace docNamespace = doc.getNamespace();
        Namespace.withThreadNamespace(docNamespace);
        this.c.startDocument(doc.getNamespace());
        for (Statement s : this.u.getStatement(doc)) {
            sRecords.add((Statement)this.u.doAction((StatementOrBundle)s, this));
        }
        for (Bundle bu : this.u.getNamedBundle(doc)) {
            Namespace.withThreadNamespace(new Namespace(docNamespace));
            Bundle o = this.doAction(bu, this.u);
            if (o == null) continue;
            bRecords.add(o);
        }
        return this.c.newDocument(doc.getNamespace(), sRecords, bRecords);
    }

    @Override
    public Entity doAction(Entity e) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(e, attrs);
        this.convertLabelAttributes(e, attrs);
        this.convertLocationAttributes(e, attrs);
        this.convertValueAttributes(e, attrs);
        this.convertAttributes(e, attrs);
        return this.c.newEntity(e.getId(), attrs);
    }

    @Override
    public HadMember doAction(HadMember o) {
        LinkedList<QualifiedName> qq = new LinkedList<QualifiedName>();
        if (o.getEntity() != null) {
            for (QualifiedName eid : o.getEntity()) {
                qq.add(eid);
            }
        }
        return this.c.newHadMember(o.getCollection(), qq);
    }

    @Override
    public MentionOf doAction(MentionOf o) {
        return this.c.newMentionOf(o.getSpecificEntity(), o.getGeneralEntity(), o.getBundle());
    }

    @Override
    public Bundle doAction(Bundle b, ProvUtilities u) {
        LinkedList<Statement> sRecords = new LinkedList<Statement>();
        QualifiedName bundleId = b.getId();
        Namespace old = Namespace.getThreadNamespace();
        Namespace bundleNamespace = b.getNamespace() != null ? new Namespace(b.getNamespace()) : new Namespace();
        bundleNamespace.setParent(new Namespace(old));
        Namespace.withThreadNamespace(bundleNamespace);
        this.c.startBundle(bundleId, b.getNamespace());
        for (Statement s : u.getStatement(b)) {
            sRecords.add((Statement)u.doAction((StatementOrBundle)s, this));
        }
        return this.c.newNamedBundle(bundleId, b.getNamespace(), sRecords);
    }

    @Override
    public SpecializationOf doAction(SpecializationOf o) {
        return this.c.newSpecializationOf(o.getSpecificEntity(), o.getGeneralEntity());
    }

    @Override
    public SpecializationOf doAction(QualifiedSpecializationOf o) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(o, attrs);
        this.convertLabelAttributes(o, attrs);
        this.convertAttributes(o, attrs);
        ModelConstructorExtension c2 = (ModelConstructorExtension)((Object)this.c);
        return c2.newQualifiedSpecializationOf(o.getId(), o.getSpecificEntity(), o.getGeneralEntity(), attrs);
    }

    @Override
    public AlternateOf doAction(QualifiedAlternateOf o) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(o, attrs);
        this.convertLabelAttributes(o, attrs);
        this.convertAttributes(o, attrs);
        ModelConstructorExtension c2 = (ModelConstructorExtension)((Object)this.c);
        return c2.newQualifiedAlternateOf(o.getId(), o.getAlternate1(), o.getAlternate2(), attrs);
    }

    @Override
    public HadMember doAction(QualifiedHadMember o) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(o, attrs);
        this.convertLabelAttributes(o, attrs);
        this.convertAttributes(o, attrs);
        ModelConstructorExtension c2 = (ModelConstructorExtension)((Object)this.c);
        LinkedList<QualifiedName> qq = new LinkedList<QualifiedName>();
        if (o.getEntity() != null) {
            for (QualifiedName eid : o.getEntity()) {
                qq.add(eid);
            }
        }
        return c2.newQualifiedHadMember(o.getId(), o.getCollection(), qq, attrs);
    }

    @Override
    public Used doAction(Used use) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(use, attrs);
        this.convertLabelAttributes(use, attrs);
        this.convertLocationAttributes(use, attrs);
        this.convertRoleAttributes(use, attrs);
        this.convertAttributes(use, attrs);
        return this.c.newUsed(use.getId(), use.getActivity(), use.getEntity(), use.getTime(), attrs);
    }

    @Override
    public WasAssociatedWith doAction(WasAssociatedWith assoc) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(assoc, attrs);
        this.convertLabelAttributes(assoc, attrs);
        this.convertRoleAttributes(assoc, attrs);
        this.convertAttributes(assoc, attrs);
        return this.c.newWasAssociatedWith(assoc.getId(), assoc.getActivity(), assoc.getAgent(), assoc.getPlan(), attrs);
    }

    @Override
    public WasAttributedTo doAction(WasAttributedTo att) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(att, attrs);
        this.convertLabelAttributes(att, attrs);
        this.convertAttributes(att, attrs);
        return this.c.newWasAttributedTo(att.getId(), att.getEntity(), att.getAgent(), attrs);
    }

    @Override
    public WasDerivedFrom doAction(WasDerivedFrom deriv) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(deriv, attrs);
        this.convertLabelAttributes(deriv, attrs);
        this.convertAttributes(deriv, attrs);
        return this.c.newWasDerivedFrom(deriv.getId(), deriv.getGeneratedEntity(), deriv.getUsedEntity(), deriv.getActivity(), deriv.getGeneration(), deriv.getUsage(), attrs);
    }

    @Override
    public WasEndedBy doAction(WasEndedBy end) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(end, attrs);
        this.convertLabelAttributes(end, attrs);
        this.convertLocationAttributes(end, attrs);
        this.convertRoleAttributes(end, attrs);
        this.convertAttributes(end, attrs);
        return this.c.newWasEndedBy(end.getId(), end.getActivity(), end.getTrigger(), end.getEnder(), end.getTime(), attrs);
    }

    @Override
    public WasGeneratedBy doAction(WasGeneratedBy gen) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(gen, attrs);
        this.convertLabelAttributes(gen, attrs);
        this.convertLocationAttributes(gen, attrs);
        this.convertRoleAttributes(gen, attrs);
        this.convertAttributes(gen, attrs);
        return this.c.newWasGeneratedBy(gen.getId(), gen.getEntity(), gen.getActivity(), gen.getTime(), attrs);
    }

    @Override
    public WasInfluencedBy doAction(WasInfluencedBy infl) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(infl, attrs);
        this.convertLabelAttributes(infl, attrs);
        this.convertAttributes(infl, attrs);
        return this.c.newWasInfluencedBy(infl.getId(), infl.getInfluencee(), infl.getInfluencer(), attrs);
    }

    @Override
    public WasInformedBy doAction(WasInformedBy inf) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(inf, attrs);
        this.convertLabelAttributes(inf, attrs);
        this.convertAttributes(inf, attrs);
        return this.c.newWasInformedBy(inf.getId(), inf.getInformed(), inf.getInformant(), attrs);
    }

    @Override
    public WasInvalidatedBy doAction(WasInvalidatedBy inv) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(inv, attrs);
        this.convertLabelAttributes(inv, attrs);
        this.convertLocationAttributes(inv, attrs);
        this.convertRoleAttributes(inv, attrs);
        this.convertAttributes(inv, attrs);
        return this.c.newWasInvalidatedBy(inv.getId(), inv.getEntity(), inv.getActivity(), inv.getTime(), attrs);
    }

    @Override
    public WasStartedBy doAction(WasStartedBy start) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        this.convertTypeAttributes(start, attrs);
        this.convertLabelAttributes(start, attrs);
        this.convertLocationAttributes(start, attrs);
        this.convertRoleAttributes(start, attrs);
        this.convertAttributes(start, attrs);
        return this.c.newWasStartedBy(start.getId(), start.getActivity(), start.getTrigger(), start.getStarter(), start.getTime(), attrs);
    }

    public List<Attribute> convertAttributes(HasOther e, List<Attribute> acc) {
        List<Other> ll = e.getOther();
        acc.addAll(ll);
        return acc;
    }

    public List<Attribute> convertLabelAttributes(HasLabel e, List<Attribute> acc) {
        List<LangString> labels = e.getLabel();
        for (LangString label : labels) {
            acc.add(this.pFactory.newAttribute(Attribute.AttributeKind.PROV_LABEL, (Object)label, this.pFactory.getName().XSD_STRING));
        }
        return acc;
    }

    public List<Attribute> convertLocationAttributes(HasLocation e, List<Attribute> acc) {
        List<Location> locations = e.getLocation();
        for (Location location : locations) {
            acc.add(this.pFactory.newAttribute(Attribute.AttributeKind.PROV_LOCATION, location.getValue(), location.getType()));
        }
        return acc;
    }

    public List<Attribute> convertRoleAttributes(HasRole e, List<Attribute> acc) {
        List<Role> roles = e.getRole();
        for (Role role : roles) {
            acc.add(this.pFactory.newAttribute(Attribute.AttributeKind.PROV_ROLE, role.getValue(), role.getType()));
        }
        return acc;
    }

    public List<Attribute> convertTypeAttributes(HasType e, List<Attribute> acc) {
        List<Type> types = e.getType();
        for (Type type : types) {
            acc.add(this.pFactory.newAttribute(Attribute.AttributeKind.PROV_TYPE, type.getValue(), type.getType()));
        }
        return acc;
    }

    public Object convertValueAttributes(HasValue e, List<Attribute> acc) {
        Value value = e.getValue();
        if (value == null) {
            return acc;
        }
        acc.add(this.pFactory.newAttribute(Attribute.AttributeKind.PROV_VALUE, value.getValue(), value.getType()));
        return acc;
    }
}

