/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.log4j.Logger;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.StatementOrBundle;

public class DocumentEquality {
    static Logger logger = Logger.getLogger(DocumentEquality.class);
    private boolean mergeDuplicates;
    private final PrintStream out;

    public DocumentEquality() {
        this.mergeDuplicates = false;
        this.out = null;
    }

    public DocumentEquality(boolean mergeDuplicates, PrintStream out) {
        this.mergeDuplicates = mergeDuplicates;
        this.out = out;
    }

    public void log(Object s) {
        if (this.out != null) {
            this.out.println(s);
        } else {
            logger.debug(s);
        }
    }

    private boolean collectionEqual(Collection<?> c1, Collection<?> c2) {
        HashBag bag2;
        HashBag bag1;
        if (this.mergeDuplicates) {
            bag1 = new HashSet(c1);
            bag2 = new HashSet(c2);
        } else {
            bag1 = new HashBag(c1);
            bag2 = new HashBag(c2);
        }
        return bag1.equals(bag2);
    }

    private boolean statementEqual(StatementOrBundle r1, StatementOrBundle r2) {
        Method[] allMethods;
        if (r1 instanceof Bundle && r2 instanceof Bundle) {
            Bundle b1 = (Bundle)r1;
            Bundle b2 = (Bundle)r2;
            if (!b1.getId().equals(b2.getId())) {
                return false;
            }
            List<StatementOrBundle> stmts1 = b1.getStatement();
            List<StatementOrBundle> stmts2 = b2.getStatement();
            return this.statementListEqual(stmts1, stmts2);
        }
        Class<?> class1 = r1.getClass();
        if (class1 != r2.getClass()) {
            return false;
        }
        for (Method m : allMethods = class1.getDeclaredMethods()) {
            String methodName = m.getName();
            if (!methodName.startsWith("get") || methodName.equals("getAll")) continue;
            try {
                Object attr1 = m.invoke((Object)r1, new Object[0]);
                Object attr2 = m.invoke((Object)r2, new Object[0]);
                if (attr1 == null && attr2 == null || attr1.equals(attr2) || attr1 instanceof Collection && attr1 instanceof Collection && this.collectionEqual((Collection)attr1, (Collection)attr2)) continue;
                return false;
            }
            catch (Exception e) {
                this.log(e);
                return false;
            }
        }
        return true;
    }

    private boolean statementListEqual(List<StatementOrBundle> stmts1, List<StatementOrBundle> stmts2) {
        if (stmts1.size() != stmts2.size()) {
            return false;
        }
        ArrayList<StatementOrBundle> list1 = new ArrayList<StatementOrBundle>(stmts1);
        ArrayList<StatementOrBundle> list2 = new ArrayList<StatementOrBundle>(stmts2);
        for (StatementOrBundle stmt1 : list1) {
            StatementOrBundle found = null;
            for (StatementOrBundle stmt2 : list2) {
                if (!this.statementEqual(stmt1, stmt2)) continue;
                found = stmt2;
                break;
            }
            if (found == null) {
                this.log("---------------------------");
                this.log("Cannot find the following statement in the second document");
                this.log("---------------------------");
                this.log("statement: " + stmt1);
                this.log("---------------------------");
                this.log("list of statements: ");
                this.log(stmts2);
                this.log("---------------------------");
                return false;
            }
            list2.remove(found);
        }
        return true;
    }

    public boolean check(Document d1, Document d2) {
        return this.statementListEqual(d1.getStatementOrBundle(), d2.getStatementOrBundle());
    }
}

