/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class Activity
implements org.openprovenance.prov.model.Activity,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private Optional<XMLGregorianCalendar> startTime;
    private Optional<XMLGregorianCalendar> endTime;
    private List<LangString> labels;
    private List<Location> location;
    private List<Other> other;
    private List<Type> type;
    final ProvUtilities u;

    protected Activity() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.startTime = Optional.empty();
        this.endTime = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
    }

    public Activity(QualifiedName id, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.startTime = Optional.empty();
        this.endTime = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
        this.setId(id);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.u.populateAttributes(attributes, this.labels, this.location, this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_ACTIVITY;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public XMLGregorianCalendar getStartTime() {
        return this.startTime.orElse(null);
    }

    @Override
    public void setStartTime(XMLGregorianCalendar value) {
        this.startTime = Optional.ofNullable(value);
    }

    @Override
    public XMLGregorianCalendar getEndTime() {
        return this.endTime.orElse(null);
    }

    @Override
    public void setEndTime(XMLGregorianCalendar value) {
        this.endTime = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Location> getLocation() {
        return this.location;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof Activity)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        Activity that = (Activity)object;
        equalsBuilder.append(this.getStartTime(), that.getStartTime());
        equalsBuilder.append(this.getEndTime(), that.getEndTime());
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Activity)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getStartTime());
        hashCodeBuilder.append(this.getEndTime());
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        XMLGregorianCalendar theStartTime = this.getStartTime();
        toStringBuilder.append("startTime", theStartTime);
        XMLGregorianCalendar theEndTime = this.getEndTime();
        toStringBuilder.append("endTime", theEndTime);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getLocation());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values_discard = new LinkedList<Value>();
        LinkedList<Role> roles_discard = new LinkedList<Role>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values_discard, this.getLocation(), this.getType(), roles_discard, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

