/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.AtomConstructor;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.Label;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.LiteralConstructor;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ObjectFactory;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.vanilla.HadMember;
import org.openprovenance.prov.vanilla.ModelConstructor;
import org.openprovenance.prov.vanilla.QualifiedAlternateOf;
import org.openprovenance.prov.vanilla.QualifiedHadMember;
import org.openprovenance.prov.vanilla.QualifiedSpecializationOf;

public class ProvFactory
extends org.openprovenance.prov.model.ProvFactory
implements LiteralConstructor,
org.openprovenance.prov.model.ModelConstructor,
ModelConstructorExtension,
AtomConstructor {
    static Logger logger = Logger.getLogger(ProvFactory.class);
    private static final ProvFactory oFactory = new ProvFactory();
    final org.openprovenance.prov.model.ModelConstructor mc;
    final AtomConstructor ac;

    public static ProvFactory getFactory() {
        return oFactory;
    }

    public ProvFactory(ObjectFactory of) {
        super(of);
        this.mc = new ModelConstructor();
        this.ac = (AtomConstructor)((Object)this.mc);
    }

    public ProvFactory() {
        super(null);
        this.mc = new ModelConstructor();
        this.ac = (AtomConstructor)((Object)this.mc);
    }

    public ProvFactory(ObjectFactory of, org.openprovenance.prov.model.ModelConstructor mc) {
        super(of);
        this.mc = mc;
        this.ac = (AtomConstructor)((Object)mc);
    }

    @Override
    public ProvSerialiser getSerializer() {
        return null;
    }

    @Override
    public Attribute newAttribute(QualifiedName elementName, Object value, QualifiedName type) {
        if (elementName.equals(this.getName().PROV_LOCATION)) {
            return this.newLocation(value, type);
        }
        if (elementName.equals(this.getName().PROV_TYPE)) {
            return this.newType(value, type);
        }
        if (elementName.equals(this.getName().PROV_VALUE)) {
            return this.newValue(value, type);
        }
        if (elementName.equals(this.getName().PROV_ROLE)) {
            return this.newRole(value, type);
        }
        if (elementName.equals(this.getName().PROV_LABEL)) {
            return this.newLabel(value, type);
        }
        if (elementName.equals(this.getName().PROV_KEY)) {
            new UnsupportedOperationException("key not there yet");
        }
        return this.newOther(elementName, value, type);
    }

    @Override
    public Attribute newAttribute(Attribute.AttributeKind kind, Object value, QualifiedName type) {
        switch (kind) {
            case PROV_TYPE: {
                return this.newType(value, type);
            }
            case PROV_LABEL: {
                return this.newLabel(value, type);
            }
            case PROV_ROLE: {
                return this.newRole(value, type);
            }
            case PROV_LOCATION: {
                return this.newLocation(value, type);
            }
            case PROV_VALUE: {
                return this.newValue(value, type);
            }
        }
        throw new UnsupportedOperationException("Should never be here, unknown " + kind);
    }

    @Override
    public QualifiedName newQualifiedName(String namespace, String local, String prefix) {
        return this.mc.newQualifiedName(namespace, local, prefix);
    }

    @Override
    public QualifiedName newQualifiedName(String namespace, String local, String prefix, ProvUtilities.BuildFlag flag) {
        return this.mc.newQualifiedName(namespace, local, prefix);
    }

    @Override
    public LangString newInternationalizedString(String s, String lang) {
        LangString res = this.ac.newInternationalizedString(s, lang);
        return res;
    }

    @Override
    public LangString newInternationalizedString(String s) {
        LangString res = this.ac.newInternationalizedString(s);
        return res;
    }

    @Override
    public Type newType(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newType(value, type);
    }

    @Override
    public Other newOther(QualifiedName elementName, Object value, QualifiedName type) {
        return this.ac.newOther(elementName, value, type);
    }

    @Override
    public Location newLocation(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        Location res = this.ac.newLocation(value, type);
        return res;
    }

    @Override
    public Activity newActivity(QualifiedName a) {
        Activity res = this.mc.newActivity(a, null, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public Activity newActivity(QualifiedName q, String label) {
        Attribute attr = this.newAttribute(Attribute.AttributeKind.PROV_LABEL, (Object)this.newInternationalizedString(label), this.getName().PROV_LANG_STRING);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.add(attr);
        Activity res = this.newActivity(q, null, null, attributes);
        return res;
    }

    @Override
    public Entity newEntity(QualifiedName a) {
        Entity res = this.mc.newEntity(a, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public Entity newEntity(QualifiedName id, String label) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(this.newAttribute(Attribute.AttributeKind.PROV_LABEL, (Object)this.newInternationalizedString(label), this.getName().XSD_STRING));
        Entity res = this.mc.newEntity(id, attrs);
        return res;
    }

    @Override
    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        Entity res = this.mc.newEntity(id, attributes);
        return res;
    }

    @Override
    public Document newDocument() {
        Document res = this.mc.newDocument(null, null, null);
        return res;
    }

    @Override
    public Key newKey(Object o, QualifiedName type) {
        throw new UnsupportedOperationException("newKey not supported");
    }

    @Override
    public Value newValue(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newValue(value, type);
    }

    @Override
    public Agent newAgent(QualifiedName ag) {
        Agent res = this.mc.newAgent(ag, new LinkedList<Attribute>());
        return res;
    }

    @Override
    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        Agent res = this.mc.newAgent(id, attributes);
        return res;
    }

    @Override
    public Agent newAgent(QualifiedName ag, String label) {
        Agent res = this.newAgent(ag);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id) {
        Used res = this.mc.newUsed(id, null, null, null, new LinkedList<Attribute>());
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName aid, String role, QualifiedName eid) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        Used res = this.mc.newUsed(id, aid, eid, null, attributes);
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity) {
        Used res = this.mc.newUsed(id, activity, entity, null, new LinkedList<Attribute>());
        return res;
    }

    @Override
    public Used newUsed(QualifiedName activity, QualifiedName entity) {
        Used res = this.newUsed(null, activity, entity);
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        Used res = this.mc.newUsed(id, activity, entity, time, attributes);
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time) {
        Used res = this.newUsed(id, activity, entity, time, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public Role newRole(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newRole(value, type);
    }

    @Override
    public Label newLabel(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        return this.ac.newLabel(value, type);
    }

    @Override
    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName eid, String role, QualifiedName aid) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        WasGeneratedBy res = this.mc.newWasGeneratedBy(id, eid, aid, null, attributes);
        return res;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName eid, String role, QualifiedName aid) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (role != null) {
            attributes.add(this.newRole(role, this.getName().XSD_STRING));
        }
        WasInvalidatedBy res = this.mc.newWasInvalidatedBy(id, eid, aid, null, attributes);
        return res;
    }

    @Override
    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        WasInvalidatedBy res = this.mc.newWasInvalidatedBy(id, entity, activity, null, new LinkedList<Attribute>());
        return res;
    }

    @Override
    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasInvalidatedBy res = this.mc.newWasInvalidatedBy(id, entity, activity, time, attributes);
        res.setTime(time);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName activity, QualifiedName agent) {
        WasAssociatedWith res = this.mc.newWasAssociatedWith(id, activity, agent, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        WasAssociatedWith res = this.mc.newWasAssociatedWith(id, a, ag, plan, attributes);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan) {
        WasAssociatedWith res = this.mc.newWasAssociatedWith(id, a, ag, plan, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(WasAssociatedWith u) {
        WasAssociatedWith u1 = this.newWasAssociatedWith(u.getId(), u.getActivity(), u.getAgent(), u.getPlan());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        u1.getRole().addAll(u.getRole());
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    @Override
    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent) {
        WasAttributedTo res = this.mc.newWasAttributedTo(id, entity, agent, Collections.EMPTY_LIST);
        return res;
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName entity, QualifiedName agent) {
        WasAttributedTo res = this.mc.newWasAttributedTo(null, entity, agent, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent, Collection<Attribute> attributes) {
        WasAttributedTo res = this.mc.newWasAttributedTo(id, entity, agent, attributes);
        return res;
    }

    @Override
    public SpecializationOf newSpecializationOf(QualifiedName specific, QualifiedName general) {
        SpecializationOf res = this.mc.newSpecializationOf(specific, general);
        return res;
    }

    @Override
    public AlternateOf newAlternateOf(QualifiedName entity1, QualifiedName entity2) {
        AlternateOf res = this.mc.newAlternateOf(entity1, entity2);
        return res;
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1) {
        WasDerivedFrom res = this.mc.newWasDerivedFrom(id, e2, e1, null, null, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1, QualifiedName a, QualifiedName gen, QualifiedName use, Collection<Attribute> attributes) {
        WasDerivedFrom res = this.mc.newWasDerivedFrom(id, e2, e1, a, gen, use, attributes);
        return res;
    }

    @Override
    public Document newDocument(Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        Document res = this.newDocument();
        res.getStatementOrBundle().addAll(ps);
        res.getStatementOrBundle().addAll(as);
        res.getStatementOrBundle().addAll(ags);
        res.getStatementOrBundle().addAll(lks);
        return res;
    }

    @Override
    public Document newDocument(Document graph) {
        Document res = this.newDocument();
        res.getStatementOrBundle().addAll(graph.getStatementOrBundle());
        if (graph.getNamespace() != null) {
            res.setNamespace(new Namespace(graph.getNamespace()));
        }
        return res;
    }

    @Override
    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant) {
        WasInformedBy res = this.mc.newWasInformedBy(id, informed, informant, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant, Collection<Attribute> attributes) {
        WasInformedBy res = this.mc.newWasInformedBy(id, informed, informant, attributes);
        return res;
    }

    @Override
    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer) {
        WasInfluencedBy res = this.mc.newWasInfluencedBy(id, influencee, influencer, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer, Collection<Attribute> attributes) {
        WasInfluencedBy res = this.mc.newWasInfluencedBy(id, influencee, influencer, attributes);
        return res;
    }

    @Override
    public org.openprovenance.prov.model.HadMember newHadMember(QualifiedName collection, QualifiedName ... entities) {
        HadMember res = new HadMember(collection, Arrays.asList(entities));
        return res;
    }

    @Override
    public org.openprovenance.prov.model.HadMember newHadMember(QualifiedName c, Collection<QualifiedName> e) {
        LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
        if (e != null) {
            for (QualifiedName q : e) {
                ll.add(q);
            }
        }
        HadMember res = new HadMember(c, ll);
        return res;
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName aid, QualifiedName eid) {
        WasStartedBy res = this.mc.newWasStartedBy(id, aid, eid, null, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter) {
        WasStartedBy res = this.mc.newWasStartedBy(id, activity, trigger, starter, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasStartedBy res = this.mc.newWasStartedBy(id, activity, trigger, starter, time, attributes);
        return res;
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName aid, QualifiedName eid) {
        WasEndedBy res = this.mc.newWasEndedBy(id, aid, eid, null, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender) {
        WasEndedBy res = this.mc.newWasEndedBy(id, activity, trigger, ender, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasEndedBy res = this.mc.newWasEndedBy(id, activity, trigger, ender, time, attributes);
        return res;
    }

    @Override
    public Document newDocument(Namespace namespace, Collection<Statement> statements, Collection<Bundle> bundles) {
        Document res = this.newDocument();
        res.setNamespace(namespace);
        res.getStatementOrBundle().addAll(statements);
        res.getStatementOrBundle().addAll(bundles);
        return res;
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity) {
        ActedOnBehalfOf res = this.mc.newActedOnBehalfOf(id, delegate, responsible, activity, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity, Collection<Attribute> attributes) {
        ActedOnBehalfOf res = this.mc.newActedOnBehalfOf(id, delegate, responsible, activity, attributes);
        return res;
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible) {
        ActedOnBehalfOf res = this.mc.newActedOnBehalfOf(id, delegate, responsible, null, Collections.EMPTY_LIST);
        return res;
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Collection<Statement> statements) {
        return this.newNamedBundle(id, null, statements);
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Namespace namespace, Collection<Statement> statements) {
        Bundle res = this.mc.newNamedBundle(id, namespace, statements);
        return res;
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        LinkedList<Statement> attr = new LinkedList<Statement>();
        attr.addAll(ps);
        attr.addAll(as);
        attr.addAll(ags);
        attr.addAll(lks);
        return this.newNamedBundle(id, attr);
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedHadMember newQualifiedHadMember(QualifiedName id, QualifiedName c, Collection<QualifiedName> e, Collection<Attribute> attributes) {
        QualifiedHadMember res = new QualifiedHadMember(id, c, e, attributes);
        return res;
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedSpecializationOf newQualifiedSpecializationOf(QualifiedName id, QualifiedName specific, QualifiedName general, Collection<Attribute> attributes) {
        QualifiedSpecializationOf res = new QualifiedSpecializationOf(id, specific, general, attributes);
        return res;
    }

    @Override
    public org.openprovenance.prov.model.extension.QualifiedAlternateOf newQualifiedAlternateOf(QualifiedName id, QualifiedName alt1, QualifiedName alt2, Collection<Attribute> attributes) {
        QualifiedAlternateOf res = new QualifiedAlternateOf(id, alt1, alt2, attributes);
        return res;
    }
}

