/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class WasInfluencedBy
implements org.openprovenance.prov.model.WasInfluencedBy,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private List<LangString> labels;
    private List<Other> other;
    private List<Type> type;
    protected QualifiedName influencee;
    protected QualifiedName influencer;
    final ProvUtilities u;

    private WasInfluencedBy() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
    }

    public WasInfluencedBy(QualifiedName id, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
        this.setId(id);
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    public WasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
        this.setId(id);
        this.influencee = influencee;
        this.influencer = influencer;
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public void setInfluencee(QualifiedName influencee) {
        this.influencee = influencee;
    }

    @Override
    public void setInfluencer(QualifiedName influencer) {
        this.influencer = influencer;
    }

    @Override
    public QualifiedName getInfluencer() {
        return this.influencer;
    }

    @Override
    public QualifiedName getInfluencee() {
        return this.influencee;
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_INFLUENCE;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof WasInfluencedBy)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        WasInfluencedBy that = (WasInfluencedBy)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getInfluencee(), that.getInfluencee());
        equalsBuilder.append(this.getInfluencer(), that.getInfluencer());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof WasInfluencedBy)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getInfluencee());
        hashCodeBuilder.append(this.getInfluencer());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        QualifiedName theInfluencee = this.getInfluencee();
        toStringBuilder.append("influencee", theInfluencee);
        QualifiedName theInfluencer = this.getInfluencer();
        toStringBuilder.append("influencer", theInfluencer);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        LinkedList<Location> locations = new LinkedList<Location>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, locations, this.getType(), Collections.EMPTY_LIST, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

