/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.NamespaceGatherer;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.model.exception.QualifiedNameException;

public class Namespace {
    private static ThreadLocal<Namespace> threadNamespace = new ThreadLocal<Namespace>(){

        @Override
        protected synchronized Namespace initialValue() {
            return new Namespace();
        }
    };
    protected Map<String, String> prefixes = new Hashtable<String, String>();
    protected Map<String, String> namespaces = new Hashtable<String, String>();
    private String defaultNamespace = null;
    private Namespace parent = null;
    public static final String xmlns = "pre_";
    int prefixCount = 0;
    static ProvUtilities u = new ProvUtilities();
    static QualifiedNameUtils qnU = new QualifiedNameUtils();

    public static Namespace getThreadNamespace() {
        return threadNamespace.get();
    }

    public static Namespace withThreadNamespace(Namespace ns) {
        return threadNamespace.get().set(ns);
    }

    private Namespace set(Namespace ns) {
        if (ns == null) {
            return null;
        }
        Hashtable<String, String> tmp1 = new Hashtable<String, String>();
        tmp1.putAll(ns.prefixes);
        Hashtable<String, String> tmp2 = new Hashtable<String, String>();
        tmp2.putAll(ns.namespaces);
        this.prefixes = tmp1;
        this.namespaces = tmp2;
        this.defaultNamespace = ns.defaultNamespace;
        this.parent = ns.parent;
        return this;
    }

    public void extendWith(Namespace ns) {
        if (ns == null) {
            return;
        }
        if (ns.getDefaultNamespace() != null) {
            this.registerDefault(ns.getDefaultNamespace());
        }
        for (String prefix : ns.prefixes.keySet()) {
            this.register(prefix, ns.prefixes.get(prefix));
        }
    }

    public void setParent(Namespace parent) {
        this.parent = parent;
    }

    public Namespace getParent() {
        return this.parent;
    }

    public void addKnownNamespaces() {
        this.getPrefixes().put("prov", "http://www.w3.org/ns/prov#");
        this.getNamespaces().put("http://www.w3.org/ns/prov#", "prov");
        this.getPrefixes().put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.getNamespaces().put("http://www.w3.org/2001/XMLSchema#", "xsd");
    }

    public Namespace() {
    }

    public Namespace(Hashtable<String, String> pref) {
        for (Map.Entry<String, String> entry : pref.entrySet()) {
            this.prefixes.put(entry.getKey(), entry.getValue());
            this.namespaces.put(entry.getValue(), entry.getKey());
        }
    }

    public Namespace(Namespace other) {
        this.defaultNamespace = other.defaultNamespace;
        this.prefixes = new Hashtable<String, String>();
        this.prefixes.putAll(other.prefixes);
        this.namespaces = new Hashtable<String, String>();
        this.namespaces.putAll(other.namespaces);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public boolean check(String prefix, String namespace) {
        String knownAs = this.prefixes.get(prefix);
        return namespace == knownAs;
    }

    public void registerDefault(String namespace) {
        this.register(null, namespace);
    }

    public void register(String prefix, String namespace) {
        if (prefix == null || prefix.equals("")) {
            if (this.defaultNamespace == null) {
                this.defaultNamespace = namespace;
            } else {
                this.newPrefix(namespace);
            }
        } else {
            String old = this.prefixes.get(prefix);
            if (old == null) {
                this.prefixes.put(prefix, namespace);
                if (this.namespaces.get(namespace) == null) {
                    this.namespaces.put(namespace, prefix);
                }
            } else {
                this.newPrefix(namespace);
            }
        }
    }

    public void newPrefix(String namespace) {
        boolean success = false;
        while (!success) {
            int count;
            String old = this.namespaces.get(namespace);
            if (old != null) {
                return;
            }
            ++this.prefixCount;
            String newPrefix = xmlns + count;
            String oldPrefix = this.prefixes.get(newPrefix);
            if (oldPrefix != null) continue;
            this.prefixes.put(newPrefix, namespace);
            success = true;
            if (this.namespaces.get(namespace) != null) continue;
            this.namespaces.put(namespace, newPrefix);
        }
    }

    public void unregister(String prefix, String namespace) {
        String val = this.prefixes.get(prefix);
        if (val != null && val.equals(namespace)) {
            this.prefixes.remove(prefix);
            this.namespaces.remove(namespace);
        }
    }

    public void unregisterDeafult(String namespace) {
        String val = this.getDefaultNamespace();
        if (val != null && val.equals(namespace)) {
            this.setDefaultNamespace(null);
        }
    }

    public static Namespace gatherNamespaces(Document doc) {
        NamespaceGatherer gatherer = new NamespaceGatherer();
        u.forAllStatementOrBundle(doc.getStatementOrBundle(), gatherer);
        Namespace ns = gatherer.getNamespace();
        return ns;
    }

    public static Namespace gatherNamespaces(Bundle bundle) {
        NamespaceGatherer gatherer = new NamespaceGatherer();
        u.forAllStatement(bundle.getStatement(), gatherer);
        gatherer.register(bundle.getId());
        Namespace ns = gatherer.getNamespace();
        return ns;
    }

    public static Namespace gatherNamespaces(Bundle bundle, ProvFactory pFactory) {
        NamespaceGatherer gatherer = new NamespaceGatherer();
        u.forAllStatement(bundle.getStatement(), gatherer);
        gatherer.register(bundle.getId());
        Namespace ns = gatherer.getNamespace();
        Namespace ns2 = pFactory.newNamespace(ns);
        return ns2;
    }

    public QualifiedName stringToQualifiedName(String id, ProvFactory pFactory) {
        return this.stringToQualifiedName(id, pFactory, true);
    }

    public QualifiedName stringToQualifiedName(String id, ProvFactory pFactory, boolean isEscaped) {
        if (id == null) {
            return null;
        }
        int index = id.indexOf(58);
        if (index == -1) {
            String tmp = this.getDefaultNamespace();
            if (tmp == null && this.parent != null) {
                tmp = this.parent.getDefaultNamespace();
            }
            if (tmp == null) {
                throw new NullPointerException("Namespace.stringToQualifiedName(): Null namespace for " + id);
            }
            return pFactory.newQualifiedName(tmp, id, null);
        }
        String prefix = id.substring(0, index);
        String local = id.substring(index + 1, id.length());
        if ("prov".equals(prefix)) {
            return pFactory.newQualifiedName("http://www.w3.org/ns/prov#", local, prefix);
        }
        if ("xsd".equals(prefix)) {
            return pFactory.newQualifiedName("http://www.w3.org/2001/XMLSchema#", local, prefix);
        }
        String tmp = this.prefixes.get(prefix);
        if (tmp == null) {
            if (this.parent != null) {
                return this.parent.stringToQualifiedName(id, pFactory, isEscaped);
            }
            throw new QualifiedNameException("Namespace.stringToQualifiedName(): Null namespace for " + id + " namespace " + this);
        }
        if (isEscaped) {
            return pFactory.newQualifiedName(tmp, local, prefix);
        }
        return pFactory.newQualifiedName(tmp, qnU.escapeProvLocalName(local), prefix);
    }

    public QualifiedName qualifiedName(String prefix, String local, ProvFactory pFactory) {
        if (prefix == null) {
            String tmp = this.getDefaultNamespace();
            if (tmp == null && this.parent != null) {
                tmp = this.parent.getDefaultNamespace();
            }
            if (tmp == null) {
                throw new NullPointerException("Namespace.stringToQualifiedName(: Null namespace for " + local);
            }
            return pFactory.newQualifiedName(tmp, local, null);
        }
        if ("prov".equals(prefix)) {
            return pFactory.newQualifiedName("http://www.w3.org/ns/prov#", local, prefix);
        }
        if ("xsd".equals(prefix)) {
            return pFactory.newQualifiedName("http://www.w3.org/2001/XMLSchema#", local, prefix);
        }
        String tmp = this.prefixes.get(prefix);
        if (tmp == null) {
            if (this.parent != null) {
                return this.parent.qualifiedName(prefix, local, pFactory);
            }
            throw new QualifiedNameException("Namespace.stringToQualifiedName(): Null namespace for " + prefix + ":" + local + " namespace " + this);
        }
        return pFactory.newQualifiedName(tmp, local, prefix);
    }

    public static String qualifiedNameToStringWithNamespace(QualifiedName name) {
        Namespace ns = Namespace.getThreadNamespace();
        return ns.qualifiedNameToString(name);
    }

    public String qualifiedNameToString(QName name) {
        return this.qualifiedNameToString(name, null);
    }

    public String qualifiedNameToString(QualifiedName name) {
        return this.qualifiedNameToString(name, null);
    }

    public String qualifiedNameToString(QualifiedName name, Namespace child) {
        if (this.getDefaultNamespace() != null && this.getDefaultNamespace().equals(name.getNamespaceURI())) {
            return name.getLocalPart();
        }
        String pref = this.getNamespaces().get(name.getNamespaceURI());
        if (pref != null) {
            return pref + ":" + name.getLocalPart();
        }
        if (this.parent != null) {
            return this.parent.qualifiedNameToString(name, this);
        }
        throw new QualifiedNameException("unknown qualified name " + name + " with namespace " + this.toString() + (String)(child == null ? "" : " and " + child));
    }

    public String qualifiedNameToString(QName name, Namespace child) {
        if (this.getDefaultNamespace() != null && this.getDefaultNamespace().equals(name.getNamespaceURI())) {
            return name.getLocalPart();
        }
        String pref = this.getNamespaces().get(name.getNamespaceURI());
        if (pref != null) {
            return pref + ":" + name.getLocalPart();
        }
        if (this.parent != null) {
            return this.parent.qualifiedNameToString(name, this);
        }
        throw new QualifiedNameException("unknown qualified name " + name + " with namespace " + this.toString() + (String)(child == null ? "" : " and " + child));
    }

    public String toString() {
        return "[Namespace (" + this.defaultNamespace + ") " + this.prefixes + ", parent: " + this.parent + "]";
    }
}

