/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.Location;
import org.openprovenance.prov.vanilla.Other;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.Role;
import org.openprovenance.prov.vanilla.Type;
import org.openprovenance.prov.vanilla.Value;

public class ProvUtilities
extends org.openprovenance.prov.model.ProvUtilities {
    private static final QualifiedName QualifiedName_PROV_TYPE = ProvFactory.getFactory().getName().PROV_TYPE;
    private static final QualifiedName QualifiedName_PROV_LABEL = ProvFactory.getFactory().getName().PROV_LABEL;
    private static final QualifiedName QualifiedName_PROV_VALUE = ProvFactory.getFactory().getName().PROV_VALUE;
    private static final QualifiedName QualifiedName_PROV_LOCATION = ProvFactory.getFactory().getName().PROV_LOCATION;
    private static final QualifiedName QualifiedName_PROV_ROLE = ProvFactory.getFactory().getName().PROV_ROLE;
    public static final String PROV_LABEL_URI = QualifiedName_PROV_LABEL.getUri();
    public static final String PROV_TYPE_URI = QualifiedName_PROV_TYPE.getUri();
    public static final String PROV_LOCATION_URI = QualifiedName_PROV_LOCATION.getUri();
    public static final String PROV_ROLE_URI = QualifiedName_PROV_ROLE.getUri();
    public static final String PROV_VALUE_URI = QualifiedName_PROV_VALUE.getUri();

    Map<QualifiedName, Set<Attribute>> split(Collection<Attribute> attributes) {
        LinkedList<Label> labels = new LinkedList<Label>();
        LinkedList<Type> types = new LinkedList<Type>();
        LinkedList<Value> values = new LinkedList<Value>();
        LinkedList<Location> locations = new LinkedList<Location>();
        LinkedList<Role> roles = new LinkedList<Role>();
        HashMap<QualifiedName, Collection<Other>> others = new HashMap<QualifiedName, Collection<Other>>();
        this.split(attributes, labels, types, values, locations, roles, others);
        HashMap<QualifiedName, Set<Attribute>> result = new HashMap<QualifiedName, Set<Attribute>>();
        result.put(QualifiedName_PROV_LABEL, new HashSet<Label>(labels));
        result.put(QualifiedName_PROV_TYPE, new HashSet<Type>(types));
        result.put(QualifiedName_PROV_VALUE, new HashSet<Value>(values));
        result.put(QualifiedName_PROV_LOCATION, new HashSet<Location>(locations));
        result.put(QualifiedName_PROV_ROLE, new HashSet<Role>(roles));
        for (Map.Entry entry : others.entrySet()) {
            result.put((QualifiedName)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return result;
    }

    Map<QualifiedName, Attribute[]> split2(Collection<Attribute> attributes) {
        HashMap<QualifiedName, Attribute[]> result = new HashMap<QualifiedName, Attribute[]>();
        Map<QualifiedName, Set<Attribute>> m = this.split(attributes);
        for (Map.Entry<QualifiedName, Set<Attribute>> entry : m.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toArray(new Attribute[0]));
        }
        return result;
    }

    void split(Collection<Attribute> attributes, Collection<Label> labels, Collection<Type> types, Collection<Value> values, Collection<Location> locations, Collection<Role> roles, Map<QualifiedName, Collection<Other>> others) {
        for (Attribute attribute : attributes) {
            switch (attribute.getKind()) {
                case PROV_TYPE: {
                    types.add((Type)attribute);
                    break;
                }
                case PROV_LABEL: {
                    labels.add((Label)attribute);
                    break;
                }
                case PROV_ROLE: {
                    roles.add((Role)attribute);
                    break;
                }
                case PROV_LOCATION: {
                    locations.add((Location)attribute);
                    break;
                }
                case PROV_VALUE: {
                    values.add((Value)attribute);
                    break;
                }
                case PROV_KEY: {
                    break;
                }
                case OTHER: {
                    Other other = (Other)attribute;
                    QualifiedName name = other.getElementName();
                    Collection<Other> some = others.get(name);
                    if (some == null) {
                        some = new LinkedList<Other>();
                        others.put(name, some);
                    }
                    some.add(other);
                }
            }
        }
    }

    public void distribute(QualifiedName qn, Collection<Attribute> attributes, Collection<LangString> labels, Collection<org.openprovenance.prov.model.Value> values, Collection<org.openprovenance.prov.model.Location> locations, Collection<org.openprovenance.prov.model.Type> types, Collection<org.openprovenance.prov.model.Role> roles, Collection<org.openprovenance.prov.model.Other> others) {
        String uri = qn.getUri();
        if (PROV_LABEL_URI.equals(uri)) {
            for (Attribute attr : attributes) {
                LangString ls = (LangString)attr.getValue();
                labels.add(ls);
            }
            return;
        }
        if (PROV_TYPE_URI.equals(uri)) {
            for (Attribute attr : attributes) {
                types.add((org.openprovenance.prov.model.Type)attr);
            }
            return;
        }
        if (PROV_LOCATION_URI.equals(uri)) {
            for (Attribute attr : attributes) {
                locations.add((org.openprovenance.prov.model.Location)attr);
            }
            return;
        }
        if (PROV_VALUE_URI.equals(uri)) {
            for (Attribute attr : attributes) {
                values.add((org.openprovenance.prov.model.Value)attr);
            }
            return;
        }
        if (PROV_ROLE_URI.equals(uri)) {
            for (Attribute attr : attributes) {
                roles.add((org.openprovenance.prov.model.Role)attr);
            }
            return;
        }
        for (Attribute attr : attributes) {
            others.add((org.openprovenance.prov.model.Other)attr);
        }
    }

    void populateAttributes(Collection<Attribute> attributes, List<LangString> label, List<org.openprovenance.prov.model.Location> location, List<org.openprovenance.prov.model.Type> type, List<org.openprovenance.prov.model.Role> role, List<org.openprovenance.prov.model.Other> other, org.openprovenance.prov.model.Value[] value) {
        block3: {
            LinkedList<Label> labels = new LinkedList<Label>();
            LinkedList<Type> types = new LinkedList<Type>();
            LinkedList<Location> locations = new LinkedList<Location>();
            LinkedList<Role> roles = new LinkedList<Role>();
            LinkedList<Value> values = new LinkedList<Value>();
            HashMap<QualifiedName, Collection<Other>> others = new HashMap<QualifiedName, Collection<Other>>();
            if (attributes == null) break block3;
            this.split(attributes, labels, types, values, locations, roles, others);
            location.addAll(locations);
            type.addAll(types);
            role.addAll(roles);
            for (Collection col : others.values()) {
                other.addAll(col);
            }
            Iterator<Object> iterator = labels.iterator();
            while (iterator.hasNext()) {
                Label lab = (Label)iterator.next();
                label.add((LangString)lab.value);
            }
            if (value != null && (iterator = values.iterator()).hasNext()) {
                Value val = (Value)iterator.next();
                value[0] = val;
            }
        }
    }
}

