/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class WasDerivedFrom
implements org.openprovenance.prov.model.WasDerivedFrom,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private final List<LangString> labels;
    private final List<Other> other;
    private final List<Type> type;
    protected QualifiedName generatedEntity;
    protected QualifiedName usedEntity;
    protected Optional<QualifiedName> activity;
    protected Optional<QualifiedName> generation;
    protected Optional<QualifiedName> usage;
    final ProvUtilities u;

    private WasDerivedFrom() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.activity = Optional.empty();
        this.generation = Optional.empty();
        this.usage = Optional.empty();
        this.u = new ProvUtilities();
    }

    public WasDerivedFrom(QualifiedName id, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.activity = Optional.empty();
        this.generation = Optional.empty();
        this.usage = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.u.populateAttributes(attributes, this.labels, Collections.EMPTY_LIST, this.type, Collections.EMPTY_LIST, this.other, null);
    }

    public WasDerivedFrom(QualifiedName id, QualifiedName generatedEntity, QualifiedName usedEntity, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.activity = Optional.empty();
        this.generation = Optional.empty();
        this.usage = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.usedEntity = usedEntity;
        this.generatedEntity = generatedEntity;
        this.u.populateAttributes(attributes, this.labels, Collections.EMPTY_LIST, this.type, Collections.EMPTY_LIST, this.other, null);
    }

    public WasDerivedFrom(QualifiedName id, QualifiedName generatedEntity, QualifiedName usedEntity, QualifiedName activity, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.activity = Optional.empty();
        this.generation = Optional.empty();
        this.usage = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.setActivity(activity);
        this.usedEntity = usedEntity;
        this.generatedEntity = generatedEntity;
        this.u.populateAttributes(attributes, this.labels, Collections.EMPTY_LIST, this.type, Collections.EMPTY_LIST, this.other, null);
    }

    public WasDerivedFrom(QualifiedName id, QualifiedName generatedEntity, QualifiedName usedEntity, QualifiedName activity, QualifiedName generation, QualifiedName usage, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.activity = Optional.empty();
        this.generation = Optional.empty();
        this.usage = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.setActivity(activity);
        this.usedEntity = usedEntity;
        this.generatedEntity = generatedEntity;
        this.setGeneration(generation);
        this.setUsage(usage);
        this.u.populateAttributes(attributes, this.labels, Collections.EMPTY_LIST, this.type, Collections.EMPTY_LIST, this.other, null);
    }

    @Override
    public void setActivity(QualifiedName aid) {
        this.activity = Optional.ofNullable(aid);
    }

    @Override
    public void setGeneration(QualifiedName gen) {
        this.generation = Optional.ofNullable(gen);
    }

    @Override
    public void setUsage(QualifiedName use) {
        this.usage = Optional.ofNullable(use);
    }

    @Override
    public void setUsedEntity(QualifiedName eid) {
        this.usedEntity = eid;
    }

    @Override
    public void setGeneratedEntity(QualifiedName eid) {
        this.generatedEntity = eid;
    }

    @Override
    public QualifiedName getUsedEntity() {
        return this.usedEntity;
    }

    @Override
    public QualifiedName getUsage() {
        return this.usage.orElse(null);
    }

    @Override
    public QualifiedName getGeneratedEntity() {
        return this.generatedEntity;
    }

    @Override
    public QualifiedName getGeneration() {
        return this.generation.orElse(null);
    }

    @Override
    public QualifiedName getActivity() {
        return this.activity.orElse(null);
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_DERIVATION;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof WasDerivedFrom)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        WasDerivedFrom that = (WasDerivedFrom)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getGeneratedEntity(), that.getGeneratedEntity());
        equalsBuilder.append(this.getUsedEntity(), that.getUsedEntity());
        equalsBuilder.append(this.getActivity(), that.getActivity());
        equalsBuilder.append(this.getUsage(), that.getUsage());
        equalsBuilder.append(this.getGeneration(), that.getGeneration());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof WasDerivedFrom)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getGeneratedEntity());
        hashCodeBuilder.append(this.getUsedEntity());
        hashCodeBuilder.append(this.getActivity());
        hashCodeBuilder.append(this.getGeneration());
        hashCodeBuilder.append(this.getUsage());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        QualifiedName theEntity = this.getGeneratedEntity();
        toStringBuilder.append("generatedEntity", theEntity);
        theEntity = this.getUsedEntity();
        toStringBuilder.append("usedEntity", theEntity);
        QualifiedName theActivity = this.getActivity();
        toStringBuilder.append("activity", theActivity);
        theActivity = this.getGeneration();
        toStringBuilder.append("generation", theActivity);
        theActivity = this.getUsage();
        toStringBuilder.append("usage", theActivity);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, Collections.EMPTY_LIST, this.getType(), Collections.EMPTY_LIST, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

