/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class WasStartedBy
implements org.openprovenance.prov.model.WasStartedBy,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private Optional<XMLGregorianCalendar> time;
    private List<LangString> labels;
    private List<Location> location;
    private List<Other> other;
    private List<Type> type;
    private List<Role> role;
    protected QualifiedName activity;
    protected Optional<QualifiedName> trigger;
    protected Optional<QualifiedName> starter;
    final ProvUtilities u;

    private WasStartedBy() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.time = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.role = new LinkedList<Role>();
        this.trigger = Optional.empty();
        this.starter = Optional.empty();
        this.u = new ProvUtilities();
    }

    public WasStartedBy(QualifiedName id, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.time = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.role = new LinkedList<Role>();
        this.trigger = Optional.empty();
        this.starter = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.time = Optional.empty();
        this.u.populateAttributes(attributes, this.labels, this.location, this.type, this.role, this.other, null);
    }

    public WasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.time = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.role = new LinkedList<Role>();
        this.trigger = Optional.empty();
        this.starter = Optional.empty();
        this.u = new ProvUtilities();
        this.setId(id);
        this.activity = activity;
        this.trigger = Optional.ofNullable(trigger);
        this.starter = Optional.ofNullable(starter);
        this.time = Optional.ofNullable(time);
        this.u.populateAttributes(attributes, this.labels, this.location, this.type, this.role, this.other, null);
    }

    @Override
    public void setActivity(QualifiedName aid) {
        this.activity = aid;
    }

    @Override
    public void setTrigger(QualifiedName eid) {
        this.trigger = Optional.ofNullable(eid);
    }

    @Override
    public QualifiedName getTrigger() {
        return this.trigger.orElse(null);
    }

    @Override
    public QualifiedName getActivity() {
        return this.activity;
    }

    @Override
    public void setStarter(QualifiedName aid) {
        this.starter = Optional.ofNullable(aid);
    }

    @Override
    public QualifiedName getStarter() {
        return this.starter.orElse(null);
    }

    @Override
    public List<Role> getRole() {
        return this.role;
    }

    @Override
    public XMLGregorianCalendar getTime() {
        return this.time.orElse(null);
    }

    @Override
    public void setTime(XMLGregorianCalendar time) {
        this.time = Optional.ofNullable(time);
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_START;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Location> getLocation() {
        return this.location;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof WasStartedBy)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        WasStartedBy that = (WasStartedBy)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getActivity(), that.getActivity());
        equalsBuilder.append(this.getTrigger(), that.getTrigger());
        equalsBuilder.append(this.getStarter(), that.getStarter());
        equalsBuilder.append(this.getTime(), that.getTime());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof WasStartedBy)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getActivity());
        hashCodeBuilder.append(this.getTrigger());
        hashCodeBuilder.append(this.getStarter());
        hashCodeBuilder.append(this.getTime());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        QualifiedName theActivity = this.getActivity();
        toStringBuilder.append("activity", theActivity);
        QualifiedName theTrigger = this.getTrigger();
        toStringBuilder.append("trigger", theTrigger);
        QualifiedName theStarter = this.getTrigger();
        toStringBuilder.append("starter", theStarter);
        XMLGregorianCalendar theTime = this.getTime();
        toStringBuilder.append("time", theTime);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getLocation());
        result.addAll(this.getRole());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, this.getLocation(), this.getType(), this.getRole(), this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

