/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.DocumentEquality;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.UncheckedTestException;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.ProvUtilities;

public abstract class RoundTripFromJavaTest
extends TestCase {
    public static final String EX_NS = "http://example.org/";
    public static final String EX2_NS = "http://example2.org/";
    public static final String EX_PREFIX = "ex";
    public static final String EX2_PREFIX = "ex2";
    public static final String EX3_NS = "http://example3.org/";
    static final ProvUtilities util = new ProvUtilities();
    public static ProvFactory pFactory = new org.openprovenance.prov.vanilla.ProvFactory();
    public static Name name = pFactory.getName();
    private DocumentEquality documentEquality = new DocumentEquality(this.mergeDuplicateProperties(), System.out);
    public boolean urlFlag = true;
    public boolean test = true;
    String problematic = "?a\\=b";

    public RoundTripFromJavaTest(String testName) {
        super(testName);
    }

    public void updateNamespaces(Document doc) {
        Namespace ns = Namespace.gatherNamespaces((Document)doc);
        doc.setNamespace(ns);
    }

    public String extension() {
        return ".jsonld";
    }

    public void makeDocAndTest(Statement stment, String file) {
        this.makeDocAndTest(stment, file, null, true);
    }

    public void makeDocAndTest(Statement stment, String file, boolean check) {
        this.makeDocAndTest(stment, file, null, check);
    }

    public void makeDocAndTest(Statement stment, Statement[] opt, String file) {
        this.makeDocAndTest(stment, file, opt, true);
    }

    public void makeDocAndTest(Statement[] stment, Statement[] opt, String file) {
        this.makeDocAndTest(stment, file, opt, true);
    }

    public void makeDocAndTest(Statement stment, String file, Statement[] opt, boolean check) {
        this.makeDocAndTest(new Statement[]{stment}, file, opt, check);
    }

    public void makeDocAndTest(Statement[] stment, String file, Statement[] opt, boolean check) {
        this.makeDocAndTest(stment, null, file, opt, check);
    }

    public void makeDocAndTest(Statement[] stment, Bundle[] bundles, String file, Statement[] opt, boolean check) {
        int j;
        Document doc = pFactory.newDocument();
        for (int i = 0; i < stment.length; ++i) {
            doc.getStatementOrBundle().add(stment[i]);
        }
        if (bundles != null) {
            for (j = 0; j < bundles.length; ++j) {
                doc.getStatementOrBundle().add(bundles[j]);
            }
        }
        this.updateNamespaces(doc);
        if (bundles != null) {
            for (j = 0; j < bundles.length; ++j) {
                bundles[j].getNamespace().setParent(doc.getNamespace());
            }
        }
        Object file1 = opt == null ? file : file + "-S";
        this.compareDocAndFile(doc, (String)file1, check);
        if (opt != null && this.doOptional(opt)) {
            String file2 = file + "-M";
            doc.getStatementOrBundle().addAll(Arrays.asList(opt));
            this.compareDocAndFile(doc, file2, check);
        }
    }

    public boolean doOptional(Statement[] opt) {
        return true;
    }

    public void compareDocAndFile(Document doc, String file, boolean check) {
        file = (String)file + this.extension();
        this.writeDocument(doc, (String)file);
        if (check) {
            this.conditionalCheckSchema((String)file);
        }
        Document doc3 = this.readDocument((String)file);
        this.compareDocuments(doc, doc3, check && this.checkTest((String)file));
    }

    public void conditionalCheckSchema(String file) {
        if (this.checkSchema(file)) {
            this.doCheckSchema1(file);
        }
    }

    public boolean checkSchema(String name) {
        return !name.endsWith("association2" + this.extension()) && !name.endsWith("entity101" + this.extension()) && !name.endsWith("end1" + this.extension()) && !name.endsWith("end4" + this.extension()) && !name.endsWith("delegation1" + this.extension()) && !name.endsWith("delegation2" + this.extension()) && !name.endsWith("dictionaryRemoval1-S" + this.extension()) && !name.endsWith("dictionaryRemoval1-M" + this.extension()) && !name.endsWith("dictionaryRemoval2-S" + this.extension()) && !name.endsWith("dictionaryRemoval2-M" + this.extension()) && !name.endsWith("attribution1" + this.extension()) && !name.endsWith("attribution2" + this.extension()) && !name.endsWith("mention1" + this.extension()) && !name.endsWith("derivation1" + this.extension()) && !name.endsWith("derivation2" + this.extension()) && !name.endsWith("derivation9" + this.extension()) && !name.endsWith("communication1" + this.extension()) && !name.endsWith("communication2" + this.extension()) && !name.endsWith("influence1" + this.extension()) && !name.endsWith("influence2" + this.extension()) && !name.endsWith("start1" + this.extension()) && !name.endsWith("start4" + this.extension()) && !name.endsWith("usage1" + this.extension()) && !name.endsWith("dictionaryInsertion1-S" + this.extension()) && !name.endsWith("dictionaryInsertion1-M" + this.extension()) && !name.endsWith("dictionaryInsertion2-S" + this.extension()) && !name.endsWith("dictionaryInsertion2-M" + this.extension());
    }

    public void doCheckSchema1(String file) {
    }

    public void doCheckSchema2(String file) {
        String command = "xmllint --schema src/main/resources/ex.xsd " + file;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            int code = proc.exitValue();
            if (code != 0) {
                BufferedReader outReader;
                String s_out;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String s_error = errorReader.readLine();
                if (s_error != null) {
                    System.out.println("Error:  " + s_error);
                }
                if ((s_out = (outReader = new BufferedReader(new InputStreamReader(proc.getInputStream()))).readLine()) != null) {
                    System.out.println("Out:  " + s_out);
                }
            }
            RoundTripFromJavaTest.assertTrue((code == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Document readDocument(String file1) {
        try {
            return this.readDocumentFromFile(file1);
        }
        catch (IOException e) {
            throw new UncheckedTestException(e);
        }
    }

    public void writeDocument(Document doc, String file2) {
        Namespace.withThreadNamespace((Namespace)doc.getNamespace());
        try {
            this.writeDocumentToFile(doc, file2);
        }
        catch (IOException e) {
            throw new UncheckedTestException(e);
        }
    }

    public void compareDocuments(Document doc, Document doc2, boolean check) {
        if (check) {
            boolean result = this.documentEquality.check(doc, doc2);
            if (!result) {
                System.out.println("Pre-write graph: " + doc);
                System.out.println("Read graph: " + doc2);
                System.out.println("test0: " + doc.getStatementOrBundle().get(0));
                System.out.println("test0: " + doc2.getStatementOrBundle().get(0));
                System.out.println("test1: " + ((StatementOrBundle)doc.getStatementOrBundle().get(0)).getClass());
                System.out.println("test1: " + ((StatementOrBundle)doc2.getStatementOrBundle().get(0)).getClass());
                System.out.println("test: " + ((StatementOrBundle)doc.getStatementOrBundle().get(0)).equals(doc2.getStatementOrBundle().get(0)));
                if (doc.getStatementOrBundle().get(0) instanceof HasAttributes && doc2.getStatementOrBundle().get(0) instanceof HasAttributes) {
                    System.out.println("test2  (attr): " + this.compareSet(((HasAttributes)doc.getStatementOrBundle().get(0)).getAttributes(), ((HasAttributes)doc2.getStatementOrBundle().get(0)).getAttributes()));
                }
                if (doc.getStatementOrBundle().get(0) instanceof Identifiable && doc2.getStatementOrBundle().get(0) instanceof Identifiable) {
                    System.out.println("test3  (I): " + this.compare(((Identifiable)doc.getStatementOrBundle().get(0)).getId(), ((Identifiable)doc2.getStatementOrBundle().get(0)).getId()));
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasLabel && doc2.getStatementOrBundle().get(0) instanceof HasLabel) {
                    System.out.println("test4  (L): " + ((HasLabel)doc.getStatementOrBundle().get(0)).getLabel().equals(((HasLabel)doc2.getStatementOrBundle().get(0)).getLabel()));
                    System.out.println("test4  (L): " + this.compareSet(((HasLabel)doc.getStatementOrBundle().get(0)).getLabel(), ((HasLabel)doc2.getStatementOrBundle().get(0)).getLabel()));
                    System.out.println("test4a (L): " + ((HasLabel)doc.getStatementOrBundle().get(0)).getLabel());
                    System.out.println("test4b (L): " + ((HasLabel)doc2.getStatementOrBundle().get(0)).getLabel());
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasType && doc2.getStatementOrBundle().get(0) instanceof HasType) {
                    System.out.println("test5  (T): " + ((HasType)doc.getStatementOrBundle().get(0)).getType().equals(((HasType)doc2.getStatementOrBundle().get(0)).getType()));
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasOther && doc2.getStatementOrBundle().get(0) instanceof HasOther) {
                    System.out.println("test6  (O): " + ((HasOther)doc2.getStatementOrBundle().get(0)).getOther().equals(((HasOther)doc2.getStatementOrBundle().get(0)).getOther()));
                    System.out.println("test6b (O): " + ((HasOther)doc.getStatementOrBundle().get(0)).getOther());
                    System.out.println("test6c (O): " + ((HasOther)doc2.getStatementOrBundle().get(0)).getOther());
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasRole && doc2.getStatementOrBundle().get(0) instanceof HasRole) {
                    System.out.println("test7  (R): " + this.compareSet(((HasRole)doc.getStatementOrBundle().get(0)).getRole(), ((HasRole)doc2.getStatementOrBundle().get(0)).getRole()));
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasLocation && doc2.getStatementOrBundle().get(0) instanceof HasLocation) {
                    System.out.println("test8  (Loc): " + this.compareSet(((HasLocation)doc.getStatementOrBundle().get(0)).getLocation(), ((HasLocation)doc2.getStatementOrBundle().get(0)).getLocation()));
                    System.out.println("test8a (Loc): " + ((HasLocation)doc.getStatementOrBundle().get(0)).getLocation());
                    System.out.println("test8b (Loc): " + ((HasLocation)doc2.getStatementOrBundle().get(0)).getLocation());
                }
                if (doc.getStatementOrBundle().get(0) instanceof HasValue && doc2.getStatementOrBundle().get(0) instanceof HasValue) {
                    System.out.println("test9  (V): " + this.compare(((HasValue)doc.getStatementOrBundle().get(0)).getValue(), ((HasValue)doc2.getStatementOrBundle().get(0)).getValue()));
                    System.out.println("test9a (V): " + ((HasValue)doc.getStatementOrBundle().get(0)).getValue());
                    System.out.println("test9b (V): " + ((HasValue)doc2.getStatementOrBundle().get(0)).getValue());
                }
            }
            RoundTripFromJavaTest.assertTrue((String)"doc equals doc2", (boolean)result);
        } else {
            RoundTripFromJavaTest.assertFalse((String)"doc distinct from doc2", (boolean)doc.equals(doc2));
        }
    }

    private <E> boolean compare(E value1, E value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public <E> boolean compareSet(List<E> a1, List<E> a2) {
        HashSet<E> set1 = new HashSet<E>(a1);
        HashSet<E> set2 = new HashSet<E>(a2);
        return set1.equals(set2);
    }

    public <E> boolean compareSet(Collection<E> a1, Collection<E> a2) {
        HashSet<E> set1 = new HashSet<E>(a1);
        HashSet<E> set2 = new HashSet<E>(a2);
        return set1.equals(set2);
    }

    public boolean checkTest(String name) {
        return true;
    }

    public boolean mergeDuplicateProperties() {
        return false;
    }

    public Document readDocumentFromFile(String file) throws IOException {
        System.out.println("reading from " + file);
        return null;
    }

    public void writeDocumentToFile(Document doc, String file) throws IOException {
        System.out.println("writing to " + file);
    }

    public QualifiedName q(String n) {
        return pFactory.newQualifiedName(EX_NS, n, EX_PREFIX);
    }

    public void addLabel(HasLabel hl) {
        hl.getLabel().add(pFactory.newInternationalizedString("hello"));
    }

    public void addLabels(HasLabel hl) {
        hl.getLabel().add(pFactory.newInternationalizedString("hello"));
        hl.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        hl.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
    }

    public void addTypes(HasType ht) {
        ht.getType().add(pFactory.newType((Object)"a", RoundTripFromJavaTest.name.XSD_STRING));
        ht.getType().add(pFactory.newType((Object)1, RoundTripFromJavaTest.name.XSD_INT));
        ht.getType().add(pFactory.newType((Object)1.0, RoundTripFromJavaTest.name.XSD_FLOAT));
        ht.getType().add(pFactory.newType((Object)true, RoundTripFromJavaTest.name.XSD_BOOLEAN));
        ht.getType().add(pFactory.newType((Object)pFactory.newQualifiedName(EX_NS, "abc", EX_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        ht.getType().add(pFactory.newType((Object)pFactory.newTimeNow(), RoundTripFromJavaTest.name.XSD_DATETIME));
        ht.getType().add(pFactory.newType((Object)"http://example.org/hello", RoundTripFromJavaTest.name.XSD_ANY_URI));
    }

    public void addLocations(HasLocation hl) {
        hl.getLocation().add(pFactory.newLocation((Object)"London", RoundTripFromJavaTest.name.XSD_STRING));
        hl.getLocation().add(pFactory.newLocation((Object)1, RoundTripFromJavaTest.name.XSD_INT));
        hl.getLocation().add(pFactory.newLocation((Object)1.0, RoundTripFromJavaTest.name.XSD_FLOAT));
        hl.getLocation().add(pFactory.newLocation((Object)true, RoundTripFromJavaTest.name.XSD_BOOLEAN));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newQualifiedName(EX_NS, "london", EX_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newTimeNow(), RoundTripFromJavaTest.name.XSD_DATETIME));
        hl.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        hl.getLocation().add(pFactory.newLocation((Object)pFactory.newGYear(2002), RoundTripFromJavaTest.name.XSD_GYEAR));
    }

    public void addValue(HasValue hl) {
        hl.setValue(pFactory.newValue((Object)pFactory.newQualifiedName(EX_NS, "avalue", EX_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
    }

    public void addFurtherAttributes(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"hello", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"bonjour", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)pFactory.newGYear(2002), RoundTripFromJavaTest.name.XSD_GYEAR));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)"bye", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX2_NS, "tag3", EX2_PREFIX, (Object)"hi", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"hello\nover\nmore\nlines", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, this.get0tagWithDigit(), EX_PREFIX, (Object)"hello", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, this.get0tagWithDigit(), EX_PREFIX, (Object)"hello2", RoundTripFromJavaTest.name.XSD_STRING));
    }

    public String get0tagWithDigit() {
        return "0tagWithDigit";
    }

    public void addFurtherAttributes0(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag1", EX_PREFIX, (Object)"hello", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)"bye", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag2", EX_PREFIX, (Object)pFactory.newInternationalizedString("bonjour", "fr"), RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX2_NS, "tag3", EX2_PREFIX, (Object)"hi", RoundTripFromJavaTest.name.XSD_STRING));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Integer(1), RoundTripFromJavaTest.name.XSD_INT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Long(1L), RoundTripFromJavaTest.name.XSD_LONG));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Short(1), RoundTripFromJavaTest.name.XSD_SHORT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Double(1.0), RoundTripFromJavaTest.name.XSD_DOUBLE));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Float(1.0), RoundTripFromJavaTest.name.XSD_FLOAT));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new BigDecimal(1.0), RoundTripFromJavaTest.name.XSD_INTEGER));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Boolean(true), RoundTripFromJavaTest.name.XSD_BOOLEAN));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)new Byte(123), RoundTripFromJavaTest.name.XSD_BYTE));
        this.addFurtherAttributesWithQNames(he);
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
    }

    public void addFurtherAttributesWithQNames(HasOther he) {
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "newyork", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName(EX_NS, "london", EX_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        he.getOther().add(pFactory.newOther(EX_NS, "tag", EX_PREFIX, (Object)pFactory.newQualifiedName(EX3_NS, "london", null), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
    }

    public void NOtestRoles() {
        Role r1 = pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING);
        Role r2 = pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING);
        Location l1 = pFactory.newLocation((Object)"otherLocation", RoundTripFromJavaTest.name.XSD_STRING);
        Location l2 = pFactory.newLocation((Object)"otherLocation", RoundTripFromJavaTest.name.XSD_STRING);
        System.out.println("---------------------------------------------------------------------- ");
        System.out.println("Role 1 " + r1);
        System.out.println("Role 2 " + r2);
        System.out.println("Location 1 " + l1);
        System.out.println("Location 2 " + l2);
        System.out.println("---------------------------------------------------------------------- ");
        System.out.println(r1);
        System.out.println(r2);
        System.out.println(r1.equals(r1));
        System.out.println(r1.equals(r2));
        System.out.println(r2.equals(r1));
        System.out.println(r2.equals(r2));
        System.out.println(l1.equals(l1));
        System.out.println(l1.equals(l2));
        System.out.println(l2.equals(l1));
        System.out.println(l2.equals(l2));
        System.out.println("---------------------------------------------------------------------- ");
    }

    public void testEntity0() {
        Entity a = pFactory.newEntity(this.q("e0"));
        a.getOther().add(pFactory.newOther(pFactory.newQualifiedName(EX_NS, "tag2", EX_PREFIX), (Object)pFactory.newInternationalizedString("bonjour", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        if (this.test) {
            a.getLocation().add(pFactory.newLocation((Object)"un llieu", RoundTripFromJavaTest.name.XSD_STRING));
            a.getLocation().add(pFactory.newLocation((Object)1, RoundTripFromJavaTest.name.XSD_INT));
            a.getLocation().add(pFactory.newLocation((Object)2.0, RoundTripFromJavaTest.name.XSD_DOUBLE));
            a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
            Location loc = pFactory.newLocation((Object)new Long(2L), RoundTripFromJavaTest.name.XSD_LONG);
            a.getLocation().add(loc);
        }
        this.makeDocAndTest((Statement)a, "target/entity0");
    }

    public void testEntity1() {
        Entity a = pFactory.newEntity(this.q("e1"));
        this.makeDocAndTest((Statement)a, "target/entity1");
    }

    public void testEntity2() {
        Entity a = pFactory.newEntity(this.q("e2"), "entity2");
        this.makeDocAndTest((Statement)a, "target/entity2");
    }

    public void testEntity3() {
        Entity a = pFactory.newEntity(this.q("e3"), "entity3");
        this.addValue((HasValue)a);
        this.makeDocAndTest((Statement)a, "target/entity3");
    }

    public void testEntity4() {
        Entity a = pFactory.newEntity(this.q("e4"), "entity4");
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity4");
    }

    public void testEntity5() {
        Entity a = pFactory.newEntity(this.q("e5"), "entity5");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/entity5");
    }

    public void testEntity6() {
        Entity a = pFactory.newEntity(this.q("e6"), "entity6");
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/entity6");
    }

    public void testEntity7() {
        Entity a = pFactory.newEntity(this.q("e7"), "entity7");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity7");
    }

    public void testEntity8() {
        Entity a = pFactory.newEntity(this.q("e8"), "entity8");
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/entity8");
    }

    public void testEntity9() {
        Entity a = pFactory.newEntity(this.q("e9"), "entity9");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/entity9");
    }

    public void testEntity10() {
        Entity a = pFactory.newEntity(this.q("e10"), "entity10");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/entity10");
    }

    public void NOtestEntity100() {
        Entity e = pFactory.newEntity(this.q("100-generalEntity"), "entity100");
        e.getOther().add(pFactory.newOther(EX_NS, "a01b\\[c", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "a01bc", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "unicode", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "unicode", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, this.problematic, EX_PREFIX, (Object)1, RoundTripFromJavaTest.name.XSD_INT));
        e.getOther().add(pFactory.newOther(EX_NS, "123", EX_PREFIX, (Object)"mystring", RoundTripFromJavaTest.name.XSD_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "123", EX_PREFIX, (Object)pFactory.newInternationalizedString("ma chaine", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        this.makeDocAndTest((Statement)e, "target/entity100");
    }

    public void NOtestEntity101() {
        Entity e = pFactory.newEntity(this.q("101-generalEntity"), "entity101");
        e.getOther().add(pFactory.newOther(EX_NS, "a01b\\[c", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "a01bc", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\\=\\'\\(\\)\\,-\\:\\;\\[\\]\\.", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "unicode", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370\u037d", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, "\u00c0-\u00d6\u00d8-\u00f6\u00f8-", EX_PREFIX, (Object)pFactory.newQualifiedName(EX2_NS, "unicode", EX2_PREFIX), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
        e.getOther().add(pFactory.newOther(EX_NS, this.problematic, EX_PREFIX, (Object)1, RoundTripFromJavaTest.name.XSD_INT));
        e.getOther().add(pFactory.newOther(EX_NS, "123", EX_PREFIX, (Object)"mystring", RoundTripFromJavaTest.name.XSD_STRING));
        e.getOther().add(pFactory.newOther(EX_NS, "123", EX_PREFIX, (Object)pFactory.newInternationalizedString("ma chaine", "fr"), RoundTripFromJavaTest.name.PROV_LANG_STRING));
        this.makeDocAndTest((Statement)e, "target/entity101");
    }

    public void testDocument1() {
        Activity a = pFactory.newActivity(this.q("a1"));
        this.makeDocAndTest(new Statement[0], null, "target/document1");
    }

    public void testActivity1() {
        Activity a = pFactory.newActivity(this.q("a1"));
        this.makeDocAndTest((Statement)a, "target/activity1");
    }

    public void testActivity2() {
        Activity a = pFactory.newActivity(this.q("a2"), "activity2");
        this.makeDocAndTest((Statement)a, "target/activity2");
    }

    public void testActivity3() {
        Activity a = pFactory.newActivity(this.q("a1"));
        a.setStartTime(pFactory.newTimeNow());
        a.setEndTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)a, "target/activity3");
    }

    public void testActivity4() {
        Activity a = pFactory.newActivity(this.q("a2"), "activity2");
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity4");
    }

    public void testActivity5() {
        Activity a = pFactory.newActivity(this.q("a5"), "activity5");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/activity5");
    }

    public void testActivity6() {
        Activity a = pFactory.newActivity(this.q("a6"), "activity6");
        this.addLocations((HasLocation)a);
        this.makeDocAndTest((Statement)a, "target/activity6");
    }

    public void testActivity7() {
        Activity a = pFactory.newActivity(this.q("a7"), "activity7");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity7");
    }

    public void testActivity8() {
        Activity a = pFactory.newActivity(this.q("a8"), "activity8");
        a.setStartTime(pFactory.newTimeNow());
        a.setEndTime(pFactory.newTimeNow());
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addLabels((HasLabel)a);
        this.makeDocAndTest((Statement)a, "target/activity8");
    }

    public void testActivity9() {
        Activity a = pFactory.newActivity(this.q("a9"), "activity9");
        this.addTypes((HasType)a);
        this.addLocations((HasLocation)a);
        this.addLabels((HasLabel)a);
        this.addFurtherAttributes((HasOther)a);
        this.makeDocAndTest((Statement)a, "target/activity9");
    }

    public void testAgent1() {
        Agent a = pFactory.newAgent(this.q("ag1"));
        this.makeDocAndTest((Statement)a, "target/agent1");
    }

    public void testAgent2() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        this.makeDocAndTest((Statement)a, "target/agent2");
    }

    public void testAgent3() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        this.makeDocAndTest((Statement)a, "target/agent3");
    }

    public void testAgent4() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        this.makeDocAndTest((Statement)a, "target/agent4");
    }

    public void testAgent5() {
        Agent a = pFactory.newAgent(this.q("ag2"), "agent2");
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        a.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
        this.makeDocAndTest((Statement)a, "target/agent5");
    }

    public void testAgent6() {
        Agent a = pFactory.newAgent(this.q("ag6"), "agent6");
        this.addTypes((HasType)a);
        this.makeDocAndTest((Statement)a, "target/agent6");
    }

    public void testAgent7() {
        Agent a = pFactory.newAgent(this.q("ag7"), "agent7");
        this.addTypes((HasType)a);
        a.getLabel().add(pFactory.newInternationalizedString("hello"));
        a.getLabel().add(pFactory.newInternationalizedString("bye", "en"));
        a.getLabel().add(pFactory.newInternationalizedString("bonjour", "fr"));
        a.getLocation().add(pFactory.newLocation((Object)"London", RoundTripFromJavaTest.name.XSD_STRING));
        a.getLocation().add(pFactory.newLocation((Object)1, RoundTripFromJavaTest.name.XSD_INT));
        a.getLocation().add(pFactory.newLocation((Object)1.0, RoundTripFromJavaTest.name.XSD_FLOAT));
        a.getLocation().add(pFactory.newLocation((Object)true, RoundTripFromJavaTest.name.XSD_BOOLEAN));
        a.getLocation().add(pFactory.newLocation((Object)pFactory.newTimeNow(), RoundTripFromJavaTest.name.XSD_DATETIME));
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        this.makeDocAndTest((Statement)a, "target/agent7");
    }

    public void testAgent8() {
        Agent a = pFactory.newAgent(this.q("ag8"), "agent8");
        this.addTypes((HasType)a);
        this.addTypes((HasType)a);
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        a.getLocation().add(pFactory.newLocation((Object)"http://example.org/london", RoundTripFromJavaTest.name.XSD_ANY_URI));
        this.makeDocAndTest((Statement)a, "target/agent8");
    }

    public void testGeneration1() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen1"), this.q("e1"), null, null);
        this.makeDocAndTest((Statement)gen, "target/generation1");
    }

    public void testGeneration2() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen2"), this.q("e1"), null, this.q("a1"));
        this.makeDocAndTest((Statement)gen, "target/generation2");
    }

    public void testGeneration3() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen3"), this.q("e1"), "somerole", this.q("a1"));
        gen.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)gen, "target/generation3");
    }

    public void testGeneration4() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen4"), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)gen, "target/generation4");
    }

    public void testGeneration5() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy(this.q("gen4"), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)gen);
        this.addLocations((HasLocation)gen);
        this.addLabels((HasLabel)gen);
        this.addFurtherAttributes((HasOther)gen);
        this.makeDocAndTest((Statement)gen, "target/generation5");
    }

    public void testGeneration6() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), null, this.q("a1"));
        this.makeDocAndTest((Statement)gen, "target/generation6");
    }

    public void testGeneration7() {
        WasGeneratedBy gen = pFactory.newWasGeneratedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), "somerole", this.q("a1"));
        gen.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)gen);
        this.addLocations((HasLocation)gen);
        this.addLabels((HasLabel)gen);
        this.addFurtherAttributes((HasOther)gen);
        this.makeDocAndTest((Statement)gen, "target/generation7");
    }

    public void testUsage1() {
        Used use = pFactory.newUsed(this.q("use1"), null, null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage1");
    }

    public void testUsage2() {
        Used use = pFactory.newUsed(this.q("use2"), this.q("a1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage2");
    }

    public void testUsage3() {
        Used use = pFactory.newUsed(this.q("use3"), this.q("a1"), "somerole", this.q("e1"));
        use.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)use, "target/usage3");
    }

    public void testUsage4() {
        Used use = pFactory.newUsed(this.q("use4"), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)use, "target/usage4");
    }

    public void testUsage5() {
        Used use = pFactory.newUsed(this.q("use5"), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)use);
        this.addLocations((HasLocation)use);
        this.addLabels((HasLabel)use);
        this.addFurtherAttributes((HasOther)use);
        this.makeDocAndTest((Statement)use, "target/usage5");
    }

    public void testUsage6() {
        Used use = pFactory.newUsed((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)use, "target/usage6");
    }

    public void testUsage7() {
        Used use = pFactory.newUsed((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), "somerole", this.q("e1"));
        use.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)use);
        this.addLocations((HasLocation)use);
        this.addLabels((HasLabel)use);
        this.addFurtherAttributes((HasOther)use);
        this.makeDocAndTest((Statement)use, "target/usage7");
    }

    public void testInvalidation1() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv1"), this.q("e1"), null);
        this.makeDocAndTest((Statement)inv, "target/invalidation1");
    }

    public void testInvalidation2() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv2"), this.q("e1"), this.q("a1"));
        this.makeDocAndTest((Statement)inv, "target/invalidation2");
    }

    public void testInvalidation3() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv3"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)inv, "target/invalidation3");
    }

    public void testInvalidation4() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv4"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)inv, "target/invalidation4");
    }

    public void testInvalidation5() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy(this.q("inv4"), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)inv);
        this.addLocations((HasLocation)inv);
        this.addLabels((HasLabel)inv);
        this.addFurtherAttributes((HasOther)inv);
        this.makeDocAndTest((Statement)inv, "target/invalidation5");
    }

    public void testInvalidation6() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("a1"));
        this.makeDocAndTest((Statement)inv, "target/invalidation6");
    }

    public void testInvalidation7() {
        WasInvalidatedBy inv = pFactory.newWasInvalidatedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("a1"));
        inv.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        inv.setTime(pFactory.newTimeNow());
        this.addTypes((HasType)inv);
        this.addLocations((HasLocation)inv);
        this.addLabels((HasLabel)inv);
        this.addFurtherAttributes((HasOther)inv);
        this.makeDocAndTest((Statement)inv, "target/invalidation7");
    }

    public void testStart1() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start1");
    }

    public void testStart2() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start2"), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start2");
    }

    public void testStart3() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start3"), this.q("a1"), null);
        this.makeDocAndTest((Statement)start, "target/start3");
    }

    public void testStart4() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start4"), null, this.q("e1"));
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start4");
    }

    public void testStart5() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start5"), this.q("a1"), this.q("e1"));
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start5");
    }

    public void testStart6() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start6"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        this.makeDocAndTest((Statement)start, "target/start6");
    }

    public void testStart7() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start7"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)start, "target/start7");
    }

    public void testStart8() {
        WasStartedBy start = pFactory.newWasStartedBy(this.q("start8"), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        start.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        start.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)start);
        this.addLocations((HasLocation)start);
        this.addLabels((HasLabel)start);
        this.addFurtherAttributes((HasOther)start);
        this.makeDocAndTest((Statement)start, "target/start8");
    }

    public void testStart9() {
        WasStartedBy start = pFactory.newWasStartedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)start, "target/start9");
    }

    public void testStart10() {
        WasStartedBy start = pFactory.newWasStartedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null);
        start.setStarter(this.q("a2"));
        start.setTime(pFactory.newTimeNow());
        start.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        start.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)start);
        this.addLocations((HasLocation)start);
        this.addLabels((HasLabel)start);
        this.addFurtherAttributes((HasOther)start);
        this.makeDocAndTest((Statement)start, "target/start10");
    }

    public void testEnd1() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end1");
    }

    public void testEnd2() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end2"), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end2");
    }

    public void testEnd3() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end3"), this.q("a1"), null);
        this.makeDocAndTest((Statement)end, "target/end3");
    }

    public void testEnd4() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end4"), null, this.q("e1"));
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end4");
    }

    public void testEnd5() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end5"), this.q("a1"), this.q("e1"));
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end5");
    }

    public void testEnd6() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end6"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        this.makeDocAndTest((Statement)end, "target/end6");
    }

    public void testEnd7() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end7"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        this.makeDocAndTest((Statement)end, "target/end7");
    }

    public void testEnd8() {
        WasEndedBy end = pFactory.newWasEndedBy(this.q("end8"), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        end.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        end.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)end);
        this.addLocations((HasLocation)end);
        this.addLabels((HasLabel)end);
        this.addFurtherAttributes((HasOther)end);
        this.makeDocAndTest((Statement)end, "target/end8");
    }

    public void testEnd9() {
        WasEndedBy end = pFactory.newWasEndedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("e1"));
        this.makeDocAndTest((Statement)end, "target/end9");
    }

    public void testEnd10() {
        WasEndedBy end = pFactory.newWasEndedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), null);
        end.setEnder(this.q("a2"));
        end.setTime(pFactory.newTimeNow());
        end.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        end.getRole().add(pFactory.newRole((Object)"otherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.addTypes((HasType)end);
        this.addLocations((HasLocation)end);
        this.addLabels((HasLabel)end);
        this.addFurtherAttributes((HasOther)end);
        this.makeDocAndTest((Statement)end, "target/end10");
    }

    public void testDerivation1() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der1"), null, this.q("e1"));
        this.makeDocAndTest((Statement)der, "target/derivation1");
    }

    public void testDerivation2() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der2"), this.q("e2"), null);
        this.makeDocAndTest((Statement)der, "target/derivation2");
    }

    public void testDerivation3() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der3"), this.q("e2"), this.q("e1"));
        this.makeDocAndTest((Statement)der, "target/derivation3");
    }

    public void testDerivation4() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der4"), this.q("e2"), this.q("e1"));
        this.addLabel((HasLabel)der);
        this.makeDocAndTest((Statement)der, "target/derivation4");
    }

    public void testDerivation5() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der5"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        this.makeDocAndTest((Statement)der, "target/derivation5");
    }

    public void testDerivation6() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der6"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        this.makeDocAndTest((Statement)der, "target/derivation6");
    }

    public void testDerivation7() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der7"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        this.makeDocAndTest((Statement)der, "target/derivation7");
    }

    public void testDerivation8() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("der8"), this.q("e2"), this.q("e1"));
        this.addLabel((HasLabel)der);
        this.addTypes((HasType)der);
        this.addFurtherAttributes((HasOther)der);
        this.makeDocAndTest((Statement)der, "target/derivation8");
    }

    public void testDerivation9() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e2"), null);
        this.addTypes((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation9");
    }

    public void testDerivation10() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        this.makeDocAndTest((Statement)der, "target/derivation10");
    }

    public void testDerivation11() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("rev1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addRevisionType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation11");
    }

    public void testDerivation12() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("quo1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addQuotationType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation12");
    }

    public void testDerivation13() {
        WasDerivedFrom der = pFactory.newWasDerivedFrom(this.q("prim1"), this.q("e2"), this.q("e1"));
        der.setActivity(this.q("a"));
        der.setUsage(this.q("u"));
        der.setGeneration(this.q("g"));
        pFactory.addPrimarySourceType((HasType)der);
        this.makeDocAndTest((Statement)der, "target/derivation13");
    }

    public void testAssociation1() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc1"), this.q("a1"), null);
        this.makeDocAndTest((Statement)assoc, "target/association1");
    }

    public void testAssociation2() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc2"), null, this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association2");
    }

    public void testAssociation3() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc3"), this.q("a1"), this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association3");
    }

    public void testAssociation4() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc4"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.makeDocAndTest((Statement)assoc, "target/association4");
    }

    public void testAssociation5() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a1"), this.q("ag1"));
        this.makeDocAndTest((Statement)assoc, "target/association5");
    }

    public void testAssociation6() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc6"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association6");
    }

    public void testAssociation7() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc7"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.addTypes((HasType)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association7");
    }

    public void testAssociation8() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc8"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        assoc.getRole().add(pFactory.newRole((Object)"someRole", RoundTripFromJavaTest.name.XSD_STRING));
        assoc.getRole().add(pFactory.newRole((Object)"someOtherRole", RoundTripFromJavaTest.name.XSD_STRING));
        this.makeDocAndTest((Statement)assoc, "target/association8");
    }

    public void testAssociation9() {
        WasAssociatedWith assoc = pFactory.newWasAssociatedWith(this.q("assoc9"), this.q("a1"), this.q("ag1"));
        assoc.setPlan(this.q("plan1"));
        this.addLabels((HasLabel)assoc);
        this.addTypes((HasType)assoc);
        this.addFurtherAttributes((HasOther)assoc);
        this.makeDocAndTest((Statement)assoc, "target/association9");
    }

    public void testAttribution1() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr1"), this.q("e1"), null);
        this.makeDocAndTest((Statement)attr, "target/attribution1");
    }

    public void testAttribution2() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr2"), null, this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution2");
    }

    public void testAttribution3() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr3"), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution3");
    }

    public void testAttribution4() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr4"), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution4");
    }

    public void testAttribution5() {
        WasAttributedTo attr = pFactory.newWasAttributedTo((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("e1"), this.q("ag1"));
        this.makeDocAndTest((Statement)attr, "target/attribution5");
    }

    public void testAttribution6() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr6"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution6");
    }

    public void testAttribution7() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr7"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.addTypes((HasType)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution7");
    }

    public void testAttribution8() {
        WasAttributedTo attr = pFactory.newWasAttributedTo(this.q("attr8"), this.q("e1"), this.q("ag1"));
        this.addLabels((HasLabel)attr);
        this.addTypes((HasType)attr);
        this.addFurtherAttributes((HasOther)attr);
        this.makeDocAndTest((Statement)attr, "target/attribution8");
    }

    public void testDelegation1() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del1"), this.q("e1"), null, null);
        this.makeDocAndTest((Statement)del, "target/delegation1");
    }

    public void testDelegation2() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del2"), null, this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation2");
    }

    public void testDelegation3() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del3"), this.q("e1"), this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation3");
    }

    public void testDelegation4() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del4"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.makeDocAndTest((Statement)del, "target/delegation4");
    }

    public void testDelegation5() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf((QualifiedName)null, this.q("e1"), this.q("ag1"), null);
        this.makeDocAndTest((Statement)del, "target/delegation5");
    }

    public void testDelegation6() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del6"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.makeDocAndTest((Statement)del, "target/delegation6");
    }

    public void testDelegation7() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del7"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.addTypes((HasType)del);
        this.makeDocAndTest((Statement)del, "target/delegation7");
    }

    public void testDelegation8() {
        ActedOnBehalfOf del = pFactory.newActedOnBehalfOf(this.q("del8"), this.q("e1"), this.q("ag1"), this.q("a"));
        this.addLabels((HasLabel)del);
        this.addTypes((HasType)del);
        this.addFurtherAttributes((HasOther)del);
        this.makeDocAndTest((Statement)del, "target/delegation8");
    }

    public void testCommunication1() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf1"), this.q("a2"), null);
        this.makeDocAndTest((Statement)inf, "target/communication1");
    }

    public void testCommunication2() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf2"), null, this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication2");
    }

    public void testCommunication3() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf3"), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication3");
    }

    public void testCommunication4() {
        WasInformedBy inf = pFactory.newWasInformedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/communication4");
    }

    public void testCommunication5() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf5"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.makeDocAndTest((Statement)inf, "target/communication5");
    }

    public void testCommunication6() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf6"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.makeDocAndTest((Statement)inf, "target/communication6");
    }

    public void testCommunication7() {
        WasInformedBy inf = pFactory.newWasInformedBy(this.q("inf7"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.addFurtherAttributes((HasOther)inf);
        this.makeDocAndTest((Statement)inf, "target/communication7");
    }

    public void testInfluence1() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf1"), this.q("a2"), null);
        this.makeDocAndTest((Statement)inf, "target/influence1");
    }

    public void testInfluence2() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf2"), null, this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence2");
    }

    public void testInfluence3() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf3"), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence3");
    }

    public void testInfluence4() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy((QualifiedName)((org.openprovenance.prov.vanilla.QualifiedName)null), this.q("a2"), this.q("a1"));
        this.makeDocAndTest((Statement)inf, "target/influence4");
    }

    public void testInfluence5() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf5"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.makeDocAndTest((Statement)inf, "target/influence5");
    }

    public void testInfluence6() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf6"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.makeDocAndTest((Statement)inf, "target/influence6");
    }

    public void testInfluence7() {
        WasInfluencedBy inf = pFactory.newWasInfluencedBy(this.q("inf7"), this.q("a2"), this.q("a1"));
        this.addLabels((HasLabel)inf);
        this.addTypes((HasType)inf);
        this.addFurtherAttributes((HasOther)inf);
        this.makeDocAndTest((Statement)inf, "target/influence7");
    }

    public void testAlternate1() {
        AlternateOf alt = pFactory.newAlternateOf(this.q("e1"), this.q("e2"));
        this.makeDocAndTest((Statement)alt, "target/alternate1");
    }

    public void testSpecialization1() {
        SpecializationOf spe = pFactory.newSpecializationOf(this.q("e2"), this.q("e1"));
        this.makeDocAndTest((Statement)spe, "target/specialization1");
    }

    public void testMembership1() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1")});
        this.makeDocAndTest((Statement)mem, "target/member1");
    }

    public void testMembership2() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1"), this.q("e2")});
        this.makeDocAndTest((Statement)mem, "target/member2");
    }

    public void testMembership3() {
        HadMember mem = pFactory.newHadMember(this.q("c"), new QualifiedName[]{this.q("e1"), this.q("e2"), this.q("e3")});
        this.makeDocAndTest((Statement)mem, "target/member3");
    }

    public void testBundle1() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("aa1"), null, this.q("ee1"));
        Entity ee1 = pFactory.newEntity(this.q("ee1"));
        Activity aa1 = pFactory.newActivity(this.q("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        b1.setNamespace(Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory));
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        b2.setNamespace(Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory));
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle1", null, true);
    }

    public void testBundle2() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        b1.setNamespace(Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory));
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("e1"), null, this.q("a1"));
        Entity ee1 = pFactory.newEntity(this.q("a1"));
        Activity aa1 = pFactory.newActivity(this.q("e1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        b2.setNamespace(Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory));
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle2", null, true);
    }

    public void testBundle3() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        Used use2 = pFactory.newUsed(this.q("use2"), this.q("aa1"), null, this.q("ee1"));
        Entity ee1 = pFactory.newEntity(this.q("ee1"));
        Activity aa1 = pFactory.newActivity(this.q("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Namespace ns1 = Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory);
        b1.setNamespace(ns1);
        Bundle b2 = pFactory.newNamedBundle(this.q("bundle2"), st2);
        Entity eb1 = pFactory.newEntity(this.q("bundle1"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.q("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        Namespace ns2 = Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory);
        b2.setNamespace(ns2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle3", null, true);
    }

    public QualifiedName another(String n) {
        return pFactory.newQualifiedName("http://another.org/", n, EX_PREFIX);
    }

    public void testBundle4() {
        Used use1 = pFactory.newUsed(this.q("use1"), this.q("a1"), null, this.q("e1"));
        Entity e1 = pFactory.newEntity(this.q("e1"));
        Activity a1 = pFactory.newActivity(this.q("a1"));
        LinkedList<Object> st1 = new LinkedList<Object>();
        st1.add(a1);
        st1.add(e1);
        st1.add(use1);
        Bundle b1 = pFactory.newNamedBundle(this.q("bundle1"), st1);
        Namespace ns1 = Namespace.gatherNamespaces((Bundle)b1, (ProvFactory)pFactory);
        b1.setNamespace(ns1);
        Used use2 = pFactory.newUsed(this.another("use2"), this.another("aa1"), null, this.another("ee1"));
        Entity ee1 = pFactory.newEntity(this.another("ee1"));
        Activity aa1 = pFactory.newActivity(this.another("aa1"));
        LinkedList<Object> st2 = new LinkedList<Object>();
        st2.add(aa1);
        st2.add(ee1);
        st2.add(use2);
        Bundle b2 = pFactory.newNamedBundle(this.another("bundle2"), st2);
        Namespace ns2 = Namespace.gatherNamespaces((Bundle)b2, (ProvFactory)pFactory);
        b2.setNamespace(ns2);
        Entity eb1 = pFactory.newEntity(pFactory.newQualifiedName(EX_NS, "bundle1", "foo"));
        pFactory.addBundleType((HasType)eb1);
        Entity eb2 = pFactory.newEntity(this.another("bundle2"));
        pFactory.addBundleType((HasType)eb2);
        Statement[] statements = new Statement[]{eb1, eb2};
        Bundle[] bundles = new Bundle[]{b1, b2};
        this.makeDocAndTest(statements, bundles, "target/bundle4", null, true);
    }

    public void testQualifiedSpecializationOf1() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(this.q("spec1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization1");
    }

    public void testQualifiedSpecializationOf2() {
        QualifiedSpecializationOf gen = pFactory.newQualifiedSpecializationOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-specialization2");
    }

    public void testQualifiedAlternateOf1() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(this.q("alt1"), this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate1");
    }

    public void testQualifiedAlternateOf2() {
        QualifiedAlternateOf gen = pFactory.newQualifiedAlternateOf(null, this.q("e1"), this.q("e2"), null);
        this.makeDocAndTest((Statement)gen, "target/qualified-alternate2");
    }

    public void testQualifiedHadMember1() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(this.q("mem"), this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member1");
    }

    public void testQualifiedHadMember2() {
        LinkedList<QualifiedName> entities = new LinkedList<QualifiedName>();
        entities.add(this.q("e2"));
        QualifiedHadMember gen = pFactory.newQualifiedHadMember(null, this.q("e1"), entities, null);
        this.makeDocAndTest((Statement)gen, "target/qualified-member2");
    }
}

