/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.ActedOnBehalfOf;
import org.openprovenance.prov.vanilla.AlternateOf;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class QualifiedAlternateOf
implements org.openprovenance.prov.model.extension.QualifiedAlternateOf,
Equals,
HashCode,
ToString,
HasAttributes {
    private Optional<QualifiedName> id = Optional.empty();
    private List<LangString> labels = new LinkedList<LangString>();
    private List<Other> other = new LinkedList<Other>();
    private List<Type> type = new LinkedList<Type>();
    protected QualifiedName alternate1;
    protected QualifiedName alternate2;
    final ProvUtilities u = new ProvUtilities();

    @Override
    public boolean isUnqualified() {
        return this.id.isEmpty() && this.other.isEmpty() && this.labels.isEmpty() && this.type.isEmpty();
    }

    private QualifiedAlternateOf() {
    }

    public QualifiedAlternateOf(QualifiedName id, Collection<Attribute> attributes) {
        this.setId(id);
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    public QualifiedAlternateOf(QualifiedName id, QualifiedName alternate1, QualifiedName alternate2, Collection<Attribute> attributes) {
        this.setId(id);
        this.alternate1 = alternate1;
        this.alternate2 = alternate2;
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public void setAlternate1(QualifiedName informed) {
        this.alternate1 = informed;
    }

    @Override
    public void setAlternate2(QualifiedName alternate2) {
        this.alternate2 = alternate2;
    }

    @Override
    public QualifiedName getAlternate2() {
        return this.alternate2;
    }

    @Override
    public QualifiedName getAlternate1() {
        return this.alternate1;
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_ALTERNATE;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof QualifiedAlternateOf)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        QualifiedAlternateOf that = (QualifiedAlternateOf)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getAlternate1(), that.getAlternate1());
        equalsBuilder.append(this.getAlternate2(), that.getAlternate2());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public void equals2(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof QualifiedAlternateOf)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        QualifiedAlternateOf that = (QualifiedAlternateOf)object;
        equalsBuilder.append(this.getAlternate1(), that.getAlternate1());
        equalsBuilder.append(this.getAlternate2(), that.getAlternate2());
    }

    public boolean equals(Object object) {
        if (!(object instanceof QualifiedAlternateOf)) {
            if (object instanceof AlternateOf) {
                if (this.isUnqualified()) {
                    AlternateOf alt = (AlternateOf)object;
                    EqualsBuilder equalsBuilder2 = new EqualsBuilder();
                    this.equals2(object, equalsBuilder2);
                    return equalsBuilder2.isEquals();
                }
                return false;
            }
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        boolean unqualified = this.isUnqualified();
        if (!unqualified) {
            hashCodeBuilder.append(this.getId());
        }
        hashCodeBuilder.append(this.getAlternate1());
        hashCodeBuilder.append(this.getAlternate2());
        if (!unqualified) {
            hashCodeBuilder.append(this.getIndexedAttributes());
        }
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        QualifiedName theInformed = this.getAlternate1();
        toStringBuilder.append("alternate1", theInformed);
        QualifiedName theInformant = this.getAlternate2();
        toStringBuilder.append("alternate2", theInformant);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(ActedOnBehalfOf.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        LinkedList<Location> locations = new LinkedList<Location>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, locations, this.getType(), Collections.EMPTY_LIST, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

