/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;
import org.openprovenance.prov.vanilla.SpecializationOf;

public class QualifiedSpecializationOf
implements org.openprovenance.prov.model.extension.QualifiedSpecializationOf,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private List<LangString> labels;
    private List<Other> other;
    private List<Type> type;
    protected QualifiedName specific;
    protected QualifiedName generalEntity;
    final ProvUtilities u;

    @Override
    public boolean isUnqualified() {
        return this.id.isEmpty() && this.other.isEmpty() && this.labels.isEmpty() && this.type.isEmpty();
    }

    private QualifiedSpecializationOf() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
    }

    public QualifiedSpecializationOf(QualifiedName id, QualifiedName specificEntity, QualifiedName generalEntity, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.id = Optional.empty();
        this.labels = new LinkedList<LangString>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.u = new ProvUtilities();
        this.setId(id);
        this.specific = specificEntity;
        this.generalEntity = generalEntity;
        this.u.populateAttributes(attributes, this.labels, new LinkedList<Location>(), this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public void setSpecificEntity(QualifiedName specific) {
        this.specific = specific;
    }

    @Override
    public void setGeneralEntity(QualifiedName informant) {
        this.generalEntity = informant;
    }

    @Override
    public QualifiedName getGeneralEntity() {
        return this.generalEntity;
    }

    @Override
    public QualifiedName getSpecificEntity() {
        return this.specific;
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_SPECIALIZATION;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof QualifiedSpecializationOf)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        QualifiedSpecializationOf that = (QualifiedSpecializationOf)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getSpecificEntity(), that.getSpecificEntity());
        equalsBuilder.append(this.getGeneralEntity(), that.getGeneralEntity());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public void equals2(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof SpecializationOf)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        SpecializationOf that = (SpecializationOf)object;
        equalsBuilder.append(this.getSpecificEntity(), that.getSpecificEntity());
        equalsBuilder.append(this.getGeneralEntity(), that.getGeneralEntity());
    }

    public boolean equals(Object object) {
        if (!(object instanceof QualifiedSpecializationOf)) {
            if (object instanceof SpecializationOf) {
                if (this.isUnqualified()) {
                    SpecializationOf qspec = (SpecializationOf)object;
                    EqualsBuilder equalsBuilder2 = new EqualsBuilder();
                    this.equals2(object, equalsBuilder2);
                    return equalsBuilder2.isEquals();
                }
                return false;
            }
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        boolean unqualified = this.isUnqualified();
        if (!unqualified) {
            hashCodeBuilder.append(this.getId());
        }
        hashCodeBuilder.append(this.getSpecificEntity());
        hashCodeBuilder.append(this.getGeneralEntity());
        if (!unqualified) {
            hashCodeBuilder.append(this.getIndexedAttributes());
        }
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        QualifiedName theSpecificEntity = this.getSpecificEntity();
        toStringBuilder.append("specificEntity", theSpecificEntity);
        QualifiedName theGeneralEntity = this.getGeneralEntity();
        toStringBuilder.append("generalEntity", theGeneralEntity);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        LinkedList<Location> locations = new LinkedList<Location>();
        this.u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, locations, this.getType(), Collections.EMPTY_LIST, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return this.u.split(this.getAttributes());
    }
}

