/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Entry;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasLabel;
import org.openprovenance.prov.model.HasLocation;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasRole;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.HasValue;
import org.openprovenance.prov.model.Key;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.LiteralConstructor;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ModelConstructorExtension;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ObjectFactory;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementActionValue;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;

public abstract class ProvFactory
implements LiteralConstructor,
ModelConstructor,
ModelConstructorExtension {
    public static final String packageList = "org.openprovenance.prov.xml:org.openprovenance.prov.xml.validation";
    private static String fileName = "toolbox.properties";
    private static final String toolboxVersion = ProvFactory.getPropertiesFromClasspath(fileName).getProperty("toolbox.version");
    protected DatatypeFactory dataFactory;
    protected final ObjectFactory of;
    private Name name = null;
    ProvUtilities util = new ProvUtilities();

    private static Properties getPropertiesFromClasspath(String propFileName) {
        Properties props = new Properties();
        InputStream inputStream = ProvFactory.class.getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
        }
        catch (IOException ee) {
            return null;
        }
        return props;
    }

    public static String printURI(URI u) {
        return u.toString();
    }

    public ProvFactory(ObjectFactory of) {
        this.of = of;
        this.init();
    }

    public void addAttribute(HasOther a, Other o) {
        a.getOther().add(o);
    }

    public ActedOnBehalfOf addAttributes(ActedOnBehalfOf from, ActedOnBehalfOf to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Activity addAttributes(Activity from, Activity to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Agent addAttributes(Agent from, Agent to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Entity addAttributes(Entity from, Entity to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public Used addAttributes(Used from, Used to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasAssociatedWith addAttributes(WasAssociatedWith from, WasAssociatedWith to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasAttributedTo addAttributes(WasAttributedTo from, WasAttributedTo to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasDerivedFrom addAttributes(WasDerivedFrom from, WasDerivedFrom to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasEndedBy addAttributes(WasEndedBy from, WasEndedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasGeneratedBy addAttributes(WasGeneratedBy from, WasGeneratedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInfluencedBy addAttributes(WasInfluencedBy from, WasInfluencedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInformedBy addAttributes(WasInformedBy from, WasInformedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasInvalidatedBy addAttributes(WasInvalidatedBy from, WasInvalidatedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public WasStartedBy addAttributes(WasStartedBy from, WasStartedBy to) {
        to.getLabel().addAll(from.getLabel());
        to.getType().addAll(from.getType());
        to.getLocation().addAll(from.getLocation());
        to.getRole().addAll(from.getRole());
        to.getOther().addAll(from.getOther());
        return to;
    }

    public void addLabel(HasLabel a, String label) {
        a.getLabel().add(this.newInternationalizedString(label));
    }

    public void addLabel(HasLabel a, String label, String language) {
        a.getLabel().add(this.newInternationalizedString(label, language));
    }

    public void addPrimarySourceType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_PRIMARY_SOURCE, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addQuotationType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_QUOTATION, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addRevisionType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_REVISION, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addBundleType(HasType a) {
        a.getType().add(this.newType(this.getName().PROV_BUNDLE, this.getName().PROV_QUALIFIED_NAME));
    }

    public void addRole(HasRole a, Role role) {
        if (role != null) {
            a.getRole().add(role);
        }
    }

    public void addType(HasType a, Object o, QualifiedName type) {
        a.getType().add(this.newType(o, type));
    }

    public void addType(HasType a, Type type) {
        a.getType().add(type);
    }

    public void addType(HasType a, QualifiedName type) {
        a.getType().add(this.newType(type, this.getName().PROV_QUALIFIED_NAME));
    }

    @Override
    public byte[] base64Decoding(String s) {
        return Base64.getDecoder().decode(s);
    }

    public String base64Encoding(byte[] b) {
        return Base64.getEncoder().encodeToString(b);
    }

    public String getLabel(HasLabel e) {
        List<LangString> labels = e.getLabel();
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        if (e instanceof HasLabel) {
            return labels.get(0).getValue();
        }
        return "pFact: label TODO";
    }

    public Name getName() {
        if (this.name == null) {
            this.name = new Name(this);
        }
        return this.name;
    }

    public ObjectFactory getObjectFactory() {
        return this.of;
    }

    public String getPackageList() {
        return packageList;
    }

    public abstract ProvSerialiser getSerializer();

    public String getRole(HasOther e) {
        return "pFact: role TODO";
    }

    public List<Type> getType(HasOther e) {
        if (e instanceof HasType) {
            return ((HasType)((Object)e)).getType();
        }
        LinkedList<Type> res = new LinkedList<Type>();
        res.add(this.newType("pFact: type TODO", this.getName().XSD_STRING));
        return res;
    }

    public String getVersion() {
        return toolboxVersion;
    }

    public byte[] hexDecoding(String s) {
        byte[] byteArray = new BigInteger(s, 16).toByteArray();
        if (byteArray[0] == 0) {
            byte[] output = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, output, 0, output.length);
            return output;
        }
        return byteArray;
    }

    public String hexEncoding(byte[] b) {
        BigInteger bigInteger = new BigInteger(1, b);
        return bigInteger.toString(16);
    }

    protected void init() {
        try {
            this.dataFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ActedOnBehalfOf newActedOnBehalfOf(ActedOnBehalfOf u) {
        ActedOnBehalfOf u1 = this.newActedOnBehalfOf(u.getId(), u.getDelegate(), u.getResponsible(), u.getActivity(), null);
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity) {
        ActedOnBehalfOf res = this.of.createActedOnBehalfOf();
        res.setId(id);
        res.setActivity(activity);
        res.setDelegate(delegate);
        res.setResponsible(responsible);
        return res;
    }

    @Override
    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible, QualifiedName activity, Collection<Attribute> attributes) {
        ActedOnBehalfOf res = this.of.createActedOnBehalfOf();
        res.setId(id);
        res.setActivity(activity);
        res.setDelegate(delegate);
        res.setResponsible(responsible);
        this.setAttributes(res, attributes);
        return res;
    }

    public ActedOnBehalfOf newActedOnBehalfOf(QualifiedName id, QualifiedName delegate, QualifiedName responsible) {
        ActedOnBehalfOf res = this.newActedOnBehalfOf(id, delegate, responsible, null, null);
        return res;
    }

    public Activity newActivity(Activity a) {
        Activity res = this.newActivity(a.getId());
        res.getType().addAll(a.getType());
        res.getLabel().addAll(a.getLabel());
        res.getLocation().addAll(a.getLocation());
        res.setStartTime(a.getStartTime());
        res.setEndTime(a.getEndTime());
        return res;
    }

    public Activity newActivity(QualifiedName a) {
        Activity res = this.of.createActivity();
        res.setId(a);
        return res;
    }

    public Activity newActivity(QualifiedName q, String label) {
        Activity res = this.newActivity(q);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    @Override
    public Activity newActivity(QualifiedName id, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, Collection<Attribute> attributes) {
        Activity res = this.newActivity(id);
        res.setStartTime(startTime);
        res.setEndTime(endTime);
        this.setAttributes(res, attributes);
        return res;
    }

    public Agent newAgent(Agent a) {
        Agent res = this.newAgent(a.getId());
        res.getType().addAll(a.getType());
        res.getLabel().addAll(a.getLabel());
        return res;
    }

    public Agent newAgent(QualifiedName ag) {
        Agent res = this.of.createAgent();
        res.setId(ag);
        return res;
    }

    @Override
    public Agent newAgent(QualifiedName id, Collection<Attribute> attributes) {
        Agent res = this.newAgent(id);
        this.setAttributes(res, attributes);
        return res;
    }

    public Agent newAgent(QualifiedName ag, String label) {
        Agent res = this.newAgent(ag);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    @Override
    public AlternateOf newAlternateOf(QualifiedName entity1, QualifiedName entity2) {
        AlternateOf res = this.of.createAlternateOf();
        res.setAlternate1(entity1);
        res.setAlternate2(entity2);
        return res;
    }

    public abstract Attribute newAttribute(QualifiedName var1, Object var2, QualifiedName var3);

    public abstract Attribute newAttribute(Attribute.AttributeKind var1, Object var2, QualifiedName var3);

    public Attribute newAttribute(String namespace, String localName, String prefix, Object value, QualifiedName type) {
        Attribute res = this.newAttribute(this.newQualifiedName(namespace, localName, prefix), value, type);
        return res;
    }

    @Override
    public DerivedByInsertionFrom newDerivedByInsertionFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Entry> keyEntitySet, Collection<Attribute> attributes) {
        DerivedByInsertionFrom res = this.of.createDerivedByInsertionFrom();
        res.setId(id);
        res.setNewDictionary(after);
        res.setOldDictionary(before);
        if (keyEntitySet != null) {
            res.getKeyEntityPair().addAll(keyEntitySet);
        }
        this.setAttributes(res, attributes);
        return res;
    }

    @Override
    public DerivedByRemovalFrom newDerivedByRemovalFrom(QualifiedName id, QualifiedName after, QualifiedName before, List<Key> keys, Collection<Attribute> attributes) {
        DerivedByRemovalFrom res = this.of.createDerivedByRemovalFrom();
        res.setId(id);
        res.setNewDictionary(after);
        res.setOldDictionary(before);
        if (keys != null) {
            res.getKey().addAll(keys);
        }
        this.setAttributes(res, attributes);
        return res;
    }

    @Override
    public DictionaryMembership newDictionaryMembership(QualifiedName dict, List<Entry> entitySet) {
        DictionaryMembership res = this.of.createDictionaryMembership();
        res.setDictionary(dict);
        if (entitySet != null) {
            res.getKeyEntityPair().addAll(entitySet);
        }
        return res;
    }

    public Document newDocument() {
        Document res = this.of.createDocument();
        return res;
    }

    public Document newDocument(Activity[] ps, Entity[] as, Agent[] ags, Statement[] lks) {
        return this.newDocument(ps == null ? null : Arrays.asList(ps), as == null ? null : Arrays.asList(as), ags == null ? null : Arrays.asList(ags), lks == null ? null : Arrays.asList(lks));
    }

    public Document newDocument(Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        Document res = this.of.createDocument();
        res.getStatementOrBundle().addAll(ps);
        res.getStatementOrBundle().addAll(as);
        res.getStatementOrBundle().addAll(ags);
        res.getStatementOrBundle().addAll(lks);
        return res;
    }

    public Document newDocument(Document graph) {
        Document res = this.of.createDocument();
        res.getStatementOrBundle().addAll(graph.getStatementOrBundle());
        if (graph.getNamespace() != null) {
            res.setNamespace(new Namespace(graph.getNamespace()));
        }
        return res;
    }

    @Override
    public Document newDocument(Namespace namespace, Collection<Statement> statements, Collection<Bundle> bundles) {
        Document res = this.of.createDocument();
        res.setNamespace(namespace);
        res.getStatementOrBundle().addAll(statements);
        res.getStatementOrBundle().addAll(bundles);
        return res;
    }

    public Duration newDuration(int durationInMilliSeconds) {
        Duration dur = this.dataFactory.newDuration(durationInMilliSeconds);
        return dur;
    }

    @Override
    public Duration newDuration(String lexicalRepresentation) {
        Duration dur = this.dataFactory.newDuration(lexicalRepresentation);
        return dur;
    }

    public Entity newEntity(Entity e) {
        Entity res = this.newEntity(e.getId());
        res.getOther().addAll(e.getOther());
        res.getType().addAll(e.getType());
        res.getLabel().addAll(e.getLabel());
        res.getLocation().addAll(e.getLocation());
        return res;
    }

    public Entity newEntity(QualifiedName id) {
        Entity res = this.of.createEntity();
        res.setId(id);
        return res;
    }

    @Override
    public Entity newEntity(QualifiedName id, Collection<Attribute> attributes) {
        Entity res = this.newEntity(id);
        this.setAttributes(res, attributes);
        return res;
    }

    public Entity newEntity(QualifiedName id, String label) {
        Entity res = this.newEntity(id);
        if (label != null) {
            res.getLabel().add(this.newInternationalizedString(label));
        }
        return res;
    }

    public Entry newEntry(Key key, QualifiedName entity) {
        Entry res = this.of.createEntry();
        res.setKey(key);
        res.setEntity(entity);
        return res;
    }

    @Override
    public XMLGregorianCalendar newGDay(int day) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setDay(day);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGMonth(int month) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setMonth(month);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGMonthDay(int month, int day) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setMonth(month);
        cal.setDay(day);
        return cal;
    }

    @Override
    public XMLGregorianCalendar newGYear(int year) {
        XMLGregorianCalendar cal = this.dataFactory.newXMLGregorianCalendar();
        cal.setYear(year);
        return cal;
    }

    public HadMember newHadMember(QualifiedName collection, QualifiedName ... entities) {
        HadMember res = this.of.createHadMember();
        res.setCollection(collection);
        if (entities != null) {
            res.getEntity().addAll(Arrays.asList(entities));
        }
        return res;
    }

    @Override
    public HadMember newHadMember(QualifiedName c, Collection<QualifiedName> e) {
        LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
        if (e != null) {
            for (QualifiedName q : e) {
                ll.add(q);
            }
        }
        HadMember res = this.of.createHadMember();
        res.setCollection(c);
        res.getEntity().addAll(ll);
        return res;
    }

    public LangString newInternationalizedString(String s) {
        LangString res = this.of.createInternationalizedString();
        res.setValue(s);
        return res;
    }

    public LangString newInternationalizedString(String s, String lang) {
        LangString res = this.of.createInternationalizedString();
        res.setValue(s);
        res.setLang(lang);
        return res;
    }

    @Override
    public XMLGregorianCalendar newISOTime(String time) {
        return this.newTime(DatatypeConverter.parseDateTime((String)time).getTime());
    }

    public abstract Key newKey(Object var1, QualifiedName var2);

    public Location newLocation(Object value, QualifiedName type) {
        Location res = this.of.createLocation();
        res.setType(type);
        res.setValueFromObject(value);
        return res;
    }

    @Override
    public MentionOf newMentionOf(QualifiedName infra, QualifiedName supra, QualifiedName bundle) {
        MentionOf res = this.of.createMentionOf();
        res.setSpecificEntity(infra);
        res.setBundle(bundle);
        res.setGeneralEntity(supra);
        return res;
    }

    public MentionOf newMentionOf(MentionOf r) {
        MentionOf res = this.of.createMentionOf();
        res.setSpecificEntity(r.getSpecificEntity());
        res.setBundle(r.getBundle());
        res.setGeneralEntity(r.getGeneralEntity());
        return res;
    }

    public Bundle newNamedBundle(QualifiedName id, Collection<Activity> ps, Collection<Entity> as, Collection<Agent> ags, Collection<Statement> lks) {
        Bundle res = this.of.createNamedBundle();
        res.setId(id);
        if (ps != null) {
            res.getStatement().addAll(ps);
        }
        if (as != null) {
            res.getStatement().addAll(as);
        }
        if (ags != null) {
            res.getStatement().addAll(ags);
        }
        if (lks != null) {
            res.getStatement().addAll(lks);
        }
        return res;
    }

    public Bundle newNamedBundle(QualifiedName id, Collection<Statement> lks) {
        Bundle res = this.of.createNamedBundle();
        res.setId(id);
        if (lks != null) {
            res.getStatement().addAll(lks);
        }
        return res;
    }

    @Override
    public Bundle newNamedBundle(QualifiedName id, Namespace namespace, Collection<Statement> statements) {
        Bundle res = this.of.createNamedBundle();
        res.setId(id);
        res.setNamespace(namespace);
        if (statements != null) {
            res.getStatement().addAll(statements);
        }
        return res;
    }

    public Other newOther(QualifiedName elementName, Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        Other res = this.of.createOther();
        res.setType(type);
        res.setValueFromObject(value);
        res.setElementName(elementName);
        return res;
    }

    public Other newOther(String namespace, String local, String prefix, Object value, QualifiedName type) {
        QualifiedName elementName = this.newQualifiedName(namespace, local, prefix);
        return this.newOther(elementName, value, type);
    }

    @Override
    public abstract QualifiedName newQualifiedName(String var1, String var2, String var3);

    @Override
    public abstract QualifiedName newQualifiedName(String var1, String var2, String var3, ProvUtilities.BuildFlag var4);

    public QualifiedName newQualifiedName(QName qname) {
        return this.newQualifiedName(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
    }

    public Role newRole(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        Role res = this.of.createRole();
        res.setType(type);
        res.setValueFromObject(value);
        return res;
    }

    @Override
    public SpecializationOf newSpecializationOf(QualifiedName specific, QualifiedName general) {
        SpecializationOf res = this.of.createSpecializationOf();
        res.setSpecificEntity(specific);
        res.setGeneralEntity(general);
        return res;
    }

    @Override
    public QualifiedSpecializationOf newQualifiedSpecializationOf(QualifiedName id, QualifiedName specific, QualifiedName general, Collection<Attribute> attributes) {
        QualifiedSpecializationOf res = this.of.createQualifiedSpecializationOf();
        res.setId(id);
        res.setSpecificEntity(specific);
        res.setGeneralEntity(general);
        this.setAttributes(res, attributes);
        return res;
    }

    @Override
    public QualifiedAlternateOf newQualifiedAlternateOf(QualifiedName id, QualifiedName alt1, QualifiedName alt2, Collection<Attribute> attributes) {
        QualifiedAlternateOf res = this.of.createQualifiedAlternateOf();
        res.setId(id);
        res.setAlternate1(alt1);
        res.setAlternate2(alt2);
        this.setAttributes(res, attributes);
        return res;
    }

    @Override
    public QualifiedHadMember newQualifiedHadMember(QualifiedName id, QualifiedName c, Collection<QualifiedName> e, Collection<Attribute> attributes) {
        LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
        if (e != null) {
            for (QualifiedName q : e) {
                ll.add(q);
            }
        }
        QualifiedHadMember res = this.of.createQualifiedHadMember();
        res.setId(id);
        res.setCollection(c);
        if (e != null) {
            res.getEntity().addAll(e);
        }
        return res;
    }

    public XMLGregorianCalendar newTime(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return this.newXMLGregorianCalendar(gc);
    }

    @Override
    public XMLGregorianCalendar newTimeNow() {
        return this.newTime(new Date());
    }

    public Type newType(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        Type res = this.of.createType();
        res.setType(type);
        res.setValueFromObject(value);
        return res;
    }

    public Used newUsed(QualifiedName id) {
        Used res = this.of.createUsed();
        res.setId(id);
        return res;
    }

    public Used newUsed(QualifiedName id, QualifiedName aid, String role, QualifiedName eid) {
        Used res = this.newUsed(id);
        res.setActivity(aid);
        if (role != null) {
            this.addRole(res, this.newRole(role, this.getName().XSD_STRING));
        }
        res.setEntity(eid);
        return res;
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity) {
        Used res = this.newUsed(id);
        res.setActivity(activity);
        res.setEntity(entity);
        return res;
    }

    public Used newUsed(QualifiedName activity, QualifiedName entity) {
        Used res = this.newUsed((QualifiedName)null);
        res.setActivity(activity);
        res.setEntity(entity);
        return res;
    }

    @Override
    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        Used res = this.newUsed(id, activity, null, entity);
        res.setTime(time);
        this.setAttributes(res, attributes);
        return res;
    }

    public Used newUsed(QualifiedName id, QualifiedName activity, QualifiedName entity, XMLGregorianCalendar time) {
        Used res = this.newUsed(id, activity, null, entity);
        res.setTime(time);
        return res;
    }

    public Used newUsed(Used u) {
        Used u1 = this.newUsed(u.getId(), u.getActivity(), u.getEntity());
        u1.setTime(u.getTime());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        u1.getRole().addAll(u.getRole());
        u1.getLocation().addAll(u.getLocation());
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    public Value newValue(String value) {
        return this.newValue(value, this.getName().XSD_STRING);
    }

    public Value newValue(int value) {
        return this.newValue(value, this.getName().XSD_INT);
    }

    public Value newValue(Object value, QualifiedName type) {
        if (value == null) {
            return null;
        }
        Value res = this.of.createValue();
        res.setType(type);
        res.setValueFromObject(value);
        return res;
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id) {
        return this.newWasAssociatedWith(id, null, null);
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName activity, QualifiedName agent) {
        WasAssociatedWith res = this.of.createWasAssociatedWith();
        res.setId(id);
        res.setActivity(activity);
        res.setAgent(agent);
        return res;
    }

    @Override
    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan, Collection<Attribute> attributes) {
        WasAssociatedWith res = this.newWasAssociatedWith(id, a, ag);
        res.setPlan(plan);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasAssociatedWith newWasAssociatedWith(QualifiedName id, QualifiedName a, QualifiedName ag, QualifiedName plan) {
        WasAssociatedWith res = this.newWasAssociatedWith(id, a, ag);
        res.setPlan(plan);
        return res;
    }

    public WasAssociatedWith newWasAssociatedWith(WasAssociatedWith u) {
        WasAssociatedWith u1 = this.newWasAssociatedWith(u.getId(), u.getActivity(), u.getAgent());
        u1.getOther().addAll(u.getOther());
        u1.setPlan(u.getPlan());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        u1.getRole().addAll(u.getRole());
        return u1;
    }

    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent) {
        WasAttributedTo res = this.of.createWasAttributedTo();
        res.setId(id);
        res.setEntity(entity);
        res.setAgent(agent);
        return res;
    }

    @Override
    public WasAttributedTo newWasAttributedTo(QualifiedName id, QualifiedName entity, QualifiedName agent, Collection<Attribute> attributes) {
        WasAttributedTo res = this.of.createWasAttributedTo();
        res.setId(id);
        res.setEntity(entity);
        res.setAgent(agent);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasAttributedTo newWasAttributedTo(WasAttributedTo u) {
        WasAttributedTo u1 = this.newWasAttributedTo(u.getId(), u.getEntity(), u.getAgent());
        u1.getOther().addAll(u.getOther());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        return u1;
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName e2, QualifiedName e1) {
        WasDerivedFrom res = this.of.createWasDerivedFrom();
        res.setId(id);
        res.setUsedEntity(e1);
        res.setGeneratedEntity(e2);
        return res;
    }

    public WasDerivedFrom newWasDerivedFrom(QualifiedName e2, QualifiedName e1) {
        WasDerivedFrom res = this.of.createWasDerivedFrom();
        res.setUsedEntity(e1);
        res.setGeneratedEntity(e2);
        return res;
    }

    @Override
    public WasDerivedFrom newWasDerivedFrom(QualifiedName id, QualifiedName aid1, QualifiedName aid2, QualifiedName aid, QualifiedName did1, QualifiedName did2, Collection<Attribute> attributes) {
        WasDerivedFrom res = this.of.createWasDerivedFrom();
        res.setId(id);
        res.setUsedEntity(aid2);
        res.setGeneratedEntity(aid1);
        res.setActivity(aid);
        res.setGeneration(did1);
        res.setUsage(did2);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasDerivedFrom newWasDerivedFrom(WasDerivedFrom d) {
        WasDerivedFrom wdf = this.newWasDerivedFrom(d.getId(), d.getGeneratedEntity(), d.getUsedEntity());
        wdf.setActivity(d.getActivity());
        wdf.setGeneration(d.getGeneration());
        wdf.setUsage(d.getUsage());
        wdf.getOther().addAll(d.getOther());
        wdf.getType().addAll(d.getType());
        wdf.getLabel().addAll(d.getLabel());
        return wdf;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id) {
        WasEndedBy res = this.of.createWasEndedBy();
        res.setId(id);
        return res;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger) {
        WasEndedBy res = this.of.createWasEndedBy();
        res.setId(id);
        res.setActivity(activity);
        res.setTrigger(trigger);
        return res;
    }

    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender) {
        WasEndedBy res = this.newWasEndedBy(id, activity, trigger);
        res.setEnder(ender);
        return res;
    }

    @Override
    public WasEndedBy newWasEndedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName ender, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasEndedBy res = this.newWasEndedBy(id, activity, trigger);
        res.setTime(time);
        res.setEnder(ender);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasEndedBy newWasEndedBy(WasEndedBy u) {
        WasEndedBy u1 = this.newWasEndedBy(u.getId(), u.getActivity(), u.getTrigger());
        u1.setEnder(u.getEnder());
        u1.setTime(u.getTime());
        u1.getType().addAll(u.getType());
        u1.getLabel().addAll(u.getLabel());
        u1.getRole().addAll(u1.getRole());
        u1.getLocation().addAll(u.getLocation());
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    public WasGeneratedBy newWasGeneratedBy(Entity a, String role, Activity p) {
        return this.newWasGeneratedBy((QualifiedName)null, a, role, p);
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id) {
        WasGeneratedBy res = this.of.createWasGeneratedBy();
        res.setId(id);
        return res;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, Entity a, String role, Activity p) {
        WasGeneratedBy res = this.newWasGeneratedBy(id, a.getId(), p.getId());
        if (role != null) {
            this.addRole(res, this.newRole(role, this.getName().XSD_STRING));
        }
        return res;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName aid, String role, QualifiedName pid) {
        WasGeneratedBy res = this.of.createWasGeneratedBy();
        res.setId(id);
        res.setActivity(pid);
        res.setEntity(aid);
        if (role != null) {
            this.addRole(res, this.newRole(role, this.getName().XSD_STRING));
        }
        return res;
    }

    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        WasGeneratedBy res = this.newWasGeneratedBy(id, entity, null, activity);
        return res;
    }

    @Override
    public WasGeneratedBy newWasGeneratedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasGeneratedBy res = this.newWasGeneratedBy(id, entity, null, activity);
        res.setTime(time);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasGeneratedBy newWasGeneratedBy(WasGeneratedBy g) {
        WasGeneratedBy wgb = this.newWasGeneratedBy(g.getId(), g.getEntity(), null, g.getActivity());
        wgb.setId(g.getId());
        wgb.setTime(g.getTime());
        wgb.getOther().addAll(g.getOther());
        wgb.getRole().addAll(g.getRole());
        wgb.getType().addAll(g.getType());
        wgb.getLabel().addAll(g.getLabel());
        wgb.getLocation().addAll(g.getLocation());
        return wgb;
    }

    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer) {
        WasInfluencedBy res = this.of.createWasInfluencedBy();
        res.setId(id);
        res.setInfluencee(influencee);
        res.setInfluencer(influencer);
        return res;
    }

    @Override
    public WasInfluencedBy newWasInfluencedBy(QualifiedName id, QualifiedName influencee, QualifiedName influencer, Collection<Attribute> attributes) {
        WasInfluencedBy res = this.newWasInfluencedBy(id, influencee, influencer);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasInfluencedBy newWasInfluencedBy(WasInfluencedBy in) {
        WasInfluencedBy out = this.newWasInfluencedBy(in.getId(), in.getInfluencee(), in.getInfluencer());
        out.setId(in.getId());
        out.getOther().addAll(in.getOther());
        out.getType().addAll(in.getType());
        out.getLabel().addAll(in.getLabel());
        return out;
    }

    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName informed, QualifiedName informant) {
        WasInformedBy res = this.of.createWasInformedBy();
        res.setId(id);
        res.setInformed(informed);
        res.setInformant(informant);
        return res;
    }

    @Override
    public WasInformedBy newWasInformedBy(QualifiedName id, QualifiedName a2, QualifiedName a1, Collection<Attribute> attributes) {
        WasInformedBy res = this.newWasInformedBy(id, a2, a1);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasInformedBy newWasInformedBy(WasInformedBy d) {
        WasInformedBy wtb = this.newWasInformedBy(d.getId(), d.getInformed(), d.getInformant());
        wtb.setId(d.getId());
        wtb.getOther().addAll(d.getOther());
        wtb.getType().addAll(d.getType());
        wtb.getLabel().addAll(d.getLabel());
        return wtb;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName eid, QualifiedName aid) {
        WasInvalidatedBy res = this.of.createWasInvalidatedBy();
        res.setEntity(eid);
        res.setActivity(aid);
        return res;
    }

    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity) {
        WasInvalidatedBy res = this.of.createWasInvalidatedBy();
        res.setId(id);
        res.setEntity(entity);
        res.setActivity(activity);
        return res;
    }

    @Override
    public WasInvalidatedBy newWasInvalidatedBy(QualifiedName id, QualifiedName entity, QualifiedName activity, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasInvalidatedBy res = this.newWasInvalidatedBy(id, entity, activity);
        res.setTime(time);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasInvalidatedBy newWasInvalidatedBy(WasInvalidatedBy u) {
        WasInvalidatedBy u1 = this.newWasInvalidatedBy(u.getId(), u.getEntity(), u.getActivity());
        u1.setTime(u.getTime());
        u1.getOther().addAll(u.getOther());
        u1.getType().addAll(u.getType());
        u.getRole().addAll(u.getRole());
        u1.getLabel().addAll(u.getLabel());
        u1.getLocation().addAll(u.getLocation());
        return u1;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id) {
        WasStartedBy res = this.of.createWasStartedBy();
        res.setId(id);
        return res;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName aid, QualifiedName eid) {
        WasStartedBy res = this.of.createWasStartedBy();
        res.setId(id);
        res.setActivity(aid);
        res.setTrigger(eid);
        return res;
    }

    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter) {
        WasStartedBy res = this.newWasStartedBy(id, activity, trigger);
        res.setStarter(starter);
        return res;
    }

    @Override
    public WasStartedBy newWasStartedBy(QualifiedName id, QualifiedName activity, QualifiedName trigger, QualifiedName starter, XMLGregorianCalendar time, Collection<Attribute> attributes) {
        WasStartedBy res = this.newWasStartedBy(id, activity, trigger);
        res.setTime(time);
        res.setStarter(starter);
        this.setAttributes(res, attributes);
        return res;
    }

    public WasStartedBy newWasStartedBy(WasStartedBy u) {
        WasStartedBy u1 = this.newWasStartedBy(u.getId(), u.getActivity(), u.getTrigger());
        u1.setStarter(u.getStarter());
        u1.setTime(u.getTime());
        u1.getType().addAll(u.getType());
        u1.getRole().addAll(u.getRole());
        u1.getLabel().addAll(u.getLabel());
        u1.getLocation().addAll(u.getLocation());
        u1.getOther().addAll(u.getOther());
        return u1;
    }

    public XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar gc) {
        return this.dataFactory.newXMLGregorianCalendar(gc);
    }

    public XMLGregorianCalendar newYear(int year) {
        XMLGregorianCalendar res = this.dataFactory.newXMLGregorianCalendar();
        res.setYear(year);
        return res;
    }

    public Collection<Attribute> getAttributes(Statement statement) {
        Value val;
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        if (statement instanceof HasType) {
            result.addAll(((HasType)((Object)statement)).getType());
        }
        if (statement instanceof HasLocation) {
            result.addAll(((HasLocation)((Object)statement)).getLocation());
        }
        if (statement instanceof HasRole) {
            result.addAll(((HasRole)((Object)statement)).getRole());
        }
        if (statement instanceof HasValue && (val = ((HasValue)((Object)statement)).getValue()) != null) {
            result.add(val);
        }
        if (statement instanceof HasOther) {
            for (Other o : ((HasOther)((Object)statement)).getOther()) {
                result.add(o);
            }
        }
        return result;
    }

    public void setAttributes(HasOther res, Collection<Attribute> attributes) {
        if (attributes == null) {
            return;
        }
        if (attributes.isEmpty()) {
            return;
        }
        HasType typ = res instanceof HasType ? (HasType)((Object)res) : null;
        HasLocation loc = res instanceof HasLocation ? (HasLocation)((Object)res) : null;
        HasLabel lab = res instanceof HasLabel ? (HasLabel)((Object)res) : null;
        HasValue aval = res instanceof HasValue ? (HasValue)((Object)res) : null;
        HasRole rol = res instanceof HasRole ? (HasRole)((Object)res) : null;
        for (Attribute attr : attributes) {
            Object aValue = attr.getValue();
            ValueConverter vconv = new ValueConverter(this);
            if (this.getName().RDF_LITERAL.equals(attr.getType()) && aValue instanceof String) {
                aValue = vconv.convertToJava(attr.getType(), (String)aValue);
            }
            switch (attr.getKind()) {
                case PROV_LABEL: {
                    if (lab == null) break;
                    if (aValue instanceof LangString) {
                        lab.getLabel().add((LangString)aValue);
                        break;
                    }
                    lab.getLabel().add(this.newInternationalizedString(aValue.toString()));
                    break;
                }
                case PROV_LOCATION: {
                    if (loc == null) break;
                    loc.getLocation().add(this.newLocation(aValue, attr.getType()));
                    break;
                }
                case PROV_ROLE: {
                    if (rol == null) break;
                    rol.getRole().add(this.newRole(aValue, attr.getType()));
                    break;
                }
                case PROV_TYPE: {
                    if (typ == null) break;
                    typ.getType().add(this.newType(aValue, attr.getType()));
                    break;
                }
                case PROV_VALUE: {
                    if (aval == null) break;
                    aval.setValue(this.newValue(aValue, attr.getType()));
                    break;
                }
                case OTHER: {
                    res.getOther().add(this.newOther(attr.getElementName(), aValue, attr.getType()));
                    break;
                }
            }
        }
    }

    @Override
    public void startBundle(QualifiedName bundleId, Namespace namespaces) {
    }

    @Override
    public void startDocument(Namespace namespace) {
    }

    public Namespace newNamespace(Namespace ns) {
        return new Namespace(ns);
    }

    public Namespace newNamespace() {
        return new Namespace();
    }

    public AlternateOf newAlternateOf(AlternateOf s) {
        AlternateOf res = this.newAlternateOf(s.getAlternate1(), s.getAlternate2());
        return res;
    }

    public SpecializationOf newSpecializationOf(SpecializationOf s) {
        SpecializationOf res = this.newSpecializationOf(s.getSpecificEntity(), s.getGeneralEntity());
        return res;
    }

    public HadMember newHadMember(HadMember s) {
        HadMember res = this.newHadMember(s.getCollection(), s.getEntity());
        return res;
    }

    public <T extends Statement> T newStatement(T s) {
        return (T)((Statement)this.util.doAction(s, new Cloner()));
    }

    public class Cloner
    implements StatementActionValue {
        @Override
        public Object doAction(Activity s) {
            return ProvFactory.this.newActivity(s);
        }

        @Override
        public Object doAction(Used s) {
            return ProvFactory.this.newUsed(s);
        }

        @Override
        public Object doAction(WasStartedBy s) {
            return ProvFactory.this.newWasStartedBy(s);
        }

        @Override
        public Object doAction(Agent s) {
            return ProvFactory.this.newAgent(s);
        }

        @Override
        public Object doAction(AlternateOf s) {
            return ProvFactory.this.newAlternateOf(s);
        }

        @Override
        public Object doAction(WasAssociatedWith s) {
            return ProvFactory.this.newWasAssociatedWith(s);
        }

        @Override
        public Object doAction(WasAttributedTo s) {
            return ProvFactory.this.newWasAttributedTo(s);
        }

        @Override
        public Object doAction(WasInfluencedBy s) {
            return ProvFactory.this.newWasInfluencedBy(s);
        }

        @Override
        public Object doAction(ActedOnBehalfOf s) {
            return ProvFactory.this.newActedOnBehalfOf(s);
        }

        @Override
        public Object doAction(WasDerivedFrom s) {
            return ProvFactory.this.newWasDerivedFrom(s);
        }

        @Override
        public Object doAction(DictionaryMembership s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(DerivedByRemovalFrom s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(WasEndedBy s) {
            return ProvFactory.this.newWasEndedBy(s);
        }

        @Override
        public Object doAction(Entity s) {
            return ProvFactory.this.newEntity(s);
        }

        @Override
        public Object doAction(WasGeneratedBy s) {
            return ProvFactory.this.newWasGeneratedBy(s);
        }

        @Override
        public Object doAction(WasInvalidatedBy s) {
            return ProvFactory.this.newWasInvalidatedBy(s);
        }

        @Override
        public Object doAction(HadMember s) {
            return ProvFactory.this.newHadMember(s);
        }

        @Override
        public Object doAction(MentionOf s) {
            return ProvFactory.this.newMentionOf(s);
        }

        @Override
        public Object doAction(SpecializationOf s) {
            return ProvFactory.this.newSpecializationOf(s);
        }

        @Override
        public Object doAction(QualifiedSpecializationOf s) {
            return ProvFactory.this.newQualifiedSpecializationOf(s.getId(), s.getSpecificEntity(), s.getGeneralEntity(), ProvFactory.this.getAttributes(s));
        }

        @Override
        public Object doAction(QualifiedHadMember s) {
            return ProvFactory.this.newQualifiedHadMember(s.getId(), s.getCollection(), s.getEntity(), ProvFactory.this.getAttributes(s));
        }

        @Override
        public Object doAction(DerivedByInsertionFrom s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(WasInformedBy s) {
            return ProvFactory.this.newWasInformedBy(s);
        }

        @Override
        public Object doAction(Bundle s, ProvUtilities provUtilities) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAction(QualifiedAlternateOf s) {
            return ProvFactory.this.newQualifiedAlternateOf(s.getId(), s.getAlternate1(), s.getAlternate2(), ProvFactory.this.getAttributes(s));
        }
    }
}

