/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;

public class AttributeProcessor {
    private final Hashtable<String, Hashtable<String, List<Other>>> namespaceIndex = new Hashtable();
    private final List<Other> attributes;

    public AttributeProcessor(List<Other> attributes) {
        this.attributes = attributes;
    }

    public Hashtable<String, List<Other>> attributesWithNamespace(String namespace) {
        Hashtable<String, List<Other>> result = this.namespaceIndex.get(namespace);
        if (result == null) {
            result = new Hashtable();
            this.namespaceIndex.put(namespace, result);
        }
        for (Other attribute : this.attributes) {
            QualifiedName name = attribute.getElementName();
            if (!namespace.equals(name.getNamespaceURI())) continue;
            List<Other> ll = result.get(name.getLocalPart());
            if (ll == null) {
                LinkedList<Other> tmp = new LinkedList<Other>();
                tmp.add(attribute);
                result.put(name.getLocalPart(), tmp);
                continue;
            }
            ll.add(attribute);
        }
        return result;
    }
}

