/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeEscaper;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;

public class QualifiedNameUtils {
    public static final CharSequenceTranslator ESCAPE_PROV_LOCAL_NAME = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"=", "\\="}, {"'", "\\'"}, {"(", "\\("}, {")", "\\)"}, {",", "\\,"}, {":", "\\:"}, {";", "\\;"}, {"[", "\\["}, {"]", "\\]"}, {"<", "%3C"}, {">", "%3E"}, {"\\", "%5C"}}), UnicodeEscaper.outsideOf((int)32, (int)65535)});
    public static final CharSequenceTranslator UNESCAPE_PROV_LOCAL_NAME = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"\\=", "="}, {"\\'", "'"}, {"\\(", "("}, {"\\)", ")"}, {"\\,", ","}, {"\\-", "-"}, {"\\:", ":"}, {"\\;", ";"}, {"\\[", "["}, {"\\]", "]"}, {"\\.", "."}, {"%3C", "<"}, {"%3E", ">"}, {"%3c", "<"}, {"%3e", ">"}, {"%5C", "\\"}, {"%5c", "\\"}}), new UnicodeUnescaper()});
    public static final CharSequenceTranslator ESCAPE_UNICODE = new AggregateTranslator(new CharSequenceTranslator[]{UnicodeEscaper.outsideOf((int)32, (int)255)});
    public static final String INNER_ESCAPE = "_";
    public static final String START_ESCAPE = "_";
    public static final CharSequenceTranslator ESCAPE_TO_XML_QNAME_LOCAL_NAME = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"=", "_3D"}, {"'", "_27"}, {"(", "_28"}, {")", "_29"}, {",", "_2C"}, {"_", "__"}, {":", "_3A"}, {";", "_3B"}, {"[", "_5B"}, {"]", "_5D"}, {"/", "_2F"}, {"\\", "_5C"}, {"?", "_3F"}, {"@", "_40"}, {"~", "_7E"}, {"&", "_26"}, {"+", "_2B"}, {"*", "_2A"}, {"#", "_23"}, {"$", "_24"}, {"!", "_21"}, {"<", "_3C"}, {">", "_3E"}, {"%", "_25"}}), JavaUnicodeEscaper.outsideOf((int)32, (int)65535)});
    public static final CharSequenceTranslator UNESCAPE_FROM_XML_QNAME_LOCAL_NAME = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"_3D", "="}, {"_27", "'"}, {"_28", "("}, {"_29", ")"}, {"_2C", ","}, {"__", "_"}, {"_00", ""}, {"_3A", ":"}, {"_3B", ";"}, {"_5B", "["}, {"_5D", "]"}, {"_2F", "/"}, {"_5C", "\\"}, {"_3F", "?"}, {"_40", "@"}, {"_7E", "~"}, {"_26", "&"}, {"_2B", "+"}, {"_2A", "*"}, {"_23", "#"}, {"_24", "$"}, {"_21", "!"}, {"_3C", "<"}, {"_3E", ">"}, {"_25", "%"}}), new UnicodeUnescaper()});
    public static final CharSequenceTranslator UNESCAPE_UNICODE = new AggregateTranslator(new CharSequenceTranslator[]{new UnicodeUnescaper()});
    static final String PN_CHARS_U = "[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]";
    static final String PN_CHARS = "([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[0-9\\-\\u00B7\\u0300-\\u036F\\u203F-\\u2040])";
    static final String PN_CHARS_ESC = "((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))";
    static final String HEX = "[0-9A-Fa-f]";
    static final String PERCENT = "(%([0-9A-Fa-f])([0-9A-Fa-f]))";
    static final String PN_CHARS_OTHERS = "(([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f])))";
    static final String PN_LOCAL = "((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD])|([0-9])|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f]))))))((((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[0-9\\-\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))|(\\.)|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f]))))))*(((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[0-9\\-\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f])))))))?";
    static final Pattern pat = Pattern.compile("((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD])|([0-9])|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f]))))))((((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[0-9\\-\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))|(\\.)|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f]))))))*(((([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[0-9\\-\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))|((([/@~&\\+\\*\\?#$!])|((\\\\)([\\=\\'\\(\\)\\,\\-\\:\\;\\[\\]\\.]))|(%([0-9A-Fa-f])([0-9A-Fa-f])))))))?");
    static final String XML_NameStartChar = "[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]";
    static final String XML_NameChar = "([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[\\-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040])";
    static final String XML_Name = "[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD](([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[\\-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))*";
    static final String NC_NameChar = "([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[\\-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040])";
    static final String NC_NameStartChar = "[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]";
    static final String NC_Name = "[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD](([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[\\-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))*";
    static final Pattern NC_pat = Pattern.compile("[A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD](([A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[\\-\\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]))*");

    public String escapeProvLocalName(String localName) {
        if ("-".equals(localName)) {
            return "\\-";
        }
        String tmp = ESCAPE_PROV_LOCAL_NAME.translate((CharSequence)localName);
        int len = tmp.length();
        if (len > 0 && tmp.charAt(len - 1) == '.') {
            return tmp.substring(0, len - 1) + "\\.";
        }
        if (len > 0 && tmp.charAt(0) == '.') {
            return "\\." + tmp.substring(1);
        }
        return tmp;
    }

    public String unescapeProvLocalName(String localName) {
        return UNESCAPE_PROV_LOCAL_NAME.translate((CharSequence)localName);
    }

    public static final boolean isNCNameStartCharToEscape(char c) {
        return Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    public String escapeToXsdLocalName(String localName) {
        if ("".equals(localName)) {
            return "_";
        }
        String s = ESCAPE_TO_XML_QNAME_LOCAL_NAME.translate((CharSequence)localName);
        if (!QualifiedNameUtils.isNCNameStartCharToEscape(s.charAt(0))) {
            return "_" + s;
        }
        return s;
    }

    public String unescapeFromXsdLocalName(String localName) {
        if ("_".equals(localName)) {
            return "";
        }
        if (localName.charAt(0) == "_".charAt(0)) {
            localName = localName.substring(1);
        }
        String s = UNESCAPE_FROM_XML_QNAME_LOCAL_NAME.translate((CharSequence)localName);
        return s;
    }

    public String escapeUnicode(String name) {
        return ESCAPE_UNICODE.translate((CharSequence)name);
    }

    public String unescapeUnicode(String name) {
        return UNESCAPE_UNICODE.translate((CharSequence)name);
    }

    public boolean patternExactMatch(String input) {
        if ("".equals(input)) {
            return true;
        }
        Matcher match = pat.matcher(input);
        if (match.find()) {
            return match.start() == 0 && match.end() == input.length();
        }
        return false;
    }

    public boolean is_NC_Name(String input) {
        if ("".equals(input)) {
            return false;
        }
        Matcher match = NC_pat.matcher(input);
        if (match.matches()) {
            return match.start() == 0 && match.end() == input.length();
        }
        return false;
    }
}

