/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class Entity
implements org.openprovenance.prov.model.Entity,
Equals,
HashCode,
ToString,
HasAttributes {
    private final QualifiedName QUALIFIED_NAME_XSD_STRING;
    private Optional<QualifiedName> id;
    private List<LangString> labels;
    private List<Location> location;
    private List<Other> other;
    private List<Type> type;
    private Optional<Value> value;
    static final ProvUtilities u = new ProvUtilities();

    private Entity() {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.value = Optional.empty();
    }

    public Entity(QualifiedName id, Collection<Attribute> attributes) {
        this.QUALIFIED_NAME_XSD_STRING = ProvFactory.getFactory().getName().XSD_STRING;
        this.labels = new LinkedList<LangString>();
        this.location = new LinkedList<Location>();
        this.other = new LinkedList<Other>();
        this.type = new LinkedList<Type>();
        this.value = Optional.empty();
        this.setId(id);
        this.location = new LinkedList<Location>();
        this.type = new LinkedList<Type>();
        this.other = new LinkedList<Other>();
        Value[] valueHolder = new Value[]{null};
        u.populateAttributes(attributes, this.labels, this.location, this.type, new LinkedList<Role>(), this.other, valueHolder);
        this.value = Optional.ofNullable(valueHolder[0]);
    }

    @Override
    public void setValue(Value o) {
        this.value = Optional.ofNullable(o);
    }

    @Override
    public Value getValue() {
        return this.value.orElse(null);
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_ENTITY;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Location> getLocation() {
        return this.location;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof Entity)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        Entity that = (Entity)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Entity)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(this.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        if (this.value.isPresent()) {
            result.add(this.getValue());
        }
        result.addAll(this.getType());
        result.addAll(this.getLocation());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values_discard = new LinkedList<Value>();
        LinkedList<Role> roles_discard = new LinkedList<Role>();
        u.distribute((QualifiedName)qn, attributes, this.getLabel(), values_discard, this.getLocation(), this.getType(), roles_discard, this.getOther());
        if (!values_discard.isEmpty()) {
            this.value = Optional.of((Value)values_discard.get(0));
        }
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return u.split(this.getAttributes());
    }
}

