/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.vanilla;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.builder.Equals;
import org.openprovenance.apache.commons.lang.builder.EqualsBuilder;
import org.openprovenance.apache.commons.lang.builder.HashCode;
import org.openprovenance.apache.commons.lang.builder.HashCodeBuilder;
import org.openprovenance.apache.commons.lang.builder.ToString;
import org.openprovenance.apache.commons.lang.builder.ToStringBuilder;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Location;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Role;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Value;
import org.openprovenance.prov.vanilla.ActedOnBehalfOf;
import org.openprovenance.prov.vanilla.HasAttributes;
import org.openprovenance.prov.vanilla.Label;
import org.openprovenance.prov.vanilla.ProvUtilities;

public class Agent
implements org.openprovenance.prov.model.Agent,
Equals,
HashCode,
ToString,
HasAttributes {
    private Optional<QualifiedName> id;
    private List<LangString> labels = new LinkedList<LangString>();
    private List<Location> location = new LinkedList<Location>();
    private List<Other> other = new LinkedList<Other>();
    private List<Type> type = new LinkedList<Type>();
    static final ProvUtilities u = new ProvUtilities();

    private Agent() {
    }

    public Agent(QualifiedName id, Collection<Attribute> attributes) {
        this.setId(id);
        u.populateAttributes(attributes, this.labels, this.location, this.type, new LinkedList<Role>(), this.other, null);
    }

    @Override
    public QualifiedName getId() {
        return this.id.orElse(null);
    }

    @Override
    public StatementOrBundle.Kind getKind() {
        return StatementOrBundle.Kind.PROV_AGENT;
    }

    @Override
    public void setId(QualifiedName value) {
        this.id = Optional.ofNullable(value);
    }

    @Override
    public List<LangString> getLabel() {
        return this.labels;
    }

    @Override
    public List<Location> getLocation() {
        return this.location;
    }

    @Override
    public List<Type> getType() {
        return this.type;
    }

    @Override
    public List<Other> getOther() {
        return this.other;
    }

    @Override
    public void equals(Object object, EqualsBuilder equalsBuilder) {
        if (!(object instanceof Agent)) {
            equalsBuilder.appendSuper(false);
            return;
        }
        if (this == object) {
            return;
        }
        Agent that = (Agent)object;
        equalsBuilder.append(this.getId(), that.getId());
        equalsBuilder.append(this.getIndexedAttributes(), that.getIndexedAttributes());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Agent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        this.equals(object, equalsBuilder);
        return equalsBuilder.isEquals();
    }

    @Override
    public void hashCode(HashCodeBuilder hashCodeBuilder) {
        hashCodeBuilder.append(this.getId());
        hashCodeBuilder.append(this.getIndexedAttributes());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        this.hashCode(hashCodeBuilder);
        return hashCodeBuilder.toHashCode();
    }

    @Override
    public void toString(ToStringBuilder toStringBuilder) {
        Map<QualifiedName, Set<Attribute>> theAttributes = this.getIndexedAttributes();
        toStringBuilder.append("attributes", theAttributes);
        QualifiedName theId = this.getId();
        toStringBuilder.append("id", theId);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        this.toString(toStringBuilder);
        return toStringBuilder.toString();
    }

    @Override
    public Collection<Attribute> getAttributes() {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        result.addAll(this.getLabel().stream().map(s -> new Label(ActedOnBehalfOf.QUALIFIED_NAME_XSD_STRING, s)).collect(Collectors.toList()));
        result.addAll(this.getType());
        result.addAll(this.getLocation());
        result.addAll(this.getOther().stream().map(o -> o).collect(Collectors.toList()));
        return result;
    }

    public void setIndexedAttributes(Object qn, Set<Attribute> attributes) {
        LinkedList<Value> values = new LinkedList<Value>();
        LinkedList<Role> roles = new LinkedList<Role>();
        u.distribute((QualifiedName)qn, attributes, this.getLabel(), values, this.getLocation(), this.getType(), roles, this.getOther());
    }

    @Override
    public Map<QualifiedName, Set<Attribute>> getIndexedAttributes() {
        return u.split(this.getAttributes());
    }
}

